/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.Controller;
import com.sun.grizzly.Pipeline;
import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.net.ssl.SSLEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerThreadImpl
extends Thread
implements WorkerThread {
    protected Runnable target;
    protected ByteBuffer byteBuffer;
    protected Pipeline<Callable> pipeline;
    protected volatile boolean execute = true;
    protected static final ThreadGroup threadGroup = new ThreadGroup("Grizzly");
    protected ByteBuffer inputBB;
    protected ByteBuffer outputBB;
    protected SSLEngine sslEngine;
    private ThreadAttachment threadAttachment = new ThreadAttachment();

    public WorkerThreadImpl(ThreadGroup threadGroup, Runnable runnable) {
        super(threadGroup, runnable);
        this.setDaemon(true);
        this.target = runnable;
        this.byteBuffer = ByteBufferFactory.allocateView(8192, false);
    }

    public WorkerThreadImpl(Pipeline<Callable> pipeline, String name) {
        super(threadGroup, name);
        this.pipeline = pipeline;
        this.setDaemon(true);
        this.byteBuffer = ByteBufferFactory.allocateView(8192, false);
    }

    @Override
    public void run() {
        if (this.target != null) {
            this.target.run();
            return;
        }
        while (this.execute) {
            try {
                Callable t = this.pipeline.waitForIoTask();
                if (t == null) continue;
                t.call();
                t = null;
            }
            catch (Throwable t) {
                if (this.byteBuffer != null) {
                    this.byteBuffer.clear();
                }
                if (this.inputBB != null) {
                    this.inputBB.clear();
                }
                if (this.outputBB != null) {
                    this.outputBB.clear();
                }
                if (this.execute) {
                    Controller.logger().log(Level.SEVERE, "WorkerThreadImpl unexpected exception: ", t);
                    continue;
                }
                Controller.logger().log(Level.FINE, "WorkerThreadImpl unexpected exception, when WorderThread supposed to be closed: ", t);
            }
        }
    }

    public void terminate() {
        this.execute = false;
    }

    @Override
    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public ByteBuffer getInputBB() {
        return this.inputBB;
    }

    public void setInputBB(ByteBuffer inputBB) {
        this.inputBB = inputBB;
    }

    public ByteBuffer getOutputBB() {
        return this.outputBB;
    }

    public void setOutputBB(ByteBuffer outputBB) {
        this.outputBB = outputBB;
    }

    public SSLEngine getSSLEngine() {
        return this.sslEngine;
    }

    public void setSSLEngine(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThreadAttachment detach(boolean copyState) {
        try {
            this.threadAttachment.setByteBuffer(this.byteBuffer);
            this.threadAttachment.setSSLEngine(this.sslEngine);
            this.threadAttachment.setInputBB(this.inputBB);
            this.threadAttachment.setOutputBB(this.outputBB);
            ThreadAttachment threadAttachment = this.threadAttachment;
            return threadAttachment;
        }
        finally {
            if (copyState) {
                ThreadAttachment newTA;
                this.byteBuffer = ByteBufferFactory.allocateView(8192, false);
                this.threadAttachment = newTA = new ThreadAttachment();
            }
            this.threadAttachment.setThreadId(this.getName() + "-" + this.getId());
        }
    }

    @Override
    public void attach(ThreadAttachment threadAttachment) {
        this.byteBuffer = threadAttachment.getByteBuffer();
        this.sslEngine = threadAttachment.getSSLEngine();
        this.inputBB = threadAttachment.getInputBB();
        this.outputBB = threadAttachment.getOutputBB();
        this.threadAttachment = threadAttachment;
        threadAttachment.setThreadId(this.getName() + "-" + this.getId());
    }
}

