/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.OutputWriter;
import com.sun.grizzly.util.SSLUtils;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

public final class SSLOutputWriter {
    public static long flushChannel(SocketChannel socketChannel, ByteBuffer bb) throws IOException {
        WorkerThreadImpl workerThread = (WorkerThreadImpl)Thread.currentThread();
        SSLEngine sslEngine = workerThread.getSSLEngine();
        ByteBuffer outputBB = workerThread.getOutputBB();
        return SSLOutputWriter.flushChannel(socketChannel, bb, outputBB, sslEngine);
    }

    public static long flushChannel(SocketChannel socketChannel, ByteBuffer bb, ByteBuffer outputBB, SSLEngine sslEngine) throws IOException {
        long nWrite = 0L;
        while (bb.hasRemaining()) {
            SSLEngineResult result = SSLUtils.wrap(bb, outputBB, sslEngine);
            switch (result.getStatus()) {
                case OK: {
                    if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) break;
                    SSLUtils.executeDelegatedTask(sslEngine);
                    break;
                }
                default: {
                    throw new IOException("SSLOutputWriter: " + (Object)((Object)result.getStatus()));
                }
            }
            if (!outputBB.hasRemaining()) continue;
            nWrite += OutputWriter.flushChannel(socketChannel, outputBB);
        }
        outputBB.clear();
        return nWrite;
    }
}

