/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.SelectorFactory;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public class OutputWriter {
    private static int defaultWriteTimeout = 30000;

    public static long flushChannel(SocketChannel socketChannel, ByteBuffer bb) throws IOException {
        return OutputWriter.flushChannel(socketChannel, bb, (long)defaultWriteTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long flushChannel(SocketChannel socketChannel, ByteBuffer bb, long writeTimeout) throws IOException {
        if (bb == null) {
            throw new IllegalStateException("Invalid Response State. ByteBuffer cannot be null.");
        }
        if (socketChannel == null) {
            throw new IllegalStateException("Invalid Response State. SocketChannel cannot be null.");
        }
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        int bytesProduced = 0;
        try {
            while (bb.hasRemaining()) {
                int len = socketChannel.write(bb);
                ++attempts;
                if (len < 0) {
                    throw new EOFException();
                }
                bytesProduced += len;
                if (len == 0) {
                    if (writeSelector == null && (writeSelector = SelectorFactory.getSelector()) == null) continue;
                    key = socketChannel.register(writeSelector, 4);
                    if (writeSelector.select(writeTimeout) == 0) {
                        if (attempts <= 2) continue;
                        throw new IOException("Client disconnected");
                    }
                    --attempts;
                    continue;
                }
                attempts = 0;
            }
        }
        finally {
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector != null) {
                writeSelector.selectNow();
                SelectorFactory.returnSelector(writeSelector);
            }
        }
        return bytesProduced;
    }

    public static long flushChannel(SocketChannel socketChannel, ByteBuffer[] bb) throws IOException {
        return OutputWriter.flushChannel(socketChannel, bb, (long)defaultWriteTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long flushChannel(SocketChannel socketChannel, ByteBuffer[] bb, long writeTimeout) throws IOException {
        long byteProduced;
        if (bb == null) {
            throw new IllegalStateException("Invalid Response State. ByteBuffer cannot be null.");
        }
        if (socketChannel == null) {
            throw new IllegalStateException("Invalid Response State. SocketChannel cannot be null.");
        }
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        long totalBytes = 0L;
        for (ByteBuffer aBb : bb) {
            totalBytes += (long)aBb.remaining();
        }
        try {
            long len;
            for (byteProduced = 0L; byteProduced < totalBytes; byteProduced += len) {
                len = socketChannel.write(bb);
                ++attempts;
                if (len < 0L) {
                    throw new EOFException();
                }
                if (len == 0L) {
                    if (writeSelector == null && (writeSelector = SelectorFactory.getSelector()) == null) continue;
                    key = socketChannel.register(writeSelector, 4);
                    if (writeSelector.select(writeTimeout) == 0) {
                        if (attempts <= 2) continue;
                        throw new IOException("Client disconnected");
                    }
                    --attempts;
                    continue;
                }
                attempts = 0;
            }
        }
        finally {
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector != null) {
                writeSelector.selectNow();
                SelectorFactory.returnSelector(writeSelector);
            }
        }
        return byteProduced;
    }

    public static long flushChannel(DatagramChannel datagramChannel, SocketAddress socketAddress, ByteBuffer bb) throws IOException {
        return OutputWriter.flushChannel(datagramChannel, socketAddress, bb, defaultWriteTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long flushChannel(DatagramChannel datagramChannel, SocketAddress socketAddress, ByteBuffer bb, long writeTimeout) throws IOException {
        if (bb == null) {
            throw new IllegalStateException("Invalid Response State. ByteBuffer cannot be null.");
        }
        if (datagramChannel == null) {
            throw new IllegalStateException("Invalid Response State. DatagramChannel cannot be null.");
        }
        if (socketAddress == null) {
            throw new IllegalStateException("Invalid Response State. SocketAddress cannot be null.");
        }
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        int bytesProduced = 0;
        try {
            while (bb.hasRemaining()) {
                int len = datagramChannel.send(bb, socketAddress);
                ++attempts;
                if (len < 0) {
                    throw new EOFException();
                }
                bytesProduced += len;
                if (len == 0) {
                    if (writeSelector == null && (writeSelector = SelectorFactory.getSelector()) == null) continue;
                    key = datagramChannel.register(writeSelector, 4);
                    if (writeSelector.select(writeTimeout) == 0) {
                        if (attempts <= 2) continue;
                        throw new IOException("Client disconnected");
                    }
                    --attempts;
                    continue;
                }
                attempts = 0;
            }
        }
        finally {
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector != null) {
                writeSelector.selectNow();
                SelectorFactory.returnSelector(writeSelector);
            }
        }
        return bytesProduced;
    }

    public static int getDefaultWriteTimeout() {
        return defaultWriteTimeout;
    }

    public static void setDefaultWriteTimeout(int aDefaultWriteTimeout) {
        defaultWriteTimeout = aDefaultWriteTimeout;
    }
}

