/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.util.SSLUtils;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SSLReadFilter
implements ProtocolFilter {
    public static final String HANDSHAKE = "handshake";
    protected SSLContext sslContext;
    private String[] enabledCipherSuites = null;
    private String[] enabledProtocols = null;
    private boolean clientMode = false;
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;
    public static final String EXPIRE_TIME = "expireTime";
    private boolean isProtocolConfigured = false;
    private boolean isCipherConfigured = false;
    protected int inputBBSize = 20480;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context ctx) throws IOException {
        WorkerThreadImpl workerThread;
        boolean result = true;
        int count = 0;
        Throwable exception = null;
        SelectionKey key = ctx.getSelectionKey();
        try {
            workerThread = (WorkerThreadImpl)Thread.currentThread();
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        SSLEngine sslEngine = this.newSSLEngine(key);
        workerThread.setSSLEngine(sslEngine);
        key.attach(sslEngine);
        ctx.setProtocol(Controller.Protocol.TLS);
        boolean hasHandshake = Boolean.TRUE.equals(sslEngine.getSession().getValue(HANDSHAKE));
        try {
            this.allocateBuffers();
            if (hasHandshake) {
                count = this.doRead(key);
            } else if (this.doHandshake(key, SSLUtils.getReadTimeout())) {
                hasHandshake = true;
                sslEngine.getSession().putValue(HANDSHAKE, Boolean.TRUE);
            } else {
                count = -1;
            }
        }
        catch (IOException ex) {
            exception = ex;
            this.log("SSLReadFilter.execute", ex);
        }
        catch (Throwable ex) {
            exception = ex;
            this.log("SSLReadFilter.execute", ex);
        }
        finally {
            if (exception != null || count == -1) {
                ctx.setAttribute("throwable", exception);
                ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                result = false;
            }
        }
        return result;
    }

    public boolean postExecute(Context ctx) throws IOException {
        ctx.setProtocol(Controller.Protocol.TLS);
        if (ctx.getKeyRegistrationState() == Context.KeyRegistrationState.CANCEL) {
            ctx.getController().cancelKey(ctx.getSelectionKey());
        } else if (ctx.getKeyRegistrationState() == Context.KeyRegistrationState.REGISTER) {
            ((SSLEngine)ctx.getSelectionKey().attachment()).getSession().putValue(EXPIRE_TIME, System.currentTimeMillis());
            ctx.getController().registerKey(ctx.getSelectionKey(), 1, ctx.getProtocol());
        }
        return true;
    }

    protected void allocateBuffers() {
        ByteBuffer newBB;
        WorkerThreadImpl workerThread = (WorkerThreadImpl)Thread.currentThread();
        ByteBuffer byteBuffer = workerThread.getByteBuffer();
        ByteBuffer outputBB = workerThread.getOutputBB();
        ByteBuffer inputBB = workerThread.getInputBB();
        int expectedSize = workerThread.getSSLEngine().getSession().getPacketBufferSize();
        if (this.inputBBSize < expectedSize) {
            this.inputBBSize = expectedSize;
        }
        if (inputBB != null && inputBB.capacity() < this.inputBBSize) {
            newBB = ByteBuffer.allocate(this.inputBBSize);
            inputBB.flip();
            newBB.put(inputBB);
            inputBB = newBB;
        } else if (inputBB == null) {
            inputBB = ByteBuffer.allocate(this.inputBBSize);
        }
        if (outputBB == null) {
            outputBB = ByteBuffer.allocate(this.inputBBSize);
        }
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocate(this.inputBBSize * 2);
        }
        if ((expectedSize = workerThread.getSSLEngine().getSession().getApplicationBufferSize()) > byteBuffer.capacity()) {
            newBB = ByteBuffer.allocate(expectedSize);
            byteBuffer.flip();
            newBB.put(byteBuffer);
            byteBuffer = newBB;
        }
        workerThread.setInputBB(inputBB);
        workerThread.setOutputBB(outputBB);
        workerThread.setByteBuffer(byteBuffer);
        outputBB.position(0);
        outputBB.limit(0);
    }

    protected boolean doHandshake(SelectionKey key, int timeout) throws IOException {
        WorkerThreadImpl workerThread = (WorkerThreadImpl)Thread.currentThread();
        ByteBuffer byteBuffer = workerThread.getByteBuffer();
        ByteBuffer outputBB = workerThread.getOutputBB();
        ByteBuffer inputBB = workerThread.getInputBB();
        SSLEngine sslEngine = workerThread.getSSLEngine();
        SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        boolean OK = true;
        try {
            byteBuffer = SSLUtils.doHandshake((SocketChannel)key.channel(), byteBuffer, inputBB, outputBB, sslEngine, handshakeStatus, timeout);
            if (this.doRead(key) == -1) {
                throw new EOFException();
            }
        }
        catch (EOFException ex) {
            Logger logger = Controller.logger();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "doHandshake", ex);
            }
            OK = false;
        }
        return OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRead(SelectionKey key) {
        WorkerThreadImpl workerThread = (WorkerThreadImpl)Thread.currentThread();
        ByteBuffer byteBuffer = workerThread.getByteBuffer();
        ByteBuffer outputBB = workerThread.getOutputBB();
        ByteBuffer inputBB = workerThread.getInputBB();
        SSLEngine sslEngine = workerThread.getSSLEngine();
        int count = -1;
        try {
            count = ((SocketChannel)key.channel()).read(inputBB);
            if (count != -1) {
                byteBuffer = SSLUtils.unwrapAll(byteBuffer, inputBB, sslEngine);
                workerThread.setInputBB(inputBB);
                workerThread.setOutputBB(outputBB);
                workerThread.setByteBuffer(byteBuffer);
            }
            int n = count;
            return n;
        }
        catch (IOException ex) {
            int n = -1;
            return n;
        }
        finally {
            if (count == -1) {
                try {
                    sslEngine.closeInbound();
                }
                catch (SSLException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] doPeerCertificateChain(SelectionKey key, boolean needClientAuth) throws IOException {
        Certificate[] certs;
        Logger logger;
        block20: {
            SSLEngine sslEngine;
            ByteBuffer outputBB;
            ByteBuffer byteBuffer;
            WorkerThreadImpl workerThread;
            block18: {
                logger = Controller.logger();
                workerThread = (WorkerThreadImpl)Thread.currentThread();
                byteBuffer = workerThread.getByteBuffer();
                outputBB = workerThread.getOutputBB();
                sslEngine = workerThread.getSSLEngine();
                certs = null;
                try {
                    certs = sslEngine.getSession().getPeerCertificates();
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.FINE)) break block18;
                    logger.log(Level.FINE, "Error getting client certs", t);
                }
            }
            if (certs == null && needClientAuth) {
                sslEngine.getSession().invalidate();
                sslEngine.setNeedClientAuth(true);
                sslEngine.beginHandshake();
                ByteBuffer origBB = byteBuffer;
                byteBuffer = origBB.position() != origBB.limit() ? ByteBuffer.allocate(origBB.capacity()) : origBB;
                byteBuffer.clear();
                outputBB.position(0);
                outputBB.limit(0);
                try {
                    this.doHandshake(key, 0);
                }
                catch (Throwable ex) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Error during handshake", ex);
                    }
                    Object[] objectArray = null;
                    return objectArray;
                }
                finally {
                    byteBuffer = origBB;
                    workerThread.setByteBuffer(byteBuffer);
                    byteBuffer.clear();
                }
                try {
                    certs = sslEngine.getSession().getPeerCertificates();
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.FINE)) break block20;
                    logger.log(Level.FINE, "Error getting client certs", t);
                }
            }
        }
        if (certs == null) {
            return null;
        }
        Object[] x509Certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            if (certs[i] instanceof X509Certificate) {
                x509Certs[i] = (X509Certificate)certs[i];
            } else {
                try {
                    byte[] buffer = certs[i].getEncoded();
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                    x509Certs[i] = (X509Certificate)cf.generateCertificate(stream);
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Error translating cert " + certs[i], ex);
                    return null;
                }
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.log(Level.FINE, "Cert #" + i + " = " + x509Certs[i]);
        }
        if (x509Certs.length < 1) {
            return null;
        }
        return x509Certs;
    }

    protected SSLEngine newSSLEngine() {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        if (this.enabledCipherSuites != null) {
            if (!this.isCipherConfigured) {
                this.enabledCipherSuites = SSLReadFilter.configureEnabledCiphers(sslEngine, this.enabledCipherSuites);
                this.isCipherConfigured = true;
            }
            sslEngine.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            if (!this.isProtocolConfigured) {
                this.enabledProtocols = SSLReadFilter.configureEnabledProtocols(sslEngine, this.enabledProtocols);
                this.isProtocolConfigured = true;
            }
            sslEngine.setEnabledProtocols(this.enabledProtocols);
        }
        sslEngine.setUseClientMode(this.clientMode);
        return sslEngine;
    }

    protected SSLEngine newSSLEngine(SelectionKey key) {
        SSLEngine sslEngine = null;
        sslEngine = key.attachment() == null ? this.newSSLEngine() : (key.attachment() instanceof SSLEngine ? (SSLEngine)key.attachment() : this.newSSLEngine());
        sslEngine.setWantClientAuth(this.wantClientAuth);
        sslEngine.getSession().removeValue(EXPIRE_TIME);
        sslEngine.setNeedClientAuth(this.needClientAuth);
        return sslEngine;
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    private static final String[] configureEnabledProtocols(SSLEngine sslEngine, String[] requestedProtocols) {
        String[] supportedProtocols = sslEngine.getSupportedProtocols();
        String[] protocols = null;
        ArrayList<String> list = null;
        block0: for (String supportedProtocol : supportedProtocols) {
            for (String protocol : requestedProtocols) {
                if (!supportedProtocol.equals(protocol = protocol.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(protocol);
                continue block0;
            }
        }
        if (list != null) {
            protocols = list.toArray(new String[list.size()]);
        }
        return protocols;
    }

    private static final String[] configureEnabledCiphers(SSLEngine sslEngine, String[] requestedCiphers) {
        String[] supportedCiphers = sslEngine.getSupportedCipherSuites();
        String[] ciphers = null;
        ArrayList<String> list = null;
        block0: for (String supportedCipher : supportedCiphers) {
            for (String cipher : requestedCiphers) {
                if (!supportedCipher.equals(cipher = cipher.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(cipher);
                continue block0;
            }
        }
        if (list != null) {
            ciphers = list.toArray(new String[list.size()]);
        }
        return ciphers;
    }

    protected void log(String msg, Throwable t) {
        if (Controller.logger().isLoggable(Level.FINE)) {
            Controller.logger().log(Level.FINE, "ReadFilter,execute()", t);
        }
    }
}

