/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ProtocolParser;
import com.sun.grizzly.filter.ReadFilter;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;

public abstract class ParserProtocolFilter
extends ReadFilter {
    public boolean execute(Context ctx) throws IOException {
        boolean continueExecution = super.execute(ctx);
        if (!continueExecution) {
            return continueExecution;
        }
        return this.invokeProtocolParser(ctx, this.newProtocolParser());
    }

    public boolean invokeProtocolParser(Context ctx, ProtocolParser protocolParser) {
        if (protocolParser == null) {
            throw new IllegalStateException("ProcotolParser cannot be null");
        }
        boolean continueExecution = true;
        WorkerThread workerThread = (WorkerThread)((Object)Thread.currentThread());
        ByteBuffer byteBuffer = workerThread.getByteBuffer();
        SelectionKey key = ctx.getSelectionKey();
        Controller.Protocol protocol = ctx.getProtocol();
        protocolParser.parseBytes(byteBuffer);
        byteBuffer.limit(protocolParser.getNextEndPosition());
        byteBuffer.position(protocolParser.getNextStartPosition());
        if (protocolParser.isExpectingMoreData()) {
            ThreadAttachment threadAttachment = workerThread.detach(true);
            key.attach(threadAttachment);
            ctx.getController().registerKey(key, 1, protocol);
            continueExecution = false;
        }
        return continueExecution;
    }

    public abstract ProtocolParser newProtocolParser();
}

