/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.connectioncache.server;

import com.sun.grizzly.DefaultSelectionKeyHandler;
import com.sun.grizzly.connectioncache.spi.transport.ConnectionCacheFactory;
import com.sun.grizzly.connectioncache.spi.transport.InboundConnectionCache;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;

public class CacheableSelectionKeyHandler
extends DefaultSelectionKeyHandler {
    private InboundConnectionCache<SelectableChannel> inboundConnectionCache;

    public CacheableSelectionKeyHandler(int highWaterMark, int numberToReclaim) {
        this.inboundConnectionCache = ConnectionCacheFactory.makeBlockingInboundConnectionCache("Grizzly inbound connection cache", highWaterMark, numberToReclaim, this.getLogger());
    }

    public void process(SelectionKey key) {
        super.process(key);
        this.inboundConnectionCache.requestReceived(key.channel());
    }

    public void postProcess(SelectionKey key) {
        SelectableChannel channel = key.channel();
        this.inboundConnectionCache.requestProcessed(channel, 1);
        this.inboundConnectionCache.responseSent(channel);
    }

    public void cancel(SelectionKey key) {
        super.cancel(key);
        this.inboundConnectionCache.close(key.channel());
    }
}

