/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.ConnectorInstanceHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.UDPConnectorHandler;
import com.sun.grizzly.util.Copyable;
import java.io.IOException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDPSelectorHandler
extends TCPSelectorHandler {
    private static final String NOT_SUPPORTED = "Not supported by this SelectorHandler";
    protected DatagramSocket datagramSocket;
    protected DatagramChannel datagramChannel;

    public UDPSelectorHandler() {
    }

    public UDPSelectorHandler(boolean isClient) {
        super(isClient);
    }

    @Override
    public void copyTo(Copyable copy) {
        super.copyTo(copy);
        UDPSelectorHandler copyHandler = (UDPSelectorHandler)copy;
        copyHandler.datagramSocket = this.datagramSocket;
        copyHandler.datagramChannel = this.datagramChannel;
    }

    @Override
    public void preSelect(Context ctx) throws IOException {
        if (this.selector == null) {
            try {
                this.connectorInstanceHandler = new ConnectorInstanceHandler.ConcurrentQueueDelegateCIH<ConnectorHandler>(this.getConnectorInstanceHandlerDelegate());
                this.datagramChannel = DatagramChannel.open();
                this.datagramChannel.configureBlocking(false);
                this.selector = Selector.open();
                this.datagramSocket = this.datagramChannel.socket();
                this.datagramSocket.setReuseAddress(this.reuseAddress);
                if (this.inet == null) {
                    this.datagramSocket.bind(new InetSocketAddress(this.port));
                } else {
                    this.datagramSocket.bind(new InetSocketAddress(this.inet, this.port));
                }
                this.datagramChannel.configureBlocking(false);
                this.datagramChannel.register(this.selector, 1);
            }
            catch (SocketException ex) {
                throw new BindException(ex.getMessage() + ": " + this.port);
            }
            this.datagramSocket.setSoTimeout(this.serverTimeout);
        } else {
            this.onReadOps();
            this.onWriteOps();
            this.onConnectOps(ctx);
        }
    }

    @Override
    protected void onConnectOps(Context ctx) throws IOException {
        if (this.opConnectToRegister == null) {
            this.opConnectToRegister = new ConcurrentHashMap();
        }
        if (!this.opConnectToRegister.isEmpty()) {
            for (SocketAddress[] remoteLocal : this.opConnectToRegister.keySet()) {
                DatagramChannel datagramChannel = DatagramChannel.open();
                datagramChannel.socket().setReuseAddress(true);
                if (remoteLocal[1] != null) {
                    datagramChannel.socket().bind(remoteLocal[1]);
                }
                datagramChannel.configureBlocking(false);
                datagramChannel.connect(remoteLocal[0]);
                SelectionKey key = datagramChannel.register(this.selector, 5, this.opConnectToRegister.remove(remoteLocal));
                this.onConnectInterest(key, ctx);
            }
        }
    }

    @Override
    public void shutdown() {
        try {
            if (this.datagramSocket != null) {
                this.datagramSocket.close();
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "closeSocketException", ex);
        }
        try {
            if (this.datagramChannel != null) {
                this.datagramChannel.close();
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "closeSocketException", ex);
        }
        try {
            if (this.selector != null) {
                this.selector.close();
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "closeSocketException", ex);
        }
    }

    @Override
    public boolean onAcceptInterest(SelectionKey key, Context ctx) throws IOException {
        return false;
    }

    @Override
    public Controller.Protocol protocol() {
        return Controller.Protocol.UDP;
    }

    @Override
    public int getPortLowLevel() {
        if (this.datagramSocket != null) {
            return this.datagramSocket.getLocalPort();
        }
        return -1;
    }

    @Override
    public int getSsBackLog() {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void setSsBackLog(int ssBackLog) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public boolean isTcpNoDelay() {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void setTcpNoDelay(boolean tcpNoDelay) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public int getLinger() {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void setLinger(int linger) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public int getSocketTimeout() {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    public void setSocketTimeout(int socketTimeout) {
        throw new IllegalStateException(NOT_SUPPORTED);
    }

    @Override
    protected Callable<ConnectorHandler> getConnectorInstanceHandlerDelegate() {
        return new Callable<ConnectorHandler>(){

            @Override
            public ConnectorHandler call() throws Exception {
                return new UDPConnectorHandler();
            }
        };
    }
}

