/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.ConnectorInstanceHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.Pipeline;
import com.sun.grizzly.PipelineFullException;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.TCPConnectorHandler;
import com.sun.grizzly.util.Copyable;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPSelectorHandler
implements SelectorHandler {
    protected ConnectorInstanceHandler connectorInstanceHandler;
    protected ConcurrentLinkedQueue<SelectionKey> opReadToRegister;
    protected ConcurrentHashMap<SocketAddress[], CallbackHandler> opConnectToRegister;
    protected ConcurrentLinkedQueue<SelectionKey> opWriteToRegister;
    protected boolean tcpNoDelay = false;
    protected boolean reuseAddress = true;
    protected int linger = 100;
    protected int socketTimeout = -1;
    protected Logger logger;
    protected int serverTimeout = 0;
    protected InetAddress inet;
    protected int port = 18888;
    protected ServerSocket serverSocket;
    protected ServerSocketChannel serverSocketChannel;
    protected Selector selector;
    protected long selectTimeout = 1000L;
    protected int ssBackLog = 4096;
    protected boolean isClient = false;
    protected SelectionKeyHandler selectionKeyHandler;

    public TCPSelectorHandler() {
    }

    public TCPSelectorHandler(boolean isClient) {
        this.isClient = isClient;
    }

    @Override
    public void copyTo(Copyable copy) {
        TCPSelectorHandler copyHandler = (TCPSelectorHandler)copy;
        copyHandler.selector = this.selector;
        copyHandler.selectTimeout = this.selectTimeout;
        copyHandler.serverTimeout = this.serverTimeout;
        copyHandler.inet = this.inet;
        copyHandler.port = this.port;
        copyHandler.ssBackLog = this.ssBackLog;
        copyHandler.tcpNoDelay = this.tcpNoDelay;
        copyHandler.linger = this.linger;
        copyHandler.socketTimeout = this.socketTimeout;
        copyHandler.logger = this.logger;
        copyHandler.reuseAddress = this.reuseAddress;
        copyHandler.connectorInstanceHandler = this.connectorInstanceHandler;
    }

    @Override
    public Set<SelectionKey> keys() {
        if (this.selector != null) {
            return this.selector.keys();
        }
        throw new IllegalStateException("Selector is not created!");
    }

    @Override
    public boolean isOpen() {
        if (this.selector != null) {
            return this.selector.isOpen();
        }
        return false;
    }

    @Override
    public void preSelect(Context ctx) throws IOException {
        if (this.selector == null) {
            try {
                this.connectorInstanceHandler = new ConnectorInstanceHandler.ConcurrentQueueDelegateCIH<ConnectorHandler>(this.getConnectorInstanceHandlerDelegate());
                this.selector = Selector.open();
                if (!this.isClient) {
                    this.serverSocketChannel = ServerSocketChannel.open();
                    this.serverSocket = this.serverSocketChannel.socket();
                    this.serverSocket.setReuseAddress(this.reuseAddress);
                    if (this.inet == null) {
                        this.serverSocket.bind(new InetSocketAddress(this.port), this.ssBackLog);
                    } else {
                        this.serverSocket.bind(new InetSocketAddress(this.inet, this.port), this.ssBackLog);
                    }
                    this.serverSocketChannel.configureBlocking(false);
                    this.serverSocketChannel.register(this.selector, 16);
                }
            }
            catch (SocketException ex) {
                throw new BindException(ex.getMessage() + ": " + this.port + "=" + this);
            }
            if (!this.isClient) {
                this.serverSocket.setSoTimeout(this.serverTimeout);
            }
        } else {
            this.onReadOps();
            this.onWriteOps();
            this.onConnectOps(ctx);
        }
    }

    protected void onReadOps() {
        if (this.opReadToRegister == null) {
            this.opReadToRegister = new ConcurrentLinkedQueue();
        }
        long currentTime = System.currentTimeMillis();
        int size = 0;
        if (!this.opReadToRegister.isEmpty()) {
            size = this.opReadToRegister.size();
            for (int i = 0; i < size; ++i) {
                SelectionKey key = this.opReadToRegister.poll();
                if (!key.isValid()) continue;
                key.interestOps(key.interestOps() | 1);
                this.selectionKeyHandler.register(key, currentTime);
            }
        }
    }

    protected void onWriteOps() {
        if (this.opWriteToRegister == null) {
            this.opWriteToRegister = new ConcurrentLinkedQueue();
        }
        long currentTime = System.currentTimeMillis();
        int size = 0;
        if (!this.opWriteToRegister.isEmpty()) {
            size = this.opWriteToRegister.size();
            for (int i = 0; i < size; ++i) {
                SelectionKey key = this.opWriteToRegister.poll();
                if (!key.isValid()) continue;
                key.interestOps(key.interestOps() | 4);
                this.selectionKeyHandler.register(key, currentTime);
            }
        }
    }

    protected void onConnectOps(Context ctx) throws IOException {
        if (this.opConnectToRegister == null) {
            this.opConnectToRegister = new ConcurrentHashMap();
        }
        if (!this.opConnectToRegister.isEmpty()) {
            for (SocketAddress[] remoteLocal : this.opConnectToRegister.keySet()) {
                SocketChannel socketChannel = SocketChannel.open();
                socketChannel.socket().setReuseAddress(true);
                if (remoteLocal[1] != null) {
                    socketChannel.socket().bind(remoteLocal[1]);
                }
                socketChannel.configureBlocking(false);
                boolean isConnected = socketChannel.connect(remoteLocal[0]);
                SelectionKey key = socketChannel.register(this.selector, 8, this.opConnectToRegister.remove(remoteLocal));
                if (!isConnected) continue;
                this.onConnectInterest(key, ctx);
            }
        }
    }

    @Override
    public Set<SelectionKey> select(Context ctx) throws IOException {
        this.selector.select(this.selectTimeout);
        return this.selector.selectedKeys();
    }

    @Override
    public void postSelect(Context ctx) {
    }

    @Override
    public void register(SelectionKey key, int ops) {
        if (ops == 1) {
            this.opReadToRegister.offer(key);
        } else if (ops == 4) {
            this.opWriteToRegister.offer(key);
        } else if (ops == 5) {
            this.opReadToRegister.offer(key);
            this.opWriteToRegister.offer(key);
        }
        this.selector.wakeup();
    }

    protected void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callBackHandler) throws IOException {
        if (this.opConnectToRegister == null) {
            this.opConnectToRegister = new ConcurrentHashMap();
        }
        this.opConnectToRegister.put(new SocketAddress[]{remoteAddress, localAddress}, callBackHandler);
        this.selector.wakeup();
    }

    @Override
    public void shutdown() {
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "serverSocket.close", ex);
        }
        try {
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "serverSocketChannel.close", ex);
        }
        try {
            if (this.selector != null) {
                this.selector.close();
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "selector.close", ex);
        }
    }

    @Override
    public SelectableChannel acceptWithoutRegistration(SelectionKey key) throws IOException {
        ServerSocketChannel server = (ServerSocketChannel)key.channel();
        SocketChannel channel = server.accept();
        return channel;
    }

    @Override
    public boolean onAcceptInterest(SelectionKey key, Context ctx) throws IOException {
        SelectableChannel channel = this.acceptWithoutRegistration(key);
        if (channel != null) {
            this.configureChannel(channel);
            SelectionKey readKey = channel.register(this.selector, 1);
            readKey.attach(System.currentTimeMillis());
        }
        return false;
    }

    @Override
    public boolean onReadInterest(SelectionKey key, Context ctx) throws IOException {
        key.interestOps(key.interestOps() & 0xFFFFFFFE);
        if (key.attachment() instanceof CallbackHandler) {
            Context context = ctx.getController().pollContext(key);
            context.setSelectionKey(key);
            context.setCurrentOpType(Context.OpType.OP_READ);
            this.invokeCallbackHandler(context);
            return false;
        }
        return true;
    }

    @Override
    public boolean onWriteInterest(SelectionKey key, Context ctx) throws IOException {
        key.interestOps(key.interestOps() & 0xFFFFFFFB);
        if (key.attachment() instanceof CallbackHandler) {
            Context context = ctx.getController().pollContext(key);
            context.setSelectionKey(key);
            context.setCurrentOpType(Context.OpType.OP_WRITE);
            this.invokeCallbackHandler(context);
            return false;
        }
        return true;
    }

    @Override
    public boolean onConnectInterest(SelectionKey key, Context ctx) throws IOException {
        key.interestOps(key.interestOps() & 0xFFFFFFF7);
        key.interestOps(key.interestOps() & 0xFFFFFFFB);
        key.interestOps(key.interestOps() & 0xFFFFFFFE);
        if (key.attachment() instanceof CallbackHandler) {
            Context context = ctx.getController().pollContext(key);
            context.setSelectionKey(key);
            context.setCurrentOpType(Context.OpType.OP_CONNECT);
            this.invokeCallbackHandler(context);
        }
        return false;
    }

    protected void invokeCallbackHandler(Context context) throws IOException {
        context.setProtocol(this.protocol());
        IOEvent.DefaultIOEvent<Context> ioEvent = new IOEvent.DefaultIOEvent<Context>(context);
        context.setIOEvent(ioEvent);
        try {
            context.execute();
        }
        catch (PipelineFullException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public ConnectorHandler acquireConnectorHandler() {
        if (this.selector == null && !this.selector.isOpen()) {
            throw new IllegalStateException("SelectorHandler not yet started");
        }
        Object connectorHandler = this.connectorInstanceHandler.acquire();
        return connectorHandler;
    }

    @Override
    public void releaseConnectorHandler(ConnectorHandler connectorHandler) {
        this.connectorInstanceHandler.release(connectorHandler);
    }

    @Override
    public Controller.Protocol protocol() {
        return Controller.Protocol.TCP;
    }

    @Override
    public void configureChannel(SelectableChannel channel) throws IOException {
        Socket socket = ((SocketChannel)channel).socket();
        channel.configureBlocking(false);
        try {
            if (this.linger >= 0) {
                socket.setSoLinger(true, this.linger);
            }
        }
        catch (SocketException ex) {
            this.logger.log(Level.WARNING, "setSoLinger exception ", ex);
        }
        try {
            if (this.tcpNoDelay) {
                socket.setTcpNoDelay(this.tcpNoDelay);
            }
        }
        catch (SocketException ex) {
            this.logger.log(Level.WARNING, "setTcpNoDelay exception ", ex);
        }
        try {
            socket.setReuseAddress(this.reuseAddress);
        }
        catch (SocketException ex) {
            this.logger.log(Level.WARNING, "setReuseAddress exception ", ex);
        }
    }

    @Override
    public final Selector getSelector() {
        return this.selector;
    }

    @Override
    public final void setSelector(Selector selector) {
        this.selector = selector;
    }

    public long getSelectTimeout() {
        return this.selectTimeout;
    }

    public void setSelectTimeout(long selectTimeout) {
        this.selectTimeout = selectTimeout;
    }

    public int getServerTimeout() {
        return this.serverTimeout;
    }

    public void setServerTimeout(int serverTimeout) {
        this.serverTimeout = serverTimeout;
    }

    public InetAddress getInet() {
        return this.inet;
    }

    public void setInet(InetAddress inet) {
        this.inet = inet;
    }

    public int getPortLowLevel() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return -1;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getSsBackLog() {
        return this.ssBackLog;
    }

    public void setSsBackLog(int ssBackLog) {
        this.ssBackLog = ssBackLog;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    @Override
    public Pipeline pipeline() {
        return null;
    }

    @Override
    public SelectionKeyHandler getSelectionKeyHandler() {
        return this.selectionKeyHandler;
    }

    @Override
    public void setSelectionKeyHandler(SelectionKeyHandler selectionKeyHandler) {
        this.selectionKeyHandler = selectionKeyHandler;
    }

    protected Callable<ConnectorHandler> getConnectorInstanceHandlerDelegate() {
        return new Callable<ConnectorHandler>(){

            @Override
            public ConnectorHandler call() throws Exception {
                return new TCPConnectorHandler();
            }
        };
    }
}

