/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListenerAdapter;
import com.sun.grizzly.DefaultPipeline;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.util.ByteBufferInputStream;
import com.sun.grizzly.util.OutputWriter;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPConnectorHandler
implements ConnectorHandler<TCPSelectorHandler, CallbackHandler> {
    private TCPSelectorHandler selectorHandler;
    private CallbackHandler callbackHandler;
    private ByteBufferInputStream inputStream;
    private SocketChannel socketChannel;
    private volatile boolean isConnected;
    private Controller controller;
    private CountDownLatch isConnectedLatch;
    private boolean isStandalone = false;

    @Override
    public void connect(SocketAddress remoteAddress, CallbackHandler callbackHandler) throws IOException {
        this.connect(remoteAddress, (SocketAddress)null, callbackHandler);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler) throws IOException {
        if (this.controller == null) {
            throw new IllegalStateException("Controller cannot be null");
        }
        this.connect(remoteAddress, localAddress, callbackHandler, (TCPSelectorHandler)this.controller.getSelectorHandler(this.protocol()));
    }

    @Override
    public void connect(SocketAddress remoteAddress, CallbackHandler callbackHandler, TCPSelectorHandler selectorHandler) throws IOException {
        this.connect(remoteAddress, (SocketAddress)null, callbackHandler, selectorHandler);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler, TCPSelectorHandler selectorHandler) throws IOException {
        if (this.isConnected) {
            throw new AlreadyConnectedException();
        }
        if (this.controller == null) {
            throw new IllegalStateException("Controller cannot be null");
        }
        if (selectorHandler == null) {
            throw new IllegalStateException("Controller cannot be null");
        }
        this.selectorHandler = selectorHandler;
        this.callbackHandler = callbackHandler;
        this.isConnectedLatch = new CountDownLatch(1);
        selectorHandler.connect(remoteAddress, localAddress, callbackHandler);
        this.inputStream = new ByteBufferInputStream();
        try {
            this.isConnectedLatch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public void connect(SocketAddress remoteAddress) throws IOException {
        this.connect(remoteAddress, (SocketAddress)null);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        if (this.isConnected) {
            throw new AlreadyConnectedException();
        }
        if (this.controller == null) {
            this.isStandalone = true;
            this.controller = new Controller();
            this.controller.setSelectorHandler(new TCPSelectorHandler(true));
            DefaultPipeline pipeline = new DefaultPipeline();
            pipeline.initPipeline();
            pipeline.startPipeline();
            this.controller.setPipeline(pipeline);
            final CountDownLatch latch = new CountDownLatch(1);
            this.controller.addStateListener(new ControllerStateListenerAdapter(){

                public void onReady() {
                    latch.countDown();
                }

                public void onException(Throwable e) {
                    latch.countDown();
                }
            });
            this.callbackHandler = new CallbackHandler<Context>(){

                @Override
                public void onConnect(IOEvent<Context> ioEvent) {
                    SelectionKey key = ioEvent.attachment().getSelectionKey();
                    TCPConnectorHandler.this.socketChannel = (SocketChannel)key.channel();
                    TCPConnectorHandler.this.finishConnect(key);
                    TCPConnectorHandler.this.getController().registerKey(key, 4, Controller.Protocol.TCP);
                }

                @Override
                public void onRead(IOEvent<Context> ioEvent) {
                }

                @Override
                public void onWrite(IOEvent<Context> ioEvent) {
                }
            };
            new Thread(this.controller).start();
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        this.connect(remoteAddress, localAddress, this.callbackHandler, (TCPSelectorHandler)this.controller.getSelectorHandler(this.protocol()));
    }

    @Override
    public long read(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        if (!this.isConnected) {
            throw new NotYetConnectedException();
        }
        SelectionKey key = this.socketChannel.keyFor(this.selectorHandler.getSelector());
        if (blocking) {
            this.inputStream.setSelectionKey(key);
            return this.inputStream.read(byteBuffer);
        }
        if (this.callbackHandler == null) {
            throw new IllegalStateException("Non blocking read needs a CallbackHandler");
        }
        int nRead = this.socketChannel.read(byteBuffer);
        if (nRead == 0) {
            key.attach(this.callbackHandler);
            this.selectorHandler.register(key, 1);
        }
        return nRead;
    }

    @Override
    public long write(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        if (!this.isConnected) {
            throw new NotYetConnectedException();
        }
        SelectionKey key = this.socketChannel.keyFor(this.selectorHandler.getSelector());
        if (blocking) {
            return OutputWriter.flushChannel(this.socketChannel, byteBuffer);
        }
        if (this.callbackHandler == null) {
            throw new IllegalStateException("Non blocking write needs a CallbackHandler");
        }
        int nWrite = 1;
        int totalWriteBytes = 0;
        while (nWrite > 0 && byteBuffer.hasRemaining()) {
            nWrite = this.socketChannel.write(byteBuffer);
            totalWriteBytes += nWrite;
        }
        if (totalWriteBytes == 0 && byteBuffer.hasRemaining()) {
            key.attach(this.callbackHandler);
            this.selectorHandler.register(key, 4);
        }
        return totalWriteBytes;
    }

    @Override
    public void close() throws IOException {
        if (this.socketChannel != null) {
            if (this.selectorHandler != null) {
                SelectionKey key = this.socketChannel.keyFor(this.selectorHandler.getSelector());
                if (key == null) {
                    return;
                }
                key.cancel();
                key.attach(null);
            }
            this.socketChannel.close();
        }
        if (this.controller != null && this.isStandalone) {
            this.controller.stop();
            this.controller = null;
        }
        this.isStandalone = false;
        this.isConnected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishConnect(SelectionKey key) {
        try {
            this.socketChannel = (SocketChannel)key.channel();
            this.socketChannel.finishConnect();
            this.isConnected = this.socketChannel.isConnected();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            this.isConnectedLatch.countDown();
        }
    }

    @Override
    public Controller.Protocol protocol() {
        return Controller.Protocol.TCP;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    @Override
    public void setController(Controller controller) {
        this.controller = controller;
    }

    @Override
    public SelectableChannel getUnderlyingChannel() {
        return this.socketChannel;
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    @Override
    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public TCPSelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }
}

