/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SSLConfig {
    private static Logger logger = Logger.getLogger("grizzly");
    public static SSLConfig DEFAULT_CONFIG = new SSLConfig();
    private String trustStoreType = "JKS";
    private String keyStoreType = "JKS";
    private char[] trustStorePass = "changeit".toCharArray();
    private char[] keyStorePass = "changeit".toCharArray();
    private String trustStoreFile = System.getProperty("javax.net.ssl.trustStore");
    private String keyStoreFile = System.getProperty("javax.net.ssl.keyStore");
    private String trustStoreAlgorithm = "SunX509";
    private String keyStoreAlgorithm = "SunX509";
    private String securityProtocol = "TLS";
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getTrustStorePass() {
        return new String(this.trustStorePass);
    }

    public void setTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass.toCharArray();
    }

    public String getKeyStorePass() {
        return new String(this.keyStorePass);
    }

    public void setKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass.toCharArray();
    }

    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getTrustStoreAlgorithm() {
        return this.trustStoreAlgorithm;
    }

    public void setTrustStoreAlgorithm(String trustStoreAlgorithm) {
        this.trustStoreAlgorithm = trustStoreAlgorithm;
    }

    public String getKeyStoreAlgorithm() {
        return this.keyStoreAlgorithm;
    }

    public void setKeyStoreAlgorithm(String keyStoreAlgorithm) {
        this.keyStoreAlgorithm = keyStoreAlgorithm;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public SSLContext createSSLContext() {
        SSLContext sslContext = null;
        try {
            TrustManagerFactory trustManagerFactory = null;
            KeyManagerFactory keyManagerFactory = null;
            try {
                KeyStore trustStore = KeyStore.getInstance(this.keyStoreType);
                trustStore.load(new FileInputStream(this.trustStoreFile), this.trustStorePass);
                trustManagerFactory = TrustManagerFactory.getInstance(this.trustStoreAlgorithm);
                trustManagerFactory.init(trustStore);
            }
            catch (KeyStoreException e) {
                logger.log(Level.FINE, "Error initializing trust store", e);
            }
            catch (CertificateException e) {
                logger.log(Level.FINE, "Trust store certificate exception.", e);
            }
            catch (FileNotFoundException e) {
                logger.log(Level.FINE, "Can't find trust store file: " + this.trustStoreFile, e);
            }
            catch (IOException e) {
                logger.log(Level.FINE, "Error loading trust store from file: " + this.trustStoreFile, e);
            }
            try {
                KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
                keyStore.load(new FileInputStream(this.keyStoreFile), this.keyStorePass);
                keyManagerFactory = KeyManagerFactory.getInstance(this.keyStoreAlgorithm);
                keyManagerFactory.init(keyStore, this.keyStorePass);
            }
            catch (KeyStoreException e) {
                logger.log(Level.FINE, "Error initializing key store", e);
            }
            catch (CertificateException e) {
                logger.log(Level.FINE, "Key store certificate exception.", e);
            }
            catch (UnrecoverableKeyException e) {
                logger.log(Level.FINE, "Key store unrecoverable exception.", e);
            }
            catch (FileNotFoundException e) {
                logger.log(Level.FINE, "Can't find key store file: " + this.keyStoreFile, e);
            }
            catch (IOException e) {
                logger.log(Level.FINE, "Error loading key store from file: " + this.keyStoreFile, e);
            }
            sslContext = SSLContext.getInstance(this.securityProtocol);
            sslContext.init(keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null, trustManagerFactory != null ? trustManagerFactory.getTrustManagers() : null, null);
        }
        catch (KeyManagementException e) {
            logger.log(Level.FINE, "Key management error.", e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(Level.FINE, "Error initializing algorithm.", e);
        }
        return sslContext;
    }
}

