/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.ComplexSelectorHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ReadController;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.util.Copyable;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Set;

public class RoundRobinSelectorHandler
extends TCPSelectorHandler
implements ComplexSelectorHandler {
    private ReadController[] rrControllers;
    private int roundRobinCounter;
    private Set<Controller.Protocol> customProtocols;

    public RoundRobinSelectorHandler() {
    }

    public RoundRobinSelectorHandler(ReadController[] rrControllers) {
        this.rrControllers = rrControllers;
    }

    public void copyTo(Copyable copy) {
        super.copyTo(copy);
        RoundRobinSelectorHandler copyHandler = (RoundRobinSelectorHandler)copy;
        copyHandler.roundRobinCounter = this.roundRobinCounter;
        copyHandler.rrControllers = this.rrControllers;
    }

    public boolean onAcceptInterest(SelectionKey key, Context context) throws IOException {
        return this.onAcceptInterest(key, context, context.getController().getSelectorHandler(this.protocol()));
    }

    public boolean onAcceptInterest(SelectionKey key, Context context, SelectorHandler protocolSelectorHandler) throws IOException {
        ReadController auxController = this.nextController();
        SelectableChannel channel = protocolSelectorHandler.acceptWithoutRegistration(key);
        if (channel != null) {
            protocolSelectorHandler.configureChannel(channel);
            auxController.addChannel(channel, protocolSelectorHandler.protocol());
        }
        return false;
    }

    public void addProtocolSupport(Controller.Protocol customProtocol) {
        this.customProtocols.add(customProtocol);
    }

    public boolean supportsProtocol(Controller.Protocol protocol) {
        return protocol == Controller.Protocol.TCP || protocol == Controller.Protocol.TLS || this.customProtocols.contains((Object)protocol);
    }

    private ReadController nextController() {
        return this.rrControllers[this.roundRobinCounter++ % this.rrControllers.length];
    }
}

