/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Controller;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;

public class DefaultSelectionKeyHandler
implements SelectionKeyHandler {
    protected Logger logger = Controller.logger();
    protected long nextKeysExpiration = 0L;
    protected long timeout = 30000L;

    public void process(SelectionKey key) {
        Object attachment = key.attachment();
        if (attachment != null && attachment instanceof ThreadAttachment) {
            ((WorkerThread)((Object)Thread.currentThread())).attach((ThreadAttachment)attachment);
            key.attach(null);
        }
    }

    public void postProcess(SelectionKey key) {
    }

    public void register(SelectionKey key, long currentTime) {
        Object attachment = key.attachment();
        if (attachment == null) {
            key.attach(currentTime);
        } else if (attachment instanceof ThreadAttachment) {
            ((ThreadAttachment)attachment).setTimeout(currentTime);
        }
    }

    public void expire(SelectionKey key, long currentTime) {
        block16: {
            if (this.timeout <= 0L) {
                return;
            }
            if (currentTime < this.nextKeysExpiration) {
                return;
            }
            this.nextKeysExpiration = currentTime + this.timeout;
            if (!key.isValid()) {
                return;
            }
            Object attachment = key.attachment();
            if (attachment != null) {
                try {
                    long expire = 0L;
                    if (attachment instanceof Long) {
                        expire = (Long)attachment;
                    } else if (attachment instanceof SSLEngine) {
                        SSLSession sslSession = ((SSLEngine)attachment).getSession();
                        if (sslSession != null && sslSession.getValue("expireTime") != null) {
                            expire = (Long)sslSession.getValue("expireTime");
                        }
                    } else if (attachment instanceof ThreadAttachment) {
                        expire = ((ThreadAttachment)attachment).getTimeout();
                    } else {
                        return;
                    }
                    if (currentTime - expire >= this.timeout) {
                        this.cancel(key);
                    } else if (expire + this.timeout < this.nextKeysExpiration) {
                        this.nextKeysExpiration = expire + this.timeout;
                    }
                }
                catch (ClassCastException ex) {
                    if (!this.logger.isLoggable(Level.FINEST)) break block16;
                    this.logger.log(Level.FINEST, "Invalid SelectionKey attachment", ex);
                }
            }
        }
    }

    public void cancel(SelectionKey key) {
        if (key == null || !key.isValid()) {
            return;
        }
        this.closeChannel(key.channel());
        key.attach(null);
        key.cancel();
        key = null;
    }

    public void close(SelectionKey key) {
        this.cancel(key);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected void closeChannel(SelectableChannel channel) {
        if (channel instanceof SocketChannel) {
            Socket socket = ((SocketChannel)channel).socket();
            try {
                if (!socket.isInputShutdown()) {
                    socket.shutdownInput();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                if (!socket.isOutputShutdown()) {
                    socket.shutdownOutput();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

