/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolFilter;
import java.io.IOException;
import java.util.ArrayList;

public class DefaultProtocolChain
implements ProtocolChain {
    protected ArrayList<ProtocolFilter> protocolFilters = new ArrayList();

    public void execute(Context ctx) throws Exception {
        Controller controller = ctx.getController();
        if (this.protocolFilters.size() != 0) {
            int currentPosition = this.executeProtocolFilter(ctx);
            this.postExecuteProtocolFilter(currentPosition, ctx);
            ctx.recycle();
        }
        controller.returnContext(ctx);
    }

    protected int executeProtocolFilter(Context ctx) {
        boolean invokeNext = true;
        int size = this.protocolFilters.size();
        int currentPosition = 0;
        int i = 0;
        while (i < size) {
            try {
                invokeNext = this.protocolFilters.get(i).execute(ctx);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
            currentPosition = i++;
            if (!invokeNext) break;
        }
        return currentPosition;
    }

    protected boolean postExecuteProtocolFilter(int currentPosition, Context ctx) {
        boolean invokeNext = true;
        for (int i = currentPosition; i > -1; --i) {
            try {
                ProtocolFilter tmpHandler = this.protocolFilters.get(i);
                invokeNext = tmpHandler.postExecute(ctx);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
            if (!invokeNext) break;
        }
        return false;
    }

    public boolean removeFilter(ProtocolFilter theFilter) {
        return this.protocolFilters.remove(theFilter);
    }

    public boolean addFilter(ProtocolFilter protocolFilter) {
        return this.protocolFilters.add(protocolFilter);
    }

    public void addFilter(int pos, ProtocolFilter protocolFilter) {
        this.protocolFilters.add(pos, protocolFilter);
    }

    public ProtocolFilter setProtocolFilter(int pos, ProtocolFilter protocolFilter) {
        return this.protocolFilters.set(pos, protocolFilter);
    }
}

