/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.ComplexSelectorHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.ConnectorHandlerPool;
import com.sun.grizzly.Context;
import com.sun.grizzly.ControllerStateListener;
import com.sun.grizzly.DefaultConnectorHandlerPool;
import com.sun.grizzly.DefaultPipeline;
import com.sun.grizzly.DefaultProtocolChain;
import com.sun.grizzly.DefaultProtocolChainInstanceHandler;
import com.sun.grizzly.DefaultSelectionKeyHandler;
import com.sun.grizzly.Lifecycle;
import com.sun.grizzly.Pipeline;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ReadController;
import com.sun.grizzly.RoundRobinSelectorHandler;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.filter.LogFilter;
import com.sun.grizzly.filter.ReadFilter;
import com.sun.grizzly.util.Cloner;
import com.sun.grizzly.util.Copyable;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller
implements Runnable,
Lifecycle,
Copyable,
ConnectorHandlerPool {
    private ConcurrentLinkedQueue<Context> contexts;
    protected ProtocolChainInstanceHandler instanceHandler;
    protected SelectionKeyHandler selectionKeyHandler;
    protected ComplexSelectorHandler multiReadThreadSelectorHandler = null;
    protected ConnectorHandlerPool connectorHandlerPool = null;
    protected ConcurrentLinkedQueue<SelectorHandler> selectorHandlers;
    protected volatile State state;
    protected ReentrantLock stateLock;
    protected int readThreadsCount = 0;
    protected ReadController[] readThreadControllers;
    private static Logger logger = Logger.getLogger("grizzly");
    private Pipeline<Callable> pipeline;
    protected Object shutdownLock = new Object();
    protected Collection<ControllerStateListener> stateListeners = new LinkedList<ControllerStateListener>();

    public Controller() {
        this.contexts = new ConcurrentLinkedQueue();
        this.stateLock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSelect(SelectorHandler selectorHandler) {
        SelectionKey key = null;
        boolean delegateToWorkerThread = false;
        Object ctx = null;
        Context serverCtx = this.contexts.poll();
        if (serverCtx == null) {
            serverCtx = new Context();
            serverCtx.setController(this);
        }
        try {
            Iterator<SelectionKey> iterator;
            int selectorState = 0;
            if (selectorHandler.getSelectionKeyHandler() == null) {
                selectorHandler.setSelectionKeyHandler(this.selectionKeyHandler);
            }
            selectorHandler.preSelect(serverCtx);
            Set<SelectionKey> readyKeys = selectorHandler.select(serverCtx);
            selectorState = readyKeys.size();
            if (this.state == State.STARTED && selectorState != 0) {
                iterator = readyKeys.iterator();
                while (iterator.hasNext()) {
                    key = iterator.next();
                    iterator.remove();
                    if (key.isValid()) {
                        if ((key.readyOps() & 0x10) == 16) {
                            delegateToWorkerThread = this.readThreadsCount > 0 && this.multiReadThreadSelectorHandler.supportsProtocol(selectorHandler.protocol()) ? this.multiReadThreadSelectorHandler.onAcceptInterest(key, serverCtx, selectorHandler) : selectorHandler.onAcceptInterest(key, serverCtx);
                        } else if ((key.readyOps() & 1) == 1) {
                            delegateToWorkerThread = selectorHandler.onReadInterest(key, serverCtx);
                        } else if ((key.readyOps() & 4) == 4) {
                            delegateToWorkerThread = selectorHandler.onWriteInterest(key, serverCtx);
                        } else if ((key.readyOps() & 8) == 8) {
                            delegateToWorkerThread = selectorHandler.onConnectInterest(key, serverCtx);
                        }
                        if (!delegateToWorkerThread) continue;
                        Context context = this.pollContext(key);
                        context.setProtocol(selectorHandler.protocol());
                        context.setPipeline(selectorHandler.pipeline());
                        context.execute();
                        continue;
                    }
                    this.selectionKeyHandler.cancel(key);
                }
            }
            delegateToWorkerThread = false;
            readyKeys = selectorHandler.keys();
            if (readyKeys.isEmpty()) {
                return;
            }
            iterator = readyKeys.iterator();
            long currentTime = System.currentTimeMillis();
            while (iterator.hasNext() && selectorHandler.isOpen()) {
                key = iterator.next();
                this.selectionKeyHandler.expire(key, currentTime);
            }
            selectorHandler.postSelect(serverCtx);
            this.contexts.offer(serverCtx);
        }
        catch (ClosedSelectorException e) {
            this.stateLock.lock();
            try {
                if (this.state != State.STOPPED) {
                    logger.log(Level.SEVERE, "Selector was unexpectedly closed.");
                    this.notifyException(e);
                } else {
                    logger.log(Level.FINE, "doSelect Selector closed");
                }
            }
            finally {
                this.stateLock.unlock();
            }
        }
        catch (ClosedChannelException e) {
            if (this.state != State.STOPPED) {
                logger.log(Level.WARNING, "Channel was unexpectedly closed");
                if (key != null) {
                    this.cancelKey(key);
                }
                this.notifyException(e);
            }
        }
        catch (Throwable t) {
            if (key != null) {
                if (key.channel() instanceof SocketChannel) {
                    this.cancelKey(key);
                } else {
                    key.cancel();
                }
            }
            this.notifyException(t);
            logger.log(Level.SEVERE, "doSelect exception", t);
        }
    }

    public void registerKey(SelectionKey key) {
        this.registerKey(key, 1);
    }

    public void registerKey(SelectionKey key, int ops) {
        this.registerKey(key, ops, this.selectorHandlers.peek().protocol());
    }

    public void registerKey(SelectionKey key, int ops, Protocol protocol) {
        if (this.state == State.STOPPED) {
            return;
        }
        this.getSelectorHandler(protocol).register(key, ops);
    }

    public void cancelKey(SelectionKey key) {
        if (this.state == State.STOPPED) {
            return;
        }
        this.selectionKeyHandler.cancel(key);
    }

    public Context pollContext(SelectionKey key) {
        Context ctx = this.contexts.poll();
        if (ctx == null) {
            ctx = new Context();
        }
        ctx.setController(this);
        ctx.setSelectionKey(key);
        ctx.setProtocolChain(this.instanceHandler.poll());
        return ctx;
    }

    public void returnContext(Context ctx) {
        this.contexts.offer(ctx);
    }

    public static Logger logger() {
        return logger;
    }

    public static void setLogger(Logger l) {
        logger = l;
    }

    public void setProtocolChainInstanceHandler(ProtocolChainInstanceHandler instanceHandler) {
        this.instanceHandler = instanceHandler;
    }

    public ProtocolChainInstanceHandler getProtocolChainInstanceHandler() {
        return this.instanceHandler;
    }

    public void setSelectionKeyHandler(SelectionKeyHandler selectionKeyHandler) {
        this.selectionKeyHandler = selectionKeyHandler;
    }

    public SelectionKeyHandler getSelectionKeyHandler() {
        return this.selectionKeyHandler;
    }

    public void addSelectorHandler(SelectorHandler selectorHandler) {
        if (this.selectorHandlers == null) {
            this.selectorHandlers = new ConcurrentLinkedQueue();
        }
        this.selectorHandlers.add(selectorHandler);
    }

    public void setSelectorHandler(SelectorHandler selectorHandler) {
        this.addSelectorHandler(selectorHandler);
    }

    public SelectorHandler getSelectorHandler(Protocol protocol) {
        for (SelectorHandler selectorHandler : this.selectorHandlers) {
            if (selectorHandler.protocol() != protocol) continue;
            return selectorHandler;
        }
        return null;
    }

    public ConcurrentLinkedQueue getSelectorHandlers() {
        return this.selectorHandlers;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(Pipeline<Callable> pipeline) {
        this.pipeline = pipeline;
    }

    public int getReadThreadsCount() {
        return this.readThreadsCount;
    }

    public void setReadThreadsCount(int readThreadsCount) {
        this.readThreadsCount = readThreadsCount;
    }

    public ConnectorHandlerPool getConnectorHandlerPool() {
        return this.connectorHandlerPool;
    }

    public void setConnectorHandlerPool(ConnectorHandlerPool connectorHandlerPool) {
        this.connectorHandlerPool = connectorHandlerPool;
    }

    @Override
    public void run() {
        try {
            this.start();
        }
        catch (IOException e) {
            this.notifyException(e);
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public void copyTo(Copyable copy) {
        Controller copyController = (Controller)copy;
        copyController.contexts = this.contexts;
        copyController.instanceHandler = this.instanceHandler;
        copyController.pipeline = this.pipeline;
        copyController.readThreadControllers = this.readThreadControllers;
        copyController.readThreadsCount = this.readThreadsCount;
        copyController.selectionKeyHandler = this.selectionKeyHandler;
        copyController.stateLock = this.stateLock;
        copyController.state = this.state;
    }

    public void addStateListener(ControllerStateListener stateListener) {
        this.stateListeners.add(stateListener);
    }

    public void removeStateListener(ControllerStateListener stateListener) {
        this.stateListeners.remove(stateListener);
    }

    private void notifyStarted() {
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onStarted();
        }
    }

    private void notifyReady() {
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onReady();
        }
    }

    private void notifyStopped() {
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onStopped();
        }
    }

    private void notifyException(Throwable e) {
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        if (this.pipeline == null) {
            this.pipeline = new DefaultPipeline();
        }
        if (this.instanceHandler == null) {
            this.instanceHandler = new DefaultProtocolChainInstanceHandler();
        }
        if (this.selectorHandlers == null) {
            this.selectorHandlers = new ConcurrentLinkedQueue();
            this.selectorHandlers.add(new TCPSelectorHandler());
        }
        if (this.selectionKeyHandler == null) {
            this.selectionKeyHandler = new DefaultSelectionKeyHandler();
        }
        if (this.connectorHandlerPool == null) {
            this.connectorHandlerPool = new DefaultConnectorHandlerPool(this);
        }
        if (this.readThreadsCount > 0) {
            this.initReadThreads();
            this.multiReadThreadSelectorHandler = new RoundRobinSelectorHandler(this.readThreadControllers);
        }
        this.pipeline.initPipeline();
        this.pipeline.startPipeline();
        this.stateLock.lock();
        try {
            this.state = State.STARTED;
        }
        finally {
            this.stateLock.unlock();
        }
        this.notifyStarted();
        boolean firstTimeSelect = true;
        try {
            Object object = this.shutdownLock;
            synchronized (object) {
                while (this.state == State.STARTED) {
                    for (SelectorHandler selectorHandler : this.selectorHandlers) {
                        if (this.state != State.STARTED) break;
                        this.doSelect(selectorHandler);
                    }
                    if (!firstTimeSelect) continue;
                    firstTimeSelect = false;
                    this.notifyReady();
                }
                for (SelectorHandler selectorHandler : this.selectorHandlers) {
                    for (SelectionKey selectionKey : selectorHandler.keys()) {
                        this.selectionKeyHandler.close(selectionKey);
                    }
                    selectorHandler.shutdown();
                }
                this.selectorHandlers.clear();
                this.pipeline.stopPipeline();
            }
        }
        finally {
            this.notifyStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        block11: {
            this.stateLock.lock();
            try {
                if (this.state != State.STOPPED) {
                    this.state = State.STOPPED;
                    Object object = this.shutdownLock;
                    synchronized (object) {
                        if (this.readThreadsCount > 0) {
                            for (ReadController readController : this.readThreadControllers) {
                                try {
                                    readController.stop();
                                }
                                catch (IOException e) {
                                    logger.log(Level.WARNING, "Exception occured when stopping read Controller!", e);
                                }
                            }
                            this.multiReadThreadSelectorHandler.shutdown();
                            this.multiReadThreadSelectorHandler = null;
                            this.readThreadControllers = null;
                        }
                        break block11;
                    }
                }
                logger.log(Level.FINE, "Controller is already in stopped state");
            }
            finally {
                this.stateLock.unlock();
            }
        }
    }

    @Override
    public void pause() throws IOException {
    }

    @Override
    public void resume() throws IOException {
    }

    private void initReadThreads() throws IOException {
        this.readThreadControllers = new ReadController[this.readThreadsCount];
        for (int i = 0; i < this.readThreadsCount; ++i) {
            ReadController controller = new ReadController();
            this.copyTo(controller);
            for (SelectorHandler selectorHandler : this.selectorHandlers) {
                SelectorHandler copySelectorHandler = Cloner.clone(selectorHandler);
                copySelectorHandler.setSelector(Selector.open());
                controller.addSelectorHandler(copySelectorHandler);
            }
            controller.setReadThreadsCount(0);
            this.readThreadControllers[i] = controller;
            new Thread(controller).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        boolean result = false;
        if (this.stateLock != null) {
            this.stateLock.lock();
            try {
                result = this.state == State.STARTED;
            }
            finally {
                this.stateLock.unlock();
            }
        }
        return result;
    }

    public ConnectorHandler acquireConnectorHandler(Protocol protocol) {
        return this.connectorHandlerPool.acquireConnectorHandler(protocol);
    }

    public void releaseConnectorHandler(ConnectorHandler connectorHandler) {
        this.connectorHandlerPool.releaseConnectorHandler(connectorHandler);
    }

    public static void main(String[] args) {
        Controller sel = new Controller();
        final ReadFilter readFilter = new ReadFilter();
        final LogFilter logFilter = new LogFilter();
        sel.setProtocolChainInstanceHandler(new DefaultProtocolChainInstanceHandler(){

            public ProtocolChain poll() {
                ProtocolChain protocolChain = (ProtocolChain)this.protocolChains.poll();
                if (protocolChain == null) {
                    protocolChain = new DefaultProtocolChain();
                    protocolChain.addFilter(readFilter);
                    protocolChain.addFilter(logFilter);
                }
                return protocolChain;
            }
        });
        try {
            sel.start();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Controller.start()", ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        STOPPED,
        STARTED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Protocol {
        UDP,
        TCP,
        TLS,
        CUSTOM;

    }
}

