/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.Controller;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.Pipeline;
import com.sun.grizzly.PipelineFullException;
import com.sun.grizzly.ProtocolChain;
import java.nio.channels.SelectionKey;
import java.util.HashMap;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
implements Callable {
    private OpType currentOpType;
    private ProtocolChain protocolChain;
    private Controller.Protocol protocol;
    public static final String THROWABLE = "throwable";
    private HashMap<String, Object> attributes = new HashMap();
    private SelectionKey key;
    private Controller controller;
    private KeyRegistrationState keyRegistrationState = KeyRegistrationState.REGISTER;
    private Pipeline pipeline;
    private IOEvent<Context> ioEvent;

    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public SelectionKey getSelectionKey() {
        return this.key;
    }

    public void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void recycle() {
        this.key = null;
        this.keyRegistrationState = KeyRegistrationState.REGISTER;
        this.protocolChain = null;
        this.ioEvent = null;
    }

    public KeyRegistrationState getKeyRegistrationState() {
        return this.keyRegistrationState;
    }

    public void setKeyRegistrationState(KeyRegistrationState keyRegistrationState) {
        this.keyRegistrationState = keyRegistrationState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() throws Exception {
        block13: {
            try {
                Object attachment = this.key.attachment();
                if (this.ioEvent != null && attachment instanceof CallbackHandler) {
                    CallbackHandler callBackHandler = (CallbackHandler)attachment;
                    if (this.currentOpType == OpType.OP_READ) {
                        callBackHandler.onRead(this.ioEvent);
                    } else if (this.currentOpType == OpType.OP_WRITE) {
                        callBackHandler.onWrite(this.ioEvent);
                    } else if (this.currentOpType == OpType.OP_CONNECT) {
                        callBackHandler.onConnect(this.ioEvent);
                    }
                    break block13;
                }
                SelectionKey currentKey = this.key;
                this.controller.getSelectionKeyHandler().process(currentKey);
                try {
                    this.protocolChain.execute(this);
                }
                finally {
                    this.controller.getSelectionKeyHandler().postProcess(currentKey);
                }
            }
            finally {
                if (this.ioEvent != null) {
                    this.ioEvent.attach(null);
                    this.ioEvent = null;
                }
            }
        }
        return null;
    }

    public ProtocolChain getProtocolChain() {
        return this.protocolChain;
    }

    public void setProtocolChain(ProtocolChain protocolChain) {
        this.protocolChain = protocolChain;
    }

    public OpType getCurrentOpType() {
        return this.currentOpType;
    }

    protected void setCurrentOpType(OpType currentOpType) {
        this.currentOpType = currentOpType;
    }

    public void execute() throws PipelineFullException {
        if (this.pipeline == null && this.controller != null) {
            this.pipeline = this.controller.getPipeline();
        }
        this.pipeline.execute(this);
    }

    public Pipeline getPipeline() {
        if (this.pipeline == null && this.controller != null) {
            this.pipeline = this.controller.getPipeline();
        }
        return this.pipeline;
    }

    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    protected void setIOEvent(IOEvent<Context> ioEvent) {
        this.ioEvent = ioEvent;
    }

    protected IOEvent getIOEvent() {
        return this.ioEvent;
    }

    public Controller.Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Controller.Protocol protocol) {
        this.protocol = protocol;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OpType {
        OP_READ,
        OP_WRITE,
        OP_CONNECT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KeyRegistrationState {
        CANCEL,
        REGISTER,
        NONE;

    }
}

