/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.standalone;

import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.standalone.StaticResourcesAdapter;
import com.sun.grizzly.standalone.StaticStreamAlgorithm;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.util.ClassLoaderUtil;
import java.io.File;

public class Main {
    private static final String SELECTOR_THREAD = "com.sun.grizzly.selectorThread";
    private static final String ENABLE_RCM = "com.sun.grizzly.enableRCM";
    private static final String ENABLE_ASYNC = "com.sun.grizzly.enableARP";
    private static final String ADAPTER = "com.sun.grizzly.adapterClass";
    static int port = 8080;
    static String folder = ".";

    public static void main(String[] args) throws Exception {
        Main main = new Main();
        Main.start(args);
    }

    private static void start(String[] args) throws Exception {
        try {
            if (args != null && args.length > 0) {
                port = Integer.parseInt(args[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (args != null && args.length > 1) {
                folder = args[1];
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Thread.currentThread().setContextClassLoader(ClassLoaderUtil.createClassloader((File)new File("lib"), (ClassLoader)Main.class.getClassLoader()));
        SelectorThread selectorThread = null;
        String selectorThreadClassname = System.getProperty(SELECTOR_THREAD);
        if (selectorThreadClassname != null) {
            selectorThread = (SelectorThread)Main.loadInstance(selectorThreadClassname);
        } else {
            selectorThread = new SelectorThread();
            selectorThread.setAlgorithmClassName(StaticStreamAlgorithm.class.getName());
        }
        selectorThread.setPort(port);
        SelectorThread.setWebAppRootPath(folder);
        String adapterClass = System.getProperty(ADAPTER);
        Adapter adapter = adapterClass == null ? new StaticResourcesAdapter() : (Adapter)Main.loadInstance(adapterClass);
        boolean enableRcm = Boolean.valueOf(System.getProperty(ENABLE_RCM));
        selectorThread.enableRcmSupport(enableRcm);
        boolean enableAsync = Boolean.valueOf(System.getProperty(ENABLE_ASYNC));
        selectorThread.setEnableAsyncExecution(enableAsync);
        if (enableAsync) {
            selectorThread.setAsyncHandler(new DefaultAsyncHandler());
        }
        selectorThread.setAdapter(adapter);
        selectorThread.setDisplayConfiguration(true);
        selectorThread.initEndpoint();
        selectorThread.startEndpoint();
    }

    private static Object loadInstance(String property) {
        Class<?> className = null;
        try {
            className = Class.forName(property, true, Thread.currentThread().getContextClassLoader());
            return className.newInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

