/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.Context;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.util.Copyable;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SelectorThreadHandler
extends TCPSelectorHandler {
    private SelectorThread selectorThread;

    public void copyTo(Copyable copy) {
        super.copyTo(copy);
        SelectorThreadHandler copyHandler = (SelectorThreadHandler)copy;
        copyHandler.selectorThread = this.selectorThread;
    }

    public void setSelectorThread(SelectorThread selectorThread) {
        this.selectorThread = selectorThread;
    }

    public void preSelect(Context controllerCtx) throws IOException {
        if (this.selector != null) {
            if (this.opReadToRegister == null) {
                this.opReadToRegister = new ConcurrentLinkedQueue();
            }
            int size = this.opReadToRegister.size();
            long currentTime = 0L;
            if (size > 0) {
                currentTime = System.currentTimeMillis();
            }
            for (int i = 0; i < size; ++i) {
                SelectionKey key = (SelectionKey)this.opReadToRegister.poll();
                key.interestOps(key.interestOps() | 1);
                if (key.attachment() == null) {
                    key.attach(currentTime);
                }
                this.selectorThread.keepAliveCounter.trap(key);
            }
        } else {
            super.preSelect(controllerCtx);
        }
    }
}

