/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.http.AsyncHandler;
import com.sun.grizzly.http.Constants;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.SocketChannelOutputBuffer;
import com.sun.grizzly.http.TaskBase;
import com.sun.grizzly.http.TaskEvent;
import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.ActionHook;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Processor;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.RequestInfo;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.InputFilter;
import com.sun.grizzly.tcp.http11.InternalInputBuffer;
import com.sun.grizzly.tcp.http11.InternalOutputBuffer;
import com.sun.grizzly.tcp.http11.OutputFilter;
import com.sun.grizzly.tcp.http11.filters.BufferedInputFilter;
import com.sun.grizzly.tcp.http11.filters.ChunkedInputFilter;
import com.sun.grizzly.tcp.http11.filters.ChunkedOutputFilter;
import com.sun.grizzly.tcp.http11.filters.GzipOutputFilter;
import com.sun.grizzly.tcp.http11.filters.IdentityInputFilter;
import com.sun.grizzly.tcp.http11.filters.IdentityOutputFilter;
import com.sun.grizzly.tcp.http11.filters.VoidInputFilter;
import com.sun.grizzly.tcp.http11.filters.VoidOutputFilter;
import com.sun.grizzly.util.ByteBufferInputStream;
import com.sun.grizzly.util.Interceptor;
import com.sun.grizzly.util.buf.Ascii;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.HexUtils;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.FastHttpDateFormat;
import com.sun.grizzly.util.http.MimeHeaders;
import com.sun.grizzly.util.net.SSLSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import javax.management.ObjectName;

public class DefaultProcessorTask
extends TaskBase
implements Processor,
ActionHook,
ProcessorTask {
    protected Adapter adapter = null;
    protected Request request = null;
    protected Response response = null;
    protected InternalInputBuffer inputBuffer = null;
    protected ByteBufferInputStream inputStream = null;
    protected OutputStream outputStream = null;
    protected InternalOutputBuffer outputBuffer = null;
    protected boolean started = false;
    protected boolean error = false;
    protected boolean keepAlive = true;
    protected boolean connectionHeaderValueSet = false;
    protected boolean http11 = true;
    protected boolean http09 = false;
    protected boolean contentDelimitation = true;
    protected SSLSupport sslSupport;
    protected Socket socket;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected String localName = null;
    protected int localPort = -1;
    protected int remotePort = -1;
    protected String localAddr = null;
    protected int timeout = 300000;
    protected int maxPostSize = 0x200000;
    protected char[] hostNameC = new char[0];
    protected boolean hasRequestInfoRegistered = false;
    protected int maxHttpHeaderSize = 8192;
    protected static int requestCount;
    protected int requestBufferSize = 8192;
    protected ObjectName oname;
    protected boolean dropConnection = false;
    protected int keepAliveLeft;
    protected Interceptor handler;
    protected String defaultResponseType = "text/plain; charset=iso-8859-1";
    protected String forcedRequestType = "text/plain; charset=iso-8859-1";
    protected boolean asyncExecution = false;
    protected RequestInfo requestInfo;
    protected AsyncHandler asyncHandler;
    protected String[] noCompressionUserAgents = null;
    protected String[] compressableMimeTypes = new String[]{"text/html", "text/xml", "text/plain"};
    protected int compressionLevel = 0;
    protected int compressionMinSize = 2048;
    protected String[] restrictedUserAgents = null;
    protected boolean bufferResponse = true;

    public DefaultProcessorTask() {
        this(true);
    }

    public DefaultProcessorTask(boolean init) {
        this.type = 2;
        if (init) {
            this.initialize();
        }
    }

    public DefaultProcessorTask(boolean init, boolean bufferResponse) {
        this.bufferResponse = bufferResponse;
        this.type = 2;
        if (init) {
            this.initialize();
        }
    }

    public void initialize() {
        this.started = true;
        this.request = new Request();
        this.response = new Response();
        this.response.setHook(this);
        this.inputBuffer = new InternalInputBuffer(this.request, this.requestBufferSize);
        this.outputBuffer = new SocketChannelOutputBuffer(this.response, this.maxHttpHeaderSize, this.bufferResponse);
        this.request.setInputBuffer(this.inputBuffer);
        this.response.setOutputBuffer(this.outputBuffer);
        this.request.setResponse(this.response);
        this.initializeFilters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTask() throws IOException {
        try {
            this.process((InputStream)this.inputStream, this.outputStream);
        }
        catch (Throwable ex) {
            SelectorThread.logger().log(Level.FINE, "processorTask.errorProcessingRequest", ex);
        }
        finally {
            this.terminateProcess();
        }
    }

    public void preProcess() throws Exception {
        this.preProcess((InputStream)this.inputStream, this.outputStream);
    }

    public void preProcess(InputStream input, OutputStream output) throws Exception {
        if (!this.started) {
            this.initialize();
        }
        this.inputBuffer.setInputStream(input);
        if (this.key != null) {
            this.inputStream = (ByteBufferInputStream)input;
            SocketChannelOutputBuffer channelOutputBuffer = (SocketChannelOutputBuffer)this.outputBuffer;
            channelOutputBuffer.setChannel((SocketChannel)this.key.channel());
        }
        this.configPreProcess();
    }

    protected void configPreProcess() throws Exception {
        if (this.isMonitoringEnabled()) {
            this.adapter.fireAdapterEvent("connectionProcessingStarted", this.request.getRequestProcessor());
        }
        if (this.selectorThread.getDomain() != null && this.isMonitoringEnabled() && !this.hasRequestInfoRegistered) {
            this.registerMonitoring();
        } else if (!this.isMonitoringEnabled() && this.hasRequestInfoRegistered) {
            this.unregisterMonitoring();
        }
        if (this.isMonitoringEnabled()) {
            this.requestInfo = this.request.getRequestProcessor();
            this.requestInfo.setWorkerThreadID(Thread.currentThread().getId());
        }
        this.remoteAddr = null;
        this.remoteHost = null;
        this.localName = null;
        this.localAddr = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.connectionHeaderValueSet = false;
        this.error = false;
        this.keepAlive = true;
        if (this.request.getServerPort() == 0) {
            this.request.setServerPort(this.selectorThread.getPort());
        }
    }

    protected boolean doProcess() throws Exception {
        return this.doProcess((InputStream)this.inputStream, this.outputStream);
    }

    protected boolean doProcess(InputStream input, OutputStream output) throws Exception {
        boolean exitWhile = this.parseRequest(input, output, false);
        if (exitWhile) {
            return exitWhile;
        }
        this.invokeAdapter();
        this.postResponse();
        return this.error;
    }

    public void postResponse() throws Exception {
        try {
            this.adapter.afterService(this.request, this.response);
        }
        catch (Exception ex) {
            this.error = true;
            SelectorThread.logger().log(Level.FINEST, "processorTask.errorFinishingRequest", ex);
        }
        try {
            this.inputBuffer.endRequest();
        }
        catch (IOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            SelectorThread.logger().log(Level.SEVERE, "processorTask.errorFinishingRequest", t);
            this.response.setStatus(500);
            this.error = true;
        }
        try {
            this.outputBuffer.endRequest();
        }
        catch (IOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            SelectorThread.logger().log(Level.SEVERE, "processorTask.errorFinishingResponse", t);
            this.error = true;
        }
        if (this.error) {
            this.response.setStatus(500);
        }
        if (this.isMonitoringEnabled()) {
            this.request.updateCounters();
            this.adapter.fireAdapterEvent("requestProcessingCompleted", this.request.getRequestProcessor());
        }
        this.inputBuffer.nextRequest();
        this.outputBuffer.nextRequest();
    }

    public void invokeAdapter() {
        if (!this.error) {
            try {
                this.adapter.service(this.request, this.response);
                if (this.keepAlive && !this.error) {
                    this.error = this.response.getErrorException() != null || this.statusDropsConnection(this.response.getStatus());
                }
            }
            catch (InterruptedIOException e) {
                this.error = true;
            }
            catch (Throwable t) {
                SelectorThread.logger().log(Level.SEVERE, "processorTask.serviceError", t);
                this.response.setStatus(500);
                this.error = true;
            }
        }
    }

    public void parseRequest() throws Exception {
        this.parseRequest((InputStream)this.inputStream, this.outputStream, true);
    }

    public boolean parseRequest(InputStream input, OutputStream output, boolean keptAlive) throws Exception {
        try {
            if (this.isMonitoringEnabled()) {
                this.adapter.fireAdapterEvent("requestProcessingStarted", this.request.getRequestProcessor());
            }
            this.inputBuffer.parseRequestLine();
            if (this.isMonitoringEnabled()) {
                this.request.getRequestProcessor().setRequestCompletionTime(0L);
            }
            this.request.setStartTime(System.currentTimeMillis());
            if (this.handler != null && this.handler.handle((Object)this.request, 0) == 1) {
                return true;
            }
            keptAlive = true;
            this.inputBuffer.parseHeaders();
            if (this.selectorThread.isEnableNioLogging()) {
                SelectorThread.logger().log(Level.INFO, "SocketChannel request line" + this.key.channel() + " is: " + this.request);
                SelectorThread.logger().log(Level.INFO, "SocketChannel headers" + this.key.channel() + " are: " + this.request.getMimeHeaders());
            }
        }
        catch (IOException e) {
            SelectorThread.logger().log(Level.FINEST, "processorTask.nonBlockingError", e);
            this.error = true;
            this.keepAlive = false;
            return true;
        }
        catch (Throwable t) {
            SelectorThread.logger().log(Level.SEVERE, "processorTask.nonBlockingError", t);
            this.response.setStatus(400);
            this.error = true;
        }
        try {
            this.prepareRequest();
        }
        catch (Throwable t) {
            SelectorThread.logger().log(Level.FINE, "processorTask.createRequestError", t);
            this.response.setStatus(400);
            this.error = true;
        }
        return false;
    }

    public void postProcess() throws Exception {
        this.postProcess((InputStream)this.inputStream, this.outputStream);
    }

    public void postProcess(InputStream input, OutputStream output) throws Exception {
        if (!this.recycle) {
            this.started = false;
            this.inputBuffer = null;
            this.outputBuffer = null;
            this.response = null;
            if (this.isMonitoringEnabled()) {
                this.request.getRequestProcessor().setWorkerThreadID(0L);
                this.adapter.fireAdapterEvent("connectionProcessingCompleted", this.request.getRequestProcessor());
            }
            this.request = null;
        } else {
            this.inputBuffer.recycle();
            this.outputBuffer.recycle();
        }
        this.sslSupport = null;
        if (this.error) {
            this.keepAlive = false;
            this.connectionHeaderValueSet = false;
        }
    }

    public void terminateProcess() {
        TaskEvent<DefaultProcessorTask> event = new TaskEvent<DefaultProcessorTask>();
        if (this.error) {
            event.setStatus(1);
        } else {
            event.setStatus(2);
        }
        event.attach(this);
        this.fireTaskEvent(event);
    }

    public boolean process(InputStream input, OutputStream output) throws Exception {
        this.preProcess(input, output);
        this.doProcess(input, output);
        this.postProcess(input, output);
        return this.keepAlive;
    }

    public String getRequestURI() {
        return this.request.requestURI().toString();
    }

    public void action(ActionCode actionCode, Object param) {
        block71: {
            if (actionCode == ActionCode.ACTION_COMMIT) {
                if (this.response.isCommitted()) {
                    return;
                }
                this.prepareResponse();
                try {
                    this.outputBuffer.commit();
                }
                catch (IOException ex) {
                    SelectorThread.logger().log(Level.FINEST, "processorTask.nonBlockingError", ex);
                    this.error = true;
                }
            } else if (actionCode == ActionCode.ACTION_ACK) {
                if (this.response.isCommitted() || !this.http11) {
                    return;
                }
                MessageBytes expectMB = this.request.getMimeHeaders().getValue("expect");
                if (expectMB != null && expectMB.indexOfIgnoreCase("100-continue", 0) != -1) {
                    try {
                        this.outputBuffer.sendAck();
                    }
                    catch (IOException e) {
                        this.error = true;
                    }
                }
            } else if (actionCode == ActionCode.ACTION_CLOSE) {
                try {
                    this.outputBuffer.endRequest();
                }
                catch (IOException e) {
                    SelectorThread.logger().log(Level.FINEST, "processorTask.nonBlockingError", e);
                    this.error = true;
                }
                if (this.key != null) {
                    try {
                        ((SocketChannelOutputBuffer)this.outputBuffer).flushBuffer();
                    }
                    catch (IOException ioe) {
                        if (SelectorThread.logger().isLoggable(Level.FINEST)) {
                            SelectorThread.logger().log(Level.FINEST, "ACTION_POST_REQUEST", ioe);
                        }
                        this.error = true;
                    }
                }
            } else if (actionCode == ActionCode.ACTION_RESET) {
                this.outputBuffer.reset();
            } else if (actionCode != ActionCode.ACTION_CUSTOM) {
                if (actionCode == ActionCode.ACTION_START) {
                    this.started = true;
                } else if (actionCode == ActionCode.ACTION_STOP) {
                    this.started = false;
                } else if (actionCode == ActionCode.ACTION_REQ_SSL_ATTRIBUTE) {
                    try {
                        if (this.sslSupport == null) break block71;
                        Object sslO = this.sslSupport.getCipherSuite();
                        if (sslO != null) {
                            this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                        }
                        if ((sslO = this.sslSupport.getPeerCertificateChain(false)) != null) {
                            this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                        }
                        if ((sslO = this.sslSupport.getKeySize()) != null) {
                            this.request.setAttribute("javax.servlet.request.key_size", sslO);
                        }
                        if ((sslO = this.sslSupport.getSessionId()) != null) {
                            this.request.setAttribute("javax.servlet.request.ssl_session", sslO);
                        }
                    }
                    catch (Exception e) {
                        SelectorThread.logger().log(Level.WARNING, "processorTask.errorSSL", e);
                    }
                } else if (actionCode == ActionCode.ACTION_REQ_HOST_ADDR_ATTRIBUTE) {
                    InetAddress inetAddr;
                    if (this.remoteAddr == null && this.socket != null && (inetAddr = this.socket.getInetAddress()) != null) {
                        this.remoteAddr = inetAddr.getHostAddress();
                    }
                    this.request.remoteAddr().setString(this.remoteAddr);
                } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_NAME_ATTRIBUTE) {
                    InetAddress inetAddr;
                    if (this.localName == null && this.socket != null && (inetAddr = this.socket.getLocalAddress()) != null) {
                        this.localName = inetAddr.getHostName();
                    }
                    this.request.localName().setString(this.localName);
                } else if (actionCode == ActionCode.ACTION_REQ_HOST_ATTRIBUTE) {
                    if (this.remoteHost == null && this.socket != null) {
                        InetAddress inetAddr = this.socket.getInetAddress();
                        if (inetAddr != null) {
                            this.remoteHost = inetAddr.getHostName();
                        }
                        if (this.remoteHost == null) {
                            if (this.remoteAddr != null) {
                                this.remoteHost = this.remoteAddr;
                            } else {
                                this.request.remoteHost().recycle();
                            }
                        }
                    }
                    this.request.remoteHost().setString(this.remoteHost);
                } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_ADDR_ATTRIBUTE) {
                    if (this.localAddr == null) {
                        this.localAddr = this.socket.getLocalAddress().getHostAddress();
                    }
                    this.request.localAddr().setString(this.localAddr);
                } else if (actionCode == ActionCode.ACTION_REQ_REMOTEPORT_ATTRIBUTE) {
                    if (this.remotePort == -1 && this.socket != null) {
                        this.remotePort = this.socket.getPort();
                    }
                    this.request.setRemotePort(this.remotePort);
                } else if (actionCode == ActionCode.ACTION_REQ_LOCALPORT_ATTRIBUTE) {
                    if (this.localPort == -1 && this.socket != null) {
                        this.localPort = this.socket.getLocalPort();
                    }
                    this.request.setLocalPort(this.localPort);
                } else if (actionCode == ActionCode.ACTION_REQ_SSL_CERTIFICATE) {
                    if (this.sslSupport != null) {
                        InputFilter[] inputFilters = this.inputBuffer.getFilters();
                        ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxPostSize);
                        this.inputBuffer.addActiveFilter(inputFilters[3]);
                        try {
                            Object[] sslO = this.sslSupport.getPeerCertificateChain(true);
                            if (sslO != null) {
                                this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                            }
                        }
                        catch (Exception e) {
                            SelectorThread.logger().log(Level.WARNING, "processorTask.exceptionSSLcert", e);
                        }
                    }
                } else if (actionCode == ActionCode.ACTION_POST_REQUEST) {
                    if (this.response.getStatus() == 200 && this.handler != null) {
                        try {
                            this.handler.handle((Object)this.request, 1);
                        }
                        catch (IOException ex) {
                            SelectorThread.logger().log(Level.FINEST, "Handler exception", ex);
                        }
                    }
                } else if (actionCode == ActionCode.ACTION_CLIENT_FLUSH && this.key != null) {
                    SocketChannelOutputBuffer channelOutputBuffer = (SocketChannelOutputBuffer)this.outputBuffer;
                    try {
                        channelOutputBuffer.flush();
                    }
                    catch (IOException ex) {
                        if (SelectorThread.logger().isLoggable(Level.FINEST)) {
                            SelectorThread.logger().log(Level.FINEST, "ACTION_CLIENT_FLUSH", ex);
                        }
                        this.error = true;
                    }
                }
            }
        }
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    protected void prepareRequest() {
        ByteChunk uriBC;
        MessageBytes protocolMB;
        this.http11 = true;
        this.http09 = false;
        this.contentDelimitation = false;
        if (this.sslSupport != null) {
            this.request.scheme().setString("https");
        }
        if ((protocolMB = this.request.protocol()).equals("HTTP/1.1")) {
            this.http11 = true;
            protocolMB.setString("HTTP/1.1");
        } else if (protocolMB.equals("HTTP/1.0")) {
            this.http11 = false;
            this.keepAlive = false;
            protocolMB.setString("HTTP/1.0");
        } else if (protocolMB.equals("")) {
            this.http09 = true;
            this.http11 = false;
            this.keepAlive = false;
        } else {
            this.http11 = false;
            this.error = true;
            this.response.setStatus(505);
        }
        MessageBytes methodMB = this.request.method();
        if (methodMB.equals("GET")) {
            methodMB.setString("GET");
        } else if (methodMB.equals("POST")) {
            methodMB.setString("POST");
        }
        MimeHeaders headers = this.request.getMimeHeaders();
        MessageBytes connectionValueMB = headers.getValue("connection");
        if (connectionValueMB != null) {
            ByteChunk connectionValueBC = connectionValueMB.getByteChunk();
            if (this.findBytes(connectionValueBC, Constants.CLOSE_BYTES) != -1) {
                this.keepAlive = false;
                this.connectionHeaderValueSet = false;
            } else if (this.findBytes(connectionValueBC, Constants.KEEPALIVE_BYTES) != -1) {
                this.keepAlive = true;
                this.connectionHeaderValueSet = true;
            }
        }
        if (this.restrictedUserAgents != null && (this.http11 || this.keepAlive)) {
            MessageBytes userAgentValueMB = this.request.getMimeHeaders().getValue("user-agent");
            String userAgentValue = userAgentValueMB.toString();
            for (int i = 0; i < this.restrictedUserAgents.length; ++i) {
                if (!this.restrictedUserAgents[i].equals(userAgentValue)) continue;
                this.http11 = false;
                this.keepAlive = false;
            }
        }
        if ((uriBC = this.request.requestURI().getByteChunk()).startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 0, 3, 4);
            int uriBCStart = uriBC.getStart();
            int slashPos = -1;
            if (pos != -1) {
                byte[] uriB = uriBC.getBytes();
                slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    this.request.requestURI().setBytes(uriB, uriBCStart + pos + 1, 1);
                } else {
                    this.request.requestURI().setBytes(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                MessageBytes hostMB = headers.setValue("host");
                hostMB.setBytes(uriB, uriBCStart + pos + 3, slashPos - pos - 3);
            }
        }
        InputFilter[] inputFilters = this.inputBuffer.getFilters();
        long contentLength = this.request.getContentLengthLong();
        if (contentLength >= 0L) {
            this.inputBuffer.addActiveFilter(inputFilters[0]);
            this.contentDelimitation = true;
        }
        MessageBytes transferEncodingValueMB = null;
        if (this.http11) {
            transferEncodingValueMB = headers.getValue("transfer-encoding");
        }
        if (transferEncodingValueMB != null) {
            String transferEncodingValue = transferEncodingValueMB.toString();
            int startPos = 0;
            int commaPos = transferEncodingValue.indexOf(44);
            String encodingName = null;
            while (commaPos != -1) {
                encodingName = transferEncodingValue.substring(startPos, commaPos).toLowerCase().trim();
                if (!this.addInputFilter(inputFilters, encodingName)) {
                    this.error = true;
                    this.response.setStatus(501);
                }
                startPos = commaPos + 1;
                commaPos = transferEncodingValue.indexOf(44, startPos);
            }
            encodingName = transferEncodingValue.substring(startPos).toLowerCase().trim();
            if (!this.addInputFilter(inputFilters, encodingName)) {
                this.error = true;
                this.response.setStatus(501);
            }
        }
        MessageBytes valueMB = headers.getValue("host");
        if (this.http11 && valueMB == null) {
            this.error = true;
            this.response.setStatus(400);
        }
        this.parseHost(valueMB);
        if (!this.contentDelimitation) {
            this.inputBuffer.addActiveFilter(inputFilters[2]);
            this.contentDelimitation = true;
        }
    }

    public void parseHost(MessageBytes valueMB) {
        if (valueMB == null || valueMB.isNull()) {
            this.request.setServerPort(this.socket.getLocalPort());
            InetAddress localAddress = this.socket.getLocalAddress();
            this.request.setLocalHost(localAddress.getHostName());
            this.request.serverName().setString(localAddress.getHostName());
            return;
        }
        ByteChunk valueBC = valueMB.getByteChunk();
        byte[] valueB = valueBC.getBytes();
        int valueL = valueBC.getLength();
        int valueS = valueBC.getStart();
        int colonPos = -1;
        if (this.hostNameC.length < valueL) {
            this.hostNameC = new char[valueL];
        }
        boolean ipv6 = valueB[valueS] == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            char b;
            this.hostNameC[i] = b = (char)valueB[i + valueS];
            if (b == ']') {
                bracketClosed = true;
                continue;
            }
            if (b != ':' || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            if (this.sslSupport == null) {
                this.request.setServerPort(80);
            } else {
                this.request.setServerPort(443);
            }
            this.request.serverName().setChars(this.hostNameC, 0, valueL);
        } else {
            this.request.serverName().setChars(this.hostNameC, 0, colonPos);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = HexUtils.DEC[valueB[i + valueS]];
                if (charValue == -1) {
                    this.error = true;
                    this.response.setStatus(400);
                    break;
                }
                port += charValue * mult;
                mult = 10 * mult;
            }
            this.request.setServerPort(port);
        }
    }

    protected void prepareResponse() {
        MessageBytes methodMB;
        boolean entityBody = true;
        this.contentDelimitation = false;
        OutputFilter[] outputFilters = this.outputBuffer.getFilters();
        if (this.http09) {
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            return;
        }
        int statusCode = this.response.getStatus();
        if (statusCode == 204 || statusCode == 205 || statusCode == 304) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            entityBody = false;
            this.contentDelimitation = true;
        }
        boolean useCompression = false;
        if (entityBody && this.compressionLevel > 0 && (useCompression = this.isCompressable())) {
            this.response.setContentLength(-1);
        }
        if ((methodMB = this.request.method()).equals("HEAD")) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
        }
        MimeHeaders headers = this.response.getMimeHeaders();
        if (!entityBody) {
            this.response.setContentLength(-1);
        } else {
            String contentType = this.response.getContentType();
            if (contentType != null) {
                headers.setValue("Content-Type").setString(contentType);
            } else {
                headers.setValue("Content-Type").setString(this.defaultResponseType);
            }
            String contentLanguage = this.response.getContentLanguage();
            if (contentLanguage != null) {
                headers.setValue("Content-Language").setString(contentLanguage);
            }
        }
        int contentLength = this.response.getContentLength();
        if (contentLength != -1) {
            headers.setValue("Content-Length").setInt(contentLength);
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            this.contentDelimitation = true;
        } else if (entityBody && this.http11 && this.keepAlive) {
            this.outputBuffer.addActiveFilter(outputFilters[1]);
            this.contentDelimitation = true;
            this.response.addHeader("Transfer-Encoding", "chunked");
        } else {
            this.outputBuffer.addActiveFilter(outputFilters[0]);
        }
        if (useCompression) {
            this.outputBuffer.addActiveFilter(outputFilters[3]);
            this.response.setHeader("Content-Encoding", "gzip");
            this.response.setHeader("Vary", "Accept-Encoding");
        }
        if (!this.response.containsHeader("Date")) {
            String date = FastHttpDateFormat.getCurrentDate();
            this.response.addHeader("Date", date);
        }
        if (entityBody && !this.contentDelimitation) {
            this.keepAlive = false;
        }
        boolean bl = this.keepAlive = this.keepAlive && !this.statusDropsConnection(statusCode) && !this.dropConnection;
        if (!this.keepAlive) {
            headers.setValue("Connection").setString("close");
            this.connectionHeaderValueSet = false;
        } else if (!this.http11 && !this.error) {
            headers.setValue("Connection").setString("Keep-Alive");
        }
        this.outputBuffer.sendStatus();
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            this.outputBuffer.sendHeader(headers.getName(i), headers.getValue(i));
        }
        this.outputBuffer.endHeaders();
    }

    protected void initializeFilters() {
        this.inputBuffer.addFilter(new IdentityInputFilter());
        this.outputBuffer.addFilter(new IdentityOutputFilter());
        this.inputBuffer.addFilter(new ChunkedInputFilter());
        this.outputBuffer.addFilter(new ChunkedOutputFilter());
        this.inputBuffer.addFilter(new VoidInputFilter());
        this.outputBuffer.addFilter(new VoidOutputFilter());
        this.inputBuffer.addFilter(new BufferedInputFilter());
        this.outputBuffer.addFilter(new GzipOutputFilter());
    }

    protected boolean addInputFilter(InputFilter[] inputFilters, String encodingName) {
        if (!encodingName.equals("identity")) {
            if (encodingName.equals("chunked")) {
                this.inputBuffer.addActiveFilter(inputFilters[1]);
                this.contentDelimitation = true;
            } else {
                for (int i = 2; i < inputFilters.length; ++i) {
                    if (!inputFilters[i].getEncodingName().toString().equals(encodingName)) continue;
                    this.inputBuffer.addActiveFilter(inputFilters[i]);
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    protected int findBytes(ByteChunk bc, byte[] b) {
        byte first = b[0];
        byte[] buff = bc.getBuffer();
        int start = bc.getStart();
        int end = bc.getEnd();
        int srcEnd = b.length;
        for (int i = start; i <= end - srcEnd; ++i) {
            if (Ascii.toLower((int)buff[i]) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower((int)buff[myPos++]) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - start;
            }
        }
        return -1;
    }

    protected boolean statusDropsConnection(int status) {
        return status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 500 || status == 503 || status == 501;
    }

    protected void addFilter(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Object obj = clazz.newInstance();
            if (obj instanceof InputFilter) {
                this.inputBuffer.addFilter((InputFilter)obj);
            } else if (obj instanceof OutputFilter) {
                this.outputBuffer.addFilter((OutputFilter)obj);
            } else {
                SelectorThread.logger().log(Level.WARNING, "processorTask.unknownFilter", className);
            }
        }
        catch (Exception e) {
            SelectorThread.logger().log(Level.SEVERE, "processorTask.errorFilter", new Object[]{className, e});
        }
    }

    public void setMaxPostSize(int mps) {
        this.maxPostSize = mps;
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public void setTimeout(int timeouts) {
        this.timeout = timeouts;
    }

    public int getTimeout() {
        return this.timeout;
    }

    private void registerMonitoring() {
        if (this.selectorThread.getManagement() == null) {
            return;
        }
        RequestInfo requestInfo = this.request.getRequestProcessor();
        requestInfo.setGlobalProcessor(this.getRequestGroupInfo());
        try {
            this.oname = new ObjectName(this.selectorThread.getDomain() + ":type=RequestProcessor,worker=http" + this.selectorThread.getPort() + ",name=HttpRequest" + requestCount++);
            this.selectorThread.getManagement().registerComponent(requestInfo, this.oname, null);
        }
        catch (Exception ex) {
            SelectorThread.logger().log(Level.WARNING, "processorTask.errorRegisteringRequest", ex);
        }
        this.hasRequestInfoRegistered = true;
    }

    private void unregisterMonitoring() {
        if (this.selectorThread.getManagement() == null) {
            return;
        }
        RequestInfo requestInfo = this.request.getRequestProcessor();
        requestInfo.setGlobalProcessor(null);
        requestInfo.reset();
        if (this.oname != null) {
            try {
                this.selectorThread.getManagement().unregisterComponent(this.oname);
            }
            catch (Exception ex) {
                SelectorThread.logger().log(Level.WARNING, "processorTask.errorUnregisteringRequest", ex);
            }
        }
        this.hasRequestInfoRegistered = false;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        this.maxHttpHeaderSize = maxHttpHeaderSize;
    }

    public void setBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public int getBufferSize() {
        return this.requestBufferSize;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setDropConnection(boolean dropConnection) {
        this.dropConnection = dropConnection;
    }

    public boolean getDropConnection() {
        return this.dropConnection;
    }

    public void setHandler(Interceptor handler) {
        this.handler = handler;
    }

    public Interceptor getHandler() {
        return this.handler;
    }

    public void setDefaultResponseType(String defaultResponseType) {
        this.defaultResponseType = defaultResponseType;
    }

    public String getDefaultResponseType() {
        return this.defaultResponseType;
    }

    public void setForcedRequestType(String forcedRequestType) {
        this.forcedRequestType = forcedRequestType;
    }

    public String getForcedRequestType() {
        return this.forcedRequestType;
    }

    public void setEnableAsyncExecution(boolean asyncExecution) {
        this.asyncExecution = asyncExecution;
    }

    public boolean isAsyncExecutionEnabled() {
        return this.asyncExecution;
    }

    public void setAsyncHandler(AsyncHandler asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    public AsyncHandler getAsyncHandler() {
        return this.asyncHandler;
    }

    public Request getRequest() {
        return this.request;
    }

    public void recycle() {
        if (this.listeners != null && this.listeners.size() > 0) {
            this.clearTaskListeners();
        }
        this.socket = null;
        this.dropConnection = false;
        this.key = null;
    }

    public String getCompression() {
        switch (this.compressionLevel) {
            case 0: {
                return "off";
            }
            case 1: {
                return "on";
            }
            case 2: {
                return "force";
            }
        }
        return "off";
    }

    public void setCompression(String compression) {
        if (compression.equals("on")) {
            this.compressionLevel = 1;
        } else if (compression.equals("force")) {
            this.compressionLevel = 2;
        } else if (compression.equals("off")) {
            this.compressionLevel = 0;
        } else {
            try {
                this.compressionMinSize = Integer.parseInt(compression);
                this.compressionLevel = 1;
            }
            catch (Exception e) {
                this.compressionLevel = 0;
            }
        }
    }

    public void addNoCompressionUserAgent(String userAgent) {
        this.addStringArray(this.noCompressionUserAgents, userAgent);
    }

    public void setNoCompressionUserAgents(String[] noCompressionUserAgents) {
        this.noCompressionUserAgents = noCompressionUserAgents;
    }

    public String[] findNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void addCompressableMimeType(String mimeType) {
        this.addStringArray(this.compressableMimeTypes, mimeType);
    }

    public void setCompressableMimeType(String[] compressableMimeTypes) {
        this.compressableMimeTypes = compressableMimeTypes;
    }

    public String[] findCompressableMimeTypes() {
        return this.compressableMimeTypes;
    }

    private void addStringArray(String[] sArray, String value) {
        if (sArray == null) {
            sArray = new String[]{};
        }
        String[] results = new String[sArray.length + 1];
        System.arraycopy(sArray, 0, results, 0, sArray.length);
        results[sArray.length] = value;
        sArray = results;
    }

    private boolean inStringArray(String[] sArray, String value) {
        for (int i = 0; i < sArray.length; ++i) {
            if (!sArray[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    private boolean isCompressable() {
        MessageBytes userAgentValueMB;
        String userAgentValue;
        if (!this.http11) {
            return false;
        }
        MessageBytes acceptEncodingMB = this.request.getMimeHeaders().getValue("accept-encoding");
        if (acceptEncodingMB == null || acceptEncodingMB.indexOf("gzip") == -1) {
            return false;
        }
        MessageBytes contentEncodingMB = this.response.getMimeHeaders().getValue("Content-Encoding");
        if (contentEncodingMB != null && contentEncodingMB.indexOf("gzip") != -1) {
            return false;
        }
        if (this.compressionLevel == 2) {
            return true;
        }
        if (this.noCompressionUserAgents != null && this.inStringArray(this.noCompressionUserAgents, userAgentValue = (userAgentValueMB = this.request.getMimeHeaders().getValue("user-agent")).toString())) {
            return false;
        }
        int contentLength = this.response.getContentLength();
        if ((contentLength == -1 || contentLength > this.compressionMinSize) && this.compressableMimeTypes != null) {
            return this.inStringArray(this.compressableMimeTypes, this.response.getContentType());
        }
        return false;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
    }

    public void addRestrictedUserAgent(String userAgent) {
        this.addStringArray(this.restrictedUserAgents, userAgent);
    }

    public void setRestrictedUserAgents(String[] restrictedUserAgents) {
        this.restrictedUserAgents = restrictedUserAgents;
    }

    public String[] findRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public SSLSupport getSSLSupport() {
        return this.sslSupport;
    }

    public void setSSLSupport(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }

    public long getWorkerThreadID() {
        return this.request.getRequestProcessor().getWorkerThreadID();
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setConnectionHeaderValueSet(boolean connectionHeaderValueSet) {
        this.connectionHeaderValueSet = connectionHeaderValueSet;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public ByteBufferInputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(ByteBufferInputStream inputStream) {
        this.inputStream = inputStream;
    }
}

