/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.arp;

import com.sun.grizzly.Context;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.http.DefaultProcessorTask;
import com.sun.grizzly.http.HttpWorkerThread;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.TaskEvent;
import com.sun.grizzly.http.TaskListener;
import com.sun.grizzly.http.algorithms.NoParsingAlgorithm;
import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.ByteBufferInputStream;
import com.sun.grizzly.util.StreamAlgorithm;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AsyncProtocolFilter
implements ProtocolFilter,
TaskListener {
    private Class algorithmClass;
    private int port;
    private static final Logger logger = SelectorThread.logger();
    private ConcurrentLinkedQueue<ByteBufferInputStream> byteBufferStreams = new ConcurrentLinkedQueue();
    protected int bbSize = 4096;

    public AsyncProtocolFilter(Class algorithmClass, int port) {
        this.algorithmClass = algorithmClass;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context ctx) throws IOException {
        HttpWorkerThread workerThread = (HttpWorkerThread)((Object)Thread.currentThread());
        StreamAlgorithm streamAlgorithm = workerThread.getStreamAlgorithm();
        if (streamAlgorithm == null) {
            try {
                streamAlgorithm = (StreamAlgorithm)this.algorithmClass.newInstance();
            }
            catch (InstantiationException ex) {
                logger.log(Level.WARNING, "Unable to instantiate Algorithm: " + this.algorithmClass.getName());
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.WARNING, "Unable to instantiate Algorithm: " + this.algorithmClass.getName());
            }
            finally {
                if (streamAlgorithm == null) {
                    streamAlgorithm = new NoParsingAlgorithm();
                }
            }
            streamAlgorithm.setPort(this.port);
            workerThread.setStreamAlgorithm(streamAlgorithm);
        }
        SelectorThread selectorThread = SelectorThread.getSelector(this.port);
        this.bbSize = SelectorThread.getSelector(this.port).getMaxHttpHeaderSize();
        ByteBufferInputStream inputStream = this.byteBufferStreams.poll();
        if (inputStream == null) {
            inputStream = new ByteBufferInputStream(ByteBufferFactory.allocateView((int)this.bbSize, (boolean)false));
        }
        SelectionKey key = ctx.getSelectionKey();
        inputStream.setSelectionKey(key);
        SocketChannel socketChannel = (SocketChannel)key.channel();
        streamAlgorithm.setSocketChannel(socketChannel);
        ByteBuffer nextBuffer = inputStream.getByteBuffer();
        nextBuffer.clear();
        ByteBuffer byteBuffer = workerThread.getByteBuffer();
        workerThread.setByteBuffer(nextBuffer);
        inputStream.setByteBuffer(byteBuffer);
        byteBuffer = streamAlgorithm.preParse(byteBuffer);
        if (streamAlgorithm.parse(byteBuffer)) {
            DefaultProcessorTask processor = (DefaultProcessorTask)selectorThread.getProcessorTask();
            processor.setSelectionKey(key);
            processor.setSocket(socketChannel.socket());
            processor.addTaskListener(this);
            processor.setInputStream(inputStream);
            if (processor.getHandler() == null) {
                processor.setHandler(streamAlgorithm.getHandler());
            }
            try {
                selectorThread.getAsyncHandler().handle(processor);
            }
            catch (Throwable ex) {
                logger.log(Level.INFO, "Processor exception", ex);
                ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                return false;
            }
        }
        ctx.setKeyRegistrationState(Context.KeyRegistrationState.NONE);
        return true;
    }

    public void taskEvent(TaskEvent event) {
        if (event.getStatus() == 2 || event.getStatus() == 1) {
            DefaultProcessorTask processor = (DefaultProcessorTask)event.attachement();
            ByteBufferInputStream is = processor.getInputStream();
            is.getByteBuffer().clear();
            this.byteBufferStreams.offer(is);
            SelectorThread selectorThread = processor.getSelectorThread();
            if (processor.isKeepAlive() && !processor.isError()) {
                selectorThread.registerKey(processor.getSelectionKey());
            } else {
                selectorThread.cancelKey(processor.getSelectionKey());
            }
            processor.recycle();
            selectorThread.returnTask(processor);
        }
    }

    public boolean postExecute(Context ctx) throws IOException {
        return true;
    }
}

