/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container.webapp;

import com.sun.phobos.container.ResourceService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class WebappResourceService
implements ResourceService {
    protected ServletContext context;
    protected long timestamp;
    protected Map<String, Boolean> directoryMap;
    protected Map<String, Long> fileLengthMap;
    protected static final int BUFFER_SIZE = 32768;
    protected static final String[] EMPTY_ARRAY = new String[0];

    public WebappResourceService(ServletContext context) {
        this.context = context;
        this.timestamp = System.currentTimeMillis();
        this.directoryMap = new ConcurrentHashMap<String, Boolean>();
        this.fileLengthMap = new ConcurrentHashMap<String, Long>();
    }

    public InputStream getResourceAsStream(String resourcePath) throws IOException {
        return this.context.getResourceAsStream(this.normalize(resourcePath));
    }

    public boolean isResourcePresent(String resourcePath) {
        return this.urlFor(resourcePath) != null;
    }

    public boolean isDirectoryPresent(String resourcePath) {
        Boolean b = this.directoryMap.get(resourcePath = this.normalize(resourcePath));
        if (b != null) {
            return b;
        }
        b = this.checkForDirectory(resourcePath);
        this.directoryMap.put(resourcePath, b);
        return b;
    }

    protected boolean checkForDirectory(String resourcePath) {
        if (resourcePath == "/") {
            return true;
        }
        int len = resourcePath.length();
        int i = resourcePath.lastIndexOf(47);
        if (i != len - 1) {
            resourcePath = resourcePath + "/";
        } else {
            i = resourcePath.lastIndexOf(47, i - 1);
        }
        String parent = resourcePath.substring(0, i + 1);
        String child = resourcePath.substring(i);
        Set resources = this.context.getResourcePaths(parent);
        if (resources == null) {
            return false;
        }
        return resources.contains(child);
    }

    public String getRealPath(String resourcePath) {
        return this.context.getRealPath(this.normalize(resourcePath));
    }

    public long getLastModified(String resourcePath) {
        return this.timestamp;
    }

    public long getLength(String resourcePath) {
        Long len = this.fileLengthMap.get(resourcePath = this.normalize(resourcePath));
        if (len != null) {
            return len;
        }
        len = this.computeLength(resourcePath);
        this.fileLengthMap.put(resourcePath, len);
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long computeLength(String resourcePath) {
        InputStream is = this.context.getResourceAsStream(resourcePath);
        long len = 0L;
        try {
            int count;
            byte[] buffer = new byte[32768];
            do {
                count = is.read(buffer);
                len += (long)count;
            } while (count != -1);
        }
        catch (IOException e) {
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
        return len;
    }

    public String[] getChildren(String resourcePath) {
        String noSlashPath = resourcePath = this.normalize(resourcePath);
        if (resourcePath.endsWith("/")) {
            noSlashPath = resourcePath.substring(0, resourcePath.length() - 1);
        } else {
            resourcePath = resourcePath + "/";
        }
        Set resources = this.context.getResourcePaths(resourcePath);
        if (resources == null) {
            return EMPTY_ARRAY;
        }
        String[] result = new String[resources.size()];
        int index = 0;
        for (Object obj : resources) {
            String s = (String)obj;
            result[index++] = noSlashPath + s;
        }
        return result;
    }

    public OutputStream getOutputStream(String resourcePath, boolean create, boolean append) {
        return null;
    }

    protected boolean isReadOnly(String resourcePath) {
        return true;
    }

    protected String normalize(String resourcePath) {
        if (resourcePath != "" && resourcePath.charAt(0) != '/') {
            resourcePath = "/" + resourcePath;
        }
        if (resourcePath.startsWith("/static/")) {
            return resourcePath.substring(7);
        }
        return "/WEB-INF" + resourcePath;
    }

    protected URL urlFor(String resourcePath) {
        try {
            return this.context.getResource(this.normalize(resourcePath));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

