/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.container.webapp;

import com.sun.facelets.FaceletViewHandler;
import com.sun.phobos.container.PhobosAdapter;
import com.sun.phobos.container.PhobosRuntime;
import com.sun.phobos.container.ScriptingService;
import com.sun.phobos.container.webapp.DebugUtil;
import com.sun.phobos.container.webapp.FastWriter;
import com.sun.phobos.container.webapp.JavaScriptJavaBeanMap;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.script.ScriptContext;
import javax.script.ScriptException;

public class PhobosViewHandler
extends ViewHandlerWrapper {
    private static final Logger logger = Logger.getLogger("com.sun.phobos.webapp", "com.sun.phobos.LogStrings");
    private FaceletViewHandler faceletViewHandler = null;
    private ViewHandler orig = null;
    private static ThreadLocal phobosRenderedView = new ThreadLocal(){

        protected Object initialValue() {
            return null;
        }
    };
    private static final String PHOBOS_TAGLIB_DECL = "xmlns:phobos=\"http://java.sun.com/phobos/webapp\"";
    private static final int PHOBOS_TAGLIB_DECL_LENGTH = "xmlns:phobos=\"http://java.sun.com/phobos/webapp\"".length();
    private static final String PHOBOS_OUTPUT_STATE_TAG = "<phobos:outputState transient=\"true\"/>";
    private static final int PHOBOS_OUTPUT_STATE_TAG_LENGTH = "<phobos:outputState transient=\"true\"/>".length();

    public PhobosViewHandler(ViewHandler orig) {
        this.orig = orig;
        if (logger.isLoggable(Level.INFO)) {
            try {
                Class<?> faceletClass = Class.forName("com.sun.facelets.FaceletViewHandler");
            }
            catch (ClassNotFoundException ex) {
                logger.info("Web Application is incorrectly configured.  Facelets is required.  Please ensure Facelets available on the application classpath.");
            }
        }
        this.faceletViewHandler = new FaceletViewHandler(orig);
    }

    public static String getPhobosRenderedContent() {
        return (String)phobosRenderedView.get();
    }

    public ViewHandler getWrapped() {
        return this.orig;
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        UIViewRoot result = null;
        ExternalContext extContext = context.getExternalContext();
        Map requestMap = extContext.getRequestMap();
        viewId = (String)requestMap.get("com.sun.phobos.webapp.View");
        this.exposeJavaScriptModelObjectToJava(context);
        result = this.faceletViewHandler.createView(context, viewId);
        return result;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        UIViewRoot result = null;
        ExternalContext extContext = context.getExternalContext();
        Map requestMap = extContext.getRequestMap();
        viewId = (String)requestMap.get("com.sun.phobos.webapp.View");
        this.exposeJavaScriptModelObjectToJava(context);
        ViewHandler outerViewHandler = context.getApplication().getViewHandler();
        String renderKitId = outerViewHandler.calculateRenderKitId(context);
        result = context.getApplication().getStateManager().restoreView(context, viewId, renderKitId);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        ExternalContext extContext = context.getExternalContext();
        Map requestMap = extContext.getRequestMap();
        PhobosAdapter adapter = PhobosRuntime.getCurrentAdapter();
        ScriptingService scriptingService = adapter.getScriptingService();
        ScriptContext scriptContext = (ScriptContext)PhobosRuntime.getCurrentEngineBindings().get("context");
        Writer oldWriter = scriptContext.getWriter();
        FastWriter writer = new FastWriter();
        scriptContext.setWriter(writer);
        try {
            scriptingService.evalScript("/framework/helper/jsf-view.js", scriptContext);
        }
        catch (ScriptException se) {
            throw new FacesException((Throwable)se);
        }
        finally {
            scriptContext.setWriter(oldWriter);
        }
        try {
            this.exposeJavaScriptModelObjectToJava(context);
            String viewId = viewToRender.getViewId();
            if ('/' != viewId.charAt(0)) {
                viewToRender.setViewId("/" + viewId);
            }
            phobosRenderedView.set(this.insertOutputStateComponent(writer.toString()));
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "printTreeBeforeFacelets", viewToRender.getViewId());
                DebugUtil.printTree((UIComponent)viewToRender, logger, Level.FINEST);
            }
            this.faceletViewHandler.renderView(context, viewToRender);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "printTreeAfterFacelets", viewToRender.getViewId());
                DebugUtil.printTree((UIComponent)viewToRender, logger, Level.FINEST);
            }
        }
        finally {
            scriptContext.setWriter(oldWriter);
        }
    }

    private String insertOutputStateComponent(String toParse) {
        StringBuffer buf = new StringBuffer(toParse);
        int startIndex = toParse.indexOf("<html");
        int closeIndex = toParse.indexOf(">", startIndex);
        int allowance = 0;
        buf.insert(closeIndex, "\nxmlns:phobos=\"http://java.sun.com/phobos/webapp\"");
        allowance += PHOBOS_TAGLIB_DECL_LENGTH + 1;
        while (-1 != (startIndex = toParse.indexOf("<form", closeIndex))) {
            closeIndex = toParse.indexOf(">", startIndex) + 1;
            buf.insert(closeIndex + allowance, "\n<phobos:outputState transient=\"true\"/>\n");
            allowance += PHOBOS_OUTPUT_STATE_TAG_LENGTH + 2;
        }
        return buf.toString();
    }

    public void writeState(FacesContext context) throws IOException {
        this.faceletViewHandler.writeState(context);
    }

    private void exposeJavaScriptModelObjectToJava(FacesContext context) {
        ExternalContext extContext = context.getExternalContext();
        Map requestMap = extContext.getRequestMap();
        PhobosAdapter adapter = PhobosRuntime.getCurrentAdapter();
        assert (null != adapter);
        ScriptingService scriptingService = adapter.getScriptingService();
        assert (null != scriptingService);
        requestMap.put("com.sun.phobos.webapp.ScriptingService", scriptingService);
        ScriptContext scriptContext = (ScriptContext)PhobosRuntime.getCurrentEngineBindings().get("context");
        if (!requestMap.containsKey("model")) {
            JavaScriptJavaBeanMap beanMap = new JavaScriptJavaBeanMap();
            beanMap.setScriptName("model");
            requestMap.put("model", beanMap);
        }
    }
}

