/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime;

import java.util.HashSet;
import java.util.Locale;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import jmaki.runtime.AjaxException;
import jmaki.runtime.AjaxGlobalObjects;
import jmaki.runtime.IOUtil;
import jmaki.runtime.LocalizedMessage;
import jmaki.runtime.ResourceManager;
import jmaki.runtime.UriManager;
import jmaki.runtime.UriManagerFactory;
import jmaki.runtime.WidgetResourceException;
import jmaki.runtime.config.ConfigUtil;
import jmaki.runtime.config.GlobalConfig;
import jmaki.runtime.jsf.Util;

public class AjaxContext {
    private HttpServletRequest request = null;
    private ServletContext ctx = null;
    private HashSet writtenLibs = new HashSet();
    private HashSet writtenExtensions = new HashSet();
    private HashSet writtenTypes = new HashSet();
    private HashSet writtenStyles = new HashSet();
    private boolean bootstrapScriptWritten = false;
    private String webRoot = null;
    private String applicationRoot = null;
    private String servletRoot = null;
    private String globalWebRoot = null;
    private String xhpMapping = null;
    private GlobalConfig config;
    private ResourceManager resourceManager;
    private UriManager uriManager;
    private boolean isJsf = false;
    private boolean isStrictCheckingMode = false;
    private boolean isExtensionMapped;
    private boolean isCompressedScript;
    private boolean isWriteComments;
    private String currentUri = null;
    private String workingDir = null;
    private boolean inlineStyles = false;
    private boolean useCache = true;
    private boolean useCData = false;
    private Locale clientLocale = null;
    private static final String AJAXCONTEXT = "jmaki_ajaxcontext";
    protected static final String RESOURCEBUNDLEBASENAME = "jmaki.runtime.messages";
    private static Logger logger;

    private static final AjaxContext getInstance(ServletContext ctx, HttpServletRequest req, HttpServletResponse res, Object facesContext) throws AjaxException {
        AjaxContext ajaxContext = null;
        String contextKey = AjaxContext.getContextKey(ctx);
        ajaxContext = (AjaxContext)req.getAttribute(contextKey);
        if (ajaxContext == null) {
            ajaxContext = new AjaxContext(ctx, req, res, facesContext);
            req.setAttribute(contextKey, (Object)ajaxContext);
        }
        if (!ajaxContext.useCache) {
            ajaxContext.config = new GlobalConfig(ajaxContext.resourceManager);
        }
        return ajaxContext;
    }

    public static final AjaxContext getInstance(FacesContext fctx) throws AjaxException {
        ExternalContext ectx = fctx.getExternalContext();
        return AjaxContext.getInstance((ServletContext)ectx.getContext(), (HttpServletRequest)ectx.getRequest(), (HttpServletResponse)ectx.getResponse(), fctx);
    }

    public static final AjaxContext getInstance(PageContext pctx) throws AjaxException {
        return AjaxContext.getInstance(pctx.getServletContext(), (HttpServletRequest)pctx.getRequest(), (HttpServletResponse)pctx.getResponse(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AjaxContext(ServletContext ctx, HttpServletRequest req, HttpServletResponse res, Object facesContext) throws AjaxException {
        AjaxGlobalObjects globalObjects = null;
        globalObjects = (AjaxGlobalObjects)ctx.getAttribute("jmaki_globalobjects");
        if (globalObjects == null) {
            Class clazz = AjaxContext.class;
            synchronized (clazz) {
                globalObjects = (AjaxGlobalObjects)ctx.getAttribute("jmaki_globalobjects");
                if (globalObjects == null) {
                    globalObjects = new AjaxGlobalObjects();
                    if (ConfigUtil.isInitParameterSet(ctx, "jmaki-development-mode")) {
                        boolean devMode = ConfigUtil.getBooleanInitParameter(ctx, "jmaki-development-mode");
                        globalObjects.setUseCache(!devMode);
                        globalObjects.setIsStrictCheckingMode(devMode);
                        globalObjects.setThrowExceptions(devMode);
                        globalObjects.setIsCompressedScript(!devMode);
                        globalObjects.setIsWriteComments(devMode);
                    }
                    if (ConfigUtil.isInitParameterSet(ctx, "jmaki-inlinestyles")) {
                        globalObjects.setInlineStyles(ConfigUtil.getBooleanInitParameter(ctx, "jmaki-inlinestyles"));
                    }
                    if (ConfigUtil.isInitParameterSet(ctx, "jmaki-usecache")) {
                        globalObjects.setUseCache(ConfigUtil.getBooleanInitParameter(ctx, "jmaki-usecache"));
                    }
                    if (ConfigUtil.isInitParameterSet(ctx, "jmaki-use-cdata")) {
                        globalObjects.setUseCData(ConfigUtil.getBooleanInitParameter(ctx, "jmaki-use-cdata"));
                    }
                    if (ConfigUtil.isInitParameterSet(ctx, "jmaki-strict-resource-checks")) {
                        globalObjects.setIsStrictCheckingMode(ConfigUtil.getBooleanInitParameter(ctx, "jmaki-strict-resource-checks"));
                    }
                    if (ConfigUtil.isInitParameterSet(ctx, "jmaki-throw-exceptions")) {
                        globalObjects.setThrowExceptions(ConfigUtil.getBooleanInitParameter(ctx, "jmaki-throw-exceptions"));
                    }
                    if (ConfigUtil.isInitParameterSet(ctx, "jmaki-compressscript")) {
                        globalObjects.setIsCompressedScript(ConfigUtil.getBooleanInitParameter(ctx, "jmaki-compressscript"));
                    }
                    if (ConfigUtil.isInitParameterSet(ctx, "jmaki-writecomments")) {
                        globalObjects.setIsCompressedScript(ConfigUtil.getBooleanInitParameter(ctx, "jmaki-writecomments"));
                    }
                    this.resourceManager = new ResourceManager(ctx, this.useCache);
                    globalObjects.setResourceManager(this.resourceManager);
                    if (this.useCache) {
                        globalObjects.setGlobalConfig(new GlobalConfig(this.resourceManager));
                    }
                    globalObjects.setUriManager(this.getNewUriManagerInstance(ctx, facesContext != null));
                    if (ConfigUtil.isInitParameterSet(ctx, "jmaki-xhp-mapping")) {
                        globalObjects.setXhpMapping(ctx.getInitParameter("jmaki-xhp-mapping"));
                    } else {
                        globalObjects.setXhpMapping("/xhp");
                    }
                    globalObjects.setWebRoot(ctx.getInitParameter("jmaki-webroot"));
                    if (ConfigUtil.isInitParameterSet(ctx, "jmaki-client-locale")) {
                        globalObjects.setClientLocale(new Locale(ctx.getInitParameter("jmaki-client-locale")));
                    }
                    ctx.setAttribute("jmaki_globalobjects", (Object)globalObjects);
                }
            }
        }
        if (this.isJsf = facesContext != null) {
            String facesMapping = Util.getFacesMapping((FacesContext)facesContext);
            this.isExtensionMapped = facesMapping.startsWith(".");
            this.clientLocale = globalObjects.getClientLocale();
            if (this.clientLocale == null) {
                this.clientLocale = ((FacesContext)facesContext).getViewRoot().getLocale();
            }
        } else {
            this.clientLocale = globalObjects.getClientLocale();
            if (this.clientLocale == null) {
                this.clientLocale = req.getLocale();
            }
        }
        this.isStrictCheckingMode = globalObjects.getIsStrictCheckingMode();
        this.inlineStyles = globalObjects.getInlineStyles();
        this.useCache = globalObjects.getUseCache();
        this.useCData = globalObjects.getUseCData();
        this.isCompressedScript = globalObjects.getIsCompressedScript();
        this.isWriteComments = globalObjects.getIsWriteComments();
        this.resourceManager = globalObjects.getResourceHandler();
        if (this.useCache) {
            this.config = globalObjects.getGlobalConfig();
        }
        this.uriManager = globalObjects.getUriManager();
        this.xhpMapping = globalObjects.getXhpMapping();
        this.webRoot = globalObjects.getWebRoot();
        this.request = req;
        this.ctx = ctx;
    }

    public void discardConfig() throws AjaxException {
        if (this.useCache) {
            throw new AjaxException(new LocalizedMessage("ERROR_ILLEGAL_DISCARDCONFIG"));
        }
        this.config.discard();
    }

    private UriManager getNewUriManagerInstance(ServletContext ctx, boolean isJsf) throws AjaxException {
        String uriManagerFactoryClassName = ctx.getInitParameter("jmaki-urimanagerfactory");
        if (uriManagerFactoryClassName == null) {
            uriManagerFactoryClassName = isJsf ? "jmaki.runtime.jsf.JsfUriManagerImpl" : "jmaki.runtime.jsp.JspUriManagerImpl";
        }
        try {
            Class<?> clasz = Class.forName(uriManagerFactoryClassName);
            return ((UriManagerFactory)clasz.newInstance()).getInstance(ctx);
        }
        catch (Exception e) {
            String[] parameter = new String[]{uriManagerFactoryClassName};
            throw new AjaxException(new LocalizedMessage("ERROR_FAILED_URIMANAGERFACTORY", parameter), (Throwable)e);
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public ServletContext getContext() {
        return this.ctx;
    }

    public GlobalConfig getGlobalConfig() {
        return this.config;
    }

    public ResourceManager getResourceHandler() {
        return this.resourceManager;
    }

    public UriManager getUriManager() {
        return this.uriManager;
    }

    public boolean isBootstrapScriptWritten() {
        return this.bootstrapScriptWritten;
    }

    public void setBootstrapScriptWritten(boolean arg) {
        this.bootstrapScriptWritten = arg;
    }

    public boolean isTypeWritten(String type) {
        return this.writtenTypes.contains(type);
    }

    public void setTypeWritten(String type) {
        this.writtenTypes.add(type);
    }

    public boolean isLibraryWritten(String lib) {
        return this.writtenLibs.contains(lib);
    }

    public void setLibraryWritten(String lib) {
        this.writtenLibs.add(lib);
    }

    public boolean isExtensionWritten(String extension) {
        return this.writtenExtensions.contains(extension);
    }

    public void setExtensionWritten(String extension) {
        this.writtenExtensions.add(extension);
    }

    public boolean isStyleWritten(String style) {
        return this.writtenStyles.contains(style);
    }

    public void setStyleWritten(String style) {
        this.writtenStyles.add(style);
    }

    public boolean getUseCache() {
        return this.useCache;
    }

    public boolean getInlineStyles() {
        return this.inlineStyles;
    }

    public boolean getUseCData() {
        return this.useCData;
    }

    public Locale getClientLocale() {
        return this.clientLocale;
    }

    public boolean isJsf() {
        return this.isJsf;
    }

    public boolean getIsExtensionMapped() {
        return this.isExtensionMapped;
    }

    public boolean isStrictCheckingMode() {
        return this.isStrictCheckingMode;
    }

    public boolean isCompressedScript() {
        return this.isCompressedScript;
    }

    public boolean isWriteComments() {
        return this.isWriteComments;
    }

    public int getUniqueId() {
        int counter = 0;
        Object co = this.getRequest().getSession().getAttribute("jmaki-counter");
        if (co != null) {
            try {
                counter = (Integer)co;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.getRequest().getSession().setAttribute("jmaki-counter", (Object)new Integer(++counter));
        return counter;
    }

    public String getWorkingDir() {
        if (this.workingDir == null) {
            String basePath = this.request.getRequestURI();
            int first = basePath.indexOf("/", 1);
            int last = basePath.lastIndexOf("/");
            this.workingDir = first != -1 && last != -1 ? basePath.substring(first, last) : "";
        }
        return this.workingDir;
    }

    public String getCurrentURI() {
        if (this.currentUri == null) {
            this.currentUri = this.request.getRequestURI().substring(this.request.getContextPath().length(), this.request.getRequestURI().length());
        }
        return this.currentUri;
    }

    public String getWebRoot() {
        if (this.webRoot == null) {
            StringBuffer webRootBuffer = new StringBuffer(this.getScheme() + "://").append(this.request.getServerName());
            if (this.request.getServerPort() != 80) {
                webRootBuffer.append(":").append(this.request.getServerPort());
            }
            this.webRoot = webRootBuffer.toString();
        }
        return this.webRoot;
    }

    public String getQueryString() {
        String queryString = this.request.getQueryString();
        if (queryString != null) {
            queryString = queryString.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            queryString = queryString.replaceAll("eval\\((.*)\\)", "");
            queryString = queryString.replaceAll("[\\\"\\'][\\s]*((?i)javascript):(.*)[\\\"\\']", "\"\"");
            queryString = queryString.replaceAll("((?i)script)", "");
        }
        return queryString;
    }

    public String getSourceURL() {
        String queryString = this.getQueryString();
        String requestURI = this.request.getRequestURI();
        if (requestURI == null) {
            requestURI = this.getServletRoot();
        }
        return this.getWebRoot() + requestURI + (queryString == null ? "" : "?" + queryString);
    }

    public String getApplicationRoot() {
        if (this.applicationRoot == null) {
            this.applicationRoot = this.getWebRoot() + this.request.getContextPath();
        }
        return this.applicationRoot;
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServletRoot() {
        if (this.servletRoot == null) {
            this.servletRoot = this.getApplicationRoot() + this.request.getServletPath();
        }
        return this.servletRoot;
    }

    public String getGlobalWebRoot() throws AjaxException {
        if (this.globalWebRoot == null) {
            this.globalWebRoot = this.config.isGlobalConfigWebAppResource() ? this.uriManager.buildWebAppResourceReference(this, "") : this.uriManager.buildClassPathResourceReference(this, "");
        }
        return this.globalWebRoot;
    }

    public String getXhpMapping() {
        return this.xhpMapping;
    }

    public String buildResourceReference(String resource) throws AjaxException {
        if (IOUtil.isExternalUri(resource)) {
            return resource;
        }
        if (this.resourceManager.isWebAppResource(resource)) {
            return this.uriManager.buildWebAppResourceReference(this, resource);
        }
        if (this.resourceManager.isClassPathResource(resource)) {
            return this.uriManager.buildClassPathResourceReference(this, resource);
        }
        if (this.isStrictCheckingMode) {
            String[] parameter = new String[]{resource};
            throw new WidgetResourceException(new LocalizedMessage("ERROR_LOCATE_RESOURCE", parameter));
        }
        String[] parameter = new String[]{resource};
        AjaxContext.getLogger().warning(new LocalizedMessage("WARNING_LOCATE_RESOURCE", parameter).toString());
        return resource;
    }

    public String buildResourceReference(String resource, boolean isWebAppResource) throws AjaxException {
        if (IOUtil.isExternalUri(resource)) {
            return resource;
        }
        return isWebAppResource ? this.uriManager.buildWebAppResourceReference(this, resource) : this.uriManager.buildClassPathResourceReference(this, resource);
    }

    public String buildWebAppResourceReference(String resource) throws AjaxException {
        return this.uriManager.buildWebAppResourceReference(this, resource);
    }

    public String buildClassPathResourceReference(String resource) throws AjaxException {
        return this.uriManager.buildClassPathResourceReference(this, resource);
    }

    public String buildDynamicResourceReference(String resource) throws AjaxException {
        return this.uriManager.buildDynamicResourceReference(this, resource);
    }

    public String buildExternalResourceReference(String resource) throws AjaxException {
        return this.uriManager.buildExternalResourceReference(this, resource);
    }

    public void release() throws AjaxException {
        this.request.removeAttribute(AjaxContext.getContextKey(this.ctx));
        if (!this.useCache && this.config != null) {
            this.discardConfig();
        }
        this.request = null;
        this.ctx = null;
        this.writtenLibs.clear();
        this.writtenLibs = null;
        this.writtenExtensions.clear();
        this.writtenExtensions = null;
        this.writtenTypes.clear();
        this.writtenTypes = null;
        this.writtenStyles.clear();
        this.writtenStyles = null;
        this.webRoot = null;
        this.applicationRoot = null;
        this.servletRoot = null;
        this.globalWebRoot = null;
        this.xhpMapping = null;
        this.config = null;
        this.resourceManager = null;
        this.uriManager = null;
        this.currentUri = null;
        this.workingDir = null;
        this.clientLocale = null;
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger("jmaki.runtime.Log");
        }
        return logger;
    }

    private static final String getContextKey(ServletContext ctx) {
        return "jmaki_ajaxcontext_" + ctx.hashCode();
    }
}

