/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.annotation;

import com.sun.jsftemplating.annotation.Handler;
import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerAP
implements AnnotationProcessor {
    private PrintWriter _writer = null;
    private AnnotationProcessorEnvironment _env = null;
    private Map handlers = new HashMap();

    public HandlerAP(AnnotationProcessorEnvironment env, PrintWriter writer) {
        this._writer = writer;
        this._env = env;
    }

    public void process() {
        AnnotationTypeDeclaration decl = (AnnotationTypeDeclaration)this._env.getTypeDeclaration(Handler.class.getName());
        for (Declaration dec : this._env.getDeclarationsAnnotatedWith(decl)) {
            for (AnnotationMirror mirror : dec.getAnnotationMirrors()) {
                String id = null;
                List input = null;
                List output = null;
                for (Map.Entry entry : mirror.getElementValues().entrySet()) {
                    String key = ((AnnotationTypeElementDeclaration)entry.getKey()).getSimpleName();
                    Object value = ((AnnotationValue)entry.getValue()).getValue();
                    if (key.equals("id")) {
                        id = value.toString();
                        continue;
                    }
                    if (key.equals("input")) {
                        input = (List)value;
                        continue;
                    }
                    if (!key.equals("output")) continue;
                    output = (List)value;
                }
                if (id == null) {
                    this._env.getMessager().printError(dec.getPosition(), "'id' not specified for annotation of method: '" + ((MemberDeclaration)dec).getDeclaringType().getQualifiedName() + "." + dec.getSimpleName() + "'.");
                }
                if (this.handlers.get(id) != null) {
                    this._env.getMessager().printWarning(dec.getPosition(), "Handler with 'id' of '" + id + "' is declared more than once!'");
                }
                this.handlers.put(id, id);
                this._writer.println(this.formatComment(dec.getDocComment()));
                this._writer.println(id + ".class=" + ((MemberDeclaration)dec).getDeclaringType().getQualifiedName());
                this._writer.println(id + ".method=" + dec.getSimpleName());
                if (input != null) {
                    this.writeIOProperties(id, "input", input);
                }
                if (output != null) {
                    this.writeIOProperties(id, "output", output);
                }
                if (!dec.getModifiers().contains(Modifier.PUBLIC)) {
                    this._env.getMessager().printError(dec.getPosition(), "Annotated method: '" + ((MemberDeclaration)dec).getDeclaringType().getQualifiedName() + "." + dec.getSimpleName() + "' should be declared public.");
                }
                Collection params = ((MethodDeclaration)dec).getParameters();
                String pdec = ((ParameterDeclaration)params.iterator().next()).getType().toString();
                if (params.size() == 1 && pdec.equals("com.sun.jsftemplating.layout.descriptors.handler.HandlerContext")) continue;
                this._env.getMessager().printError(dec.getPosition(), "Annotated method: '" + ((MemberDeclaration)dec).getDeclaringType().getQualifiedName() + "." + dec.getSimpleName() + "' must contain a single parameter of type 'com." + "sun.jsftemplating.layout.descriptors.handler." + "HandlerContext', instead type: '" + pdec + "' was found.");
            }
        }
    }

    private void writeIOProperties(String id, String type, List<AnnotationValue> ioList) {
        int cnt = 0;
        for (AnnotationValue ioVal : ioList) {
            for (Map.Entry prop : ((AnnotationMirror)ioVal.getValue()).getElementValues().entrySet()) {
                this._writer.println(id + "." + type + "[" + cnt + "]." + ((AnnotationTypeElementDeclaration)prop.getKey()).getSimpleName() + "=" + this.convertClassName(((AnnotationValue)prop.getValue()).getValue().toString()));
            }
            ++cnt;
        }
    }

    private String convertClassName(String str) {
        int idx = str.indexOf("[]");
        if (idx == -1) {
            return str;
        }
        int count = 0;
        while (idx != -1) {
            str = str.replaceFirst("\\[]", "");
            idx = str.indexOf("[]");
            ++count;
        }
        String brackets = "";
        for (idx = 0; idx < count; ++idx) {
            brackets = brackets + "[";
        }
        return brackets + "L" + str + ";";
    }

    private String formatComment(String javadoc) {
        if (javadoc == null) {
            return "";
        }
        int idx = javadoc.indexOf("@param");
        if (idx > -1) {
            javadoc = javadoc.substring(0, idx);
        }
        javadoc = javadoc.trim();
        StringBuffer buf = new StringBuffer("\n# ");
        int len = javadoc.length();
        block6: for (idx = 0; idx < len; ++idx) {
            char ch = javadoc.charAt(idx);
            switch (ch) {
                case '&': {
                    if (idx + 3 >= len || javadoc.charAt(idx + 2) != 't' || javadoc.charAt(idx + 3) != ';') continue block6;
                    if (javadoc.charAt(idx + 1) == 'g') {
                        buf.append('>');
                        idx += 3;
                        continue block6;
                    }
                    if (javadoc.charAt(idx + 1) != 'l') continue block6;
                    buf.append('<');
                    idx += 3;
                    continue block6;
                }
                case '<': {
                    ++idx;
                    while (idx < len && javadoc.charAt(idx) != '>') {
                        ++idx;
                    }
                    continue block6;
                }
                case '>': {
                    ++idx;
                    while (idx < len && javadoc.charAt(idx) != '<') {
                        ++idx;
                    }
                    continue block6;
                }
                case '\n': 
                case '\r': {
                    if (idx + 1 > len && (javadoc.charAt(idx + 1) == '\n' || javadoc.charAt(idx + 1) == '\r')) {
                        ++idx;
                    }
                    buf.append("\n# ");
                    continue block6;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }
}

