/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.handlers;

import com.sun.jsftemplating.el.PageSessionResolver;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.resource.ResourceBundleManager;
import com.sun.jsftemplating.util.Util;
import java.io.Serializable;
import java.util.Formatter;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeHandlers {
    public static void getAttribute(HandlerContext context) {
        String key = (String)context.getInputValue("key");
        Object value = context.getFacesContext().getExternalContext().getRequestMap().get(key);
        context.setOutputValue("value", value);
    }

    public static void setAttribute(HandlerContext context) {
        String key = (String)context.getInputValue("key");
        Object value = context.getInputValue("value");
        context.getFacesContext().getExternalContext().getRequestMap().put(key, value);
    }

    public static void dumpAttributes(HandlerContext context) {
        Map map = context.getFacesContext().getExternalContext().getRequestMap();
        context.setOutputValue("value", ScopeHandlers.formatAttributes(map));
    }

    public static void getPageSessionAttribute(HandlerContext context) {
        Map<String, Serializable> map = PageSessionResolver.getPageSession(context.getFacesContext(), (UIViewRoot)context.getInputValue("page"));
        Serializable value = null;
        if (map != null) {
            value = map.get((String)context.getInputValue("key"));
        }
        context.setOutputValue("value", value);
    }

    public static void setPageSessionAttribute(HandlerContext context) {
        UIViewRoot root = (UIViewRoot)context.getInputValue("page");
        FacesContext ctx = context.getFacesContext();
        Map<String, Serializable> map = PageSessionResolver.getPageSession(ctx, root);
        if (map == null) {
            map = PageSessionResolver.createPageSession(ctx, root);
        }
        map.put((String)context.getInputValue("key"), (Serializable)context.getInputValue("value"));
    }

    public static void dumpPageSessionAttributes(HandlerContext context) {
        Map<String, Serializable> map = PageSessionResolver.getPageSession(context.getFacesContext(), (UIViewRoot)context.getInputValue("page"));
        context.setOutputValue("value", ScopeHandlers.formatAttributes(map));
    }

    public static void getSessionAttribute(HandlerContext context) {
        String key = (String)context.getInputValue("key");
        Object value = context.getFacesContext().getExternalContext().getSessionMap().get(key);
        context.setOutputValue("value", value);
    }

    public static void setSessionAttribute(HandlerContext context) {
        String key = (String)context.getInputValue("key");
        Object value = context.getInputValue("value");
        context.getFacesContext().getExternalContext().getSessionMap().put(key, value);
    }

    public static void dumpSessionAttributes(HandlerContext context) {
        Map map = context.getFacesContext().getExternalContext().getSessionMap();
        context.setOutputValue("value", ScopeHandlers.formatAttributes(map));
    }

    public static void getApplicationAttribute(HandlerContext context) {
        String key = (String)context.getInputValue("key");
        Object value = context.getFacesContext().getExternalContext().getApplicationMap().get(key);
        context.setOutputValue("value", value);
    }

    public static void setApplicationAttribute(HandlerContext context) {
        String key = (String)context.getInputValue("key");
        Object value = context.getInputValue("value");
        context.getFacesContext().getExternalContext().getApplicationMap().put(key, value);
    }

    public static void dumpApplicationAttributes(HandlerContext context) {
        Map map = context.getFacesContext().getExternalContext().getApplicationMap();
        context.setOutputValue("value", ScopeHandlers.formatAttributes(map));
    }

    private static <T> String formatAttributes(Map<String, T> map) {
        Formatter printf = new Formatter();
        if (map == null) {
            printf.format("Map null.", new Object[0]);
        } else {
            Iterator<Map.Entry<String, T>> it = map.entrySet().iterator();
            Map.Entry<String, T> entry = null;
            while (it.hasNext()) {
                entry = it.next();
                printf.format("%-20s = %s\n", entry.getKey(), entry.getValue());
            }
        }
        return printf.toString();
    }

    public static void setResourceBundle(HandlerContext context) {
        String key = (String)context.getInputValue("key");
        String name = (String)context.getInputValue("bundle");
        Locale locale = (Locale)context.getInputValue("locale");
        if (locale == null) {
            locale = Util.getLocale(FacesContext.getCurrentInstance());
        }
        ResourceBundle bundle = ResourceBundleManager.getInstance().getBundle(name, locale);
        context.getFacesContext().getExternalContext().getRequestMap().put(key, bundle);
        context.setOutputValue("result", bundle);
    }

    public static void getCookie(HandlerContext context) {
        Map cookies = context.getFacesContext().getExternalContext().getRequestCookieMap();
        Cookie cookie = (Cookie)cookies.get(context.getInputValue("key"));
        context.setOutputValue("value", cookie == null ? "" : cookie.getValue());
    }

    public static void setCookie(HandlerContext context) {
        Object resp = context.getFacesContext().getExternalContext().getResponse();
        if (resp instanceof HttpServletResponse) {
            String path;
            Cookie cookie = new Cookie((String)context.getInputValue("key"), (String)context.getInputValue("value"));
            cookie.setMaxAge(((Integer)context.getInputValue("maxAge")).intValue());
            String domain = (String)context.getInputValue("domain");
            if (domain != null) {
                cookie.setDomain(domain);
            }
            if ((path = (String)context.getInputValue("path")) != null) {
                cookie.setPath(path);
            }
            cookie.setSecure(((Boolean)context.getInputValue("secure")).booleanValue());
            Integer version = (Integer)context.getInputValue("version");
            if (version != null) {
                cookie.setVersion(version.intValue());
            }
            ((HttpServletResponse)resp).addCookie(cookie);
        }
    }

    public static void setPreference(HandlerContext context) {
        String nodeKey = (String)context.getInputValue("root");
        String key = (String)context.getInputValue("key");
        String value = (String)context.getInputValue("value");
        Preferences prefs = Preferences.userRoot().node(nodeKey);
        prefs.put(key, value);
    }

    public static void getPreference(HandlerContext context) {
        String nodeKey = (String)context.getInputValue("root");
        String key = (String)context.getInputValue("key");
        String def = (String)context.getInputValue("default");
        Preferences prefs = Preferences.userRoot().node(nodeKey);
        String value = prefs.get(key, def);
        context.setOutputValue("value", value);
    }
}

