/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.facelets;

import com.sun.jsftemplating.layout.LayoutDefinitionException;
import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.facelets.FaceletsLayoutDefinitionReader;
import com.sun.jsftemplating.util.FileUtil;
import java.io.IOException;
import java.net.URL;
import javax.faces.context.FacesContext;

public class FaceletsLayoutDefinitionManager
extends LayoutDefinitionManager {
    private static String defaultSuffix;

    public FaceletsLayoutDefinitionManager() {
        if (defaultSuffix == null) {
            defaultSuffix = ".xhtml";
        }
    }

    public boolean accepts(String key) {
        boolean accept = false;
        URL url = FileUtil.searchForFile(key, defaultSuffix);
        if (url == null) {
            return false;
        }
        if (url.getPath().contains(".xhtml")) {
            accept = true;
        }
        return accept;
    }

    public LayoutDefinition getLayoutDefinition(String key) throws LayoutDefinitionException {
        URL url = FileUtil.searchForFile(key, defaultSuffix);
        if (url == null) {
            throw new LayoutDefinitionException("Unable to locate '" + key + "'");
        }
        LayoutDefinition ld = null;
        try {
            ld = new FaceletsLayoutDefinitionReader(key, url).read();
        }
        catch (IOException ex) {
            throw new LayoutDefinitionException("Unable to process '" + url.toString() + "'.", ex);
        }
        ld.dispatchInitPageHandlers(FacesContext.getCurrentInstance(), ld);
        return ld;
    }

    public static LayoutDefinitionManager getInstance() {
        return SingletonHolder.instance;
    }

    static class SingletonHolder {
        static FaceletsLayoutDefinitionManager instance = new FaceletsLayoutDefinitionManager();

        SingletonHolder() {
        }
    }
}

