/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.application;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.core.spi.component.ComponentProvider;
import com.sun.jersey.core.spi.component.ProviderFactory;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.core.Application;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeferredResourceConfig
extends DefaultResourceConfig {
    private static final Logger LOGGER = Logger.getLogger(DeferredResourceConfig.class.getName());
    private final Class<? extends Application> appClass;
    private final Set<Class<?>> defaultClasses;

    public DeferredResourceConfig(Class<? extends Application> appClass) {
        this(appClass, Collections.emptySet());
    }

    public DeferredResourceConfig(Class<? extends Application> appClass, Set<Class<?>> defaultClasses) {
        this.appClass = appClass;
        this.defaultClasses = defaultClasses;
    }

    public Application getApplication(ProviderFactory pf) {
        ComponentProvider cp = pf.getComponentProvider((Class)this.appClass);
        if (cp == null) {
            throw new ContainerException("");
        }
        Application app = (Application)cp.getInstance();
        if ((app.getClasses() == null || app.getClasses().isEmpty()) && (app.getSingletons() == null || app.getSingletons().isEmpty())) {
            LOGGER.info("Instantiating the Application class, named " + this.appClass.getName() + ". The following root resource and provider classes are registered: " + this.defaultClasses);
            DefaultResourceConfig drc = new DefaultResourceConfig(this.defaultClasses);
            drc.add(app);
            return drc;
        }
        LOGGER.info("Instantiating the Application class, named " + this.appClass.getName());
        return app;
    }
}

