/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.renderkit;

import com.sun.javaee.blueprints.components.ui.renderkit.BaseRenderer;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class RepeaterRenderer
extends BaseRenderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
        ResponseWriter writer = context.getResponseWriter();
        UIData data = (UIData)component;
        data.setRowIndex(-1);
        this.tableBegin(context, data, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIData data = (UIData)component;
        int processed = 0;
        int rowIndex = data.getFirst() - 1;
        int rows = data.getRows();
        while (rows <= 0 || ++processed <= rows) {
            data.setRowIndex(++rowIndex);
            if (!data.isRowAvailable()) break;
            this.rowBegin(context, data, writer);
            this.rowBody(context, data, writer);
            this.rowEnd(context, data, writer);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        ResponseWriter writer = context.getResponseWriter();
        UIData data = (UIData)component;
        data.setRowIndex(-1);
        this.tableEnd(context, data, writer);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected int getColumnCount(UIData data) {
        int n = 0;
        Iterator kids = data.getChildren().iterator();
        while (kids.hasNext()) {
            if (!(kids.next() instanceof UIColumn)) continue;
            ++n;
        }
        return n;
    }

    protected int getColumnFooterCount(UIData data) {
        int n = 0;
        for (UIComponent kid : data.getChildren()) {
            if (!(kid instanceof UIColumn) || kid.getFacet("footer") == null) continue;
            ++n;
        }
        return n;
    }

    protected int getColumnHeaderCount(UIData data) {
        int n = 0;
        for (UIComponent kid : data.getChildren()) {
            if (!(kid instanceof UIColumn) || kid.getFacet("header") == null) continue;
            ++n;
        }
        return n;
    }

    protected void rowBegin(FacesContext context, UIData data, ResponseWriter writer) throws IOException {
        writer.startElement("tr", (UIComponent)data);
        writer.writeText((Object)"\n", null);
    }

    protected void rowBody(FacesContext context, UIData data, ResponseWriter writer) throws IOException {
        for (UIComponent column : data.getChildren()) {
            if (!(column instanceof UIColumn)) continue;
            writer.startElement("td", column);
            Iterator contents = column.getChildren().iterator();
            while (contents.hasNext()) {
                this.encodeRecursive(context, (UIComponent)contents.next());
            }
            writer.endElement("td");
            writer.writeText((Object)"\n", null);
        }
    }

    protected void rowEnd(FacesContext context, UIData data, ResponseWriter writer) throws IOException {
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    protected void tableBegin(FacesContext context, UIData data, ResponseWriter writer) throws IOException {
        writer.startElement("table", (UIComponent)data);
        String styleClass = (String)data.getAttributes().get("styleClass");
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        } else {
            writer.writeAttribute("border", (Object)"0", null);
            writer.writeAttribute("cellspacing", (Object)"5", null);
        }
        writer.writeText((Object)"\n", null);
        UIComponent header = data.getFacet("header");
        int n = this.getColumnHeaderCount(data);
        if (header != null || n > 0) {
            writer.startElement("thead", header);
        }
        if (header != null) {
            writer.startElement("tr", header);
            writer.startElement("th", header);
            writer.writeAttribute("colspan", (Object)("" + this.getColumnCount(data)), null);
            writer.writeText((Object)"\n", null);
            this.encodeRecursive(context, header);
            writer.writeText((Object)"\n", null);
            writer.endElement("th");
            writer.endElement("tr");
            writer.writeText((Object)"\n", null);
        }
        if (n > 0) {
            writer.startElement("tr", (UIComponent)data);
            writer.writeText((Object)"\n", null);
            for (UIComponent column : data.getChildren()) {
                if (!(column instanceof UIColumn)) continue;
                writer.startElement("th", column);
                UIComponent facet = column.getFacet("header");
                if (facet != null) {
                    this.encodeRecursive(context, facet);
                }
                writer.endElement("th");
                writer.writeText((Object)"\n", null);
            }
            writer.endElement("tr");
            writer.writeText((Object)"\n", null);
        }
        if (header != null || n > 0) {
            writer.endElement("thead");
            writer.writeText((Object)"\n", null);
        }
        writer.startElement("tbody", (UIComponent)data);
        writer.writeText((Object)"\n", null);
    }

    protected void tableEnd(FacesContext context, UIData data, ResponseWriter writer) throws IOException {
        writer.endElement("tbody");
        writer.writeText((Object)"\n", null);
        UIComponent footer = data.getFacet("footer");
        int n = this.getColumnFooterCount(data);
        if (footer != null || n > 0) {
            writer.startElement("tfoot", footer);
        }
        if (n > 0) {
            writer.startElement("tr", (UIComponent)data);
            writer.writeText((Object)"\n", null);
            for (UIComponent column : data.getChildren()) {
                if (!(column instanceof UIColumn)) continue;
                writer.startElement("th", column);
                UIComponent facet = column.getFacet("footer");
                if (facet != null) {
                    this.encodeRecursive(context, facet);
                }
                writer.endElement("th");
                writer.writeText((Object)"\n", null);
            }
            writer.endElement("tr");
            writer.writeText((Object)"\n", null);
        }
        if (footer != null) {
            writer.startElement("tr", footer);
            writer.startElement("th", footer);
            writer.writeAttribute("colspan", (Object)("" + this.getColumnCount(data)), null);
            writer.writeText((Object)"\n", null);
            this.encodeRecursive(context, footer);
            writer.writeText((Object)"\n", null);
            writer.endElement("th");
            writer.endElement("tr");
            writer.writeText((Object)"\n", null);
        }
        if (footer != null || n > 0) {
            writer.endElement("tfoot");
            writer.writeText((Object)"\n", null);
        }
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
    }
}

