/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.AbstractThreadPool;
import com.sun.grizzly.util.LinkedTransferQueue;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedThreadPool
extends AbstractThreadPool {
    protected final ConcurrentHashMap<AbstractThreadPool.Worker, Boolean> workers = new ConcurrentHashMap();
    protected final AtomicInteger aliveworkerCount = new AtomicInteger();
    protected final AtomicInteger approximateRunningWorkerCount = new AtomicInteger();
    protected final BlockingQueue<Runnable> workQueue;
    protected final Object statelock = new Object();
    protected volatile boolean running = true;

    public FixedThreadPool() {
        this(8);
    }

    public FixedThreadPool(int size) {
        this(size, "GrizzlyWorker");
    }

    public FixedThreadPool(int size, final String name) {
        this(size, new ThreadFactory(){
            private final AtomicInteger c = new AtomicInteger();

            public Thread newThread(Runnable r) {
                WorkerThreadImpl t = new WorkerThreadImpl(null, name + this.c.incrementAndGet(), r, 0);
                t.setDaemon(true);
                return t;
            }
        });
        this.name = name;
    }

    public FixedThreadPool(int size, ThreadFactory threadfactory) {
        this(size, new LinkedTransferQueue<Runnable>(), threadfactory);
    }

    public FixedThreadPool(int fixedsize, BlockingQueue<Runnable> workQueue, ThreadFactory threadfactory) {
        if (threadfactory == null) {
            throw new IllegalArgumentException("threadfactory == null");
        }
        if (workQueue == null) {
            throw new IllegalArgumentException("workQueue == null");
        }
        if (fixedsize < 1) {
            throw new IllegalArgumentException("fixedsize < 1");
        }
        this.threadFactory = threadfactory;
        this.workQueue = workQueue;
        this.maxPoolSize = fixedsize;
        while (fixedsize-- > 0) {
            this.aliveworkerCount.incrementAndGet();
            this.startWorker(new BasicWorker());
        }
    }

    protected FixedThreadPool(BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        if (workQueue == null) {
            throw new IllegalArgumentException("workQueue == null");
        }
        this.workQueue = workQueue;
        this.threadFactory = threadFactory;
    }

    protected void startWorker(BasicWorker wt) {
        wt.t = this.threadFactory.newThread(wt);
        this.workers.put(wt, Boolean.TRUE);
        wt.t.start();
    }

    @Override
    public void execute(Runnable command) {
        if (this.running) {
            if (this.workQueue.offer(command)) {
                this.onTaskQueued(command);
            } else {
                this.onTaskQueueOverflow();
                throw new RejectedExecutionException("The thread pool's task queue is full");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        Object object = this.statelock;
        synchronized (object) {
            ArrayList<Runnable> drained = new ArrayList<Runnable>();
            if (this.running) {
                this.running = false;
                this.workQueue.drainTo(drained);
                for (Runnable task : drained) {
                    this.onTaskDequeued(task);
                }
                this.poisonAll();
                for (AbstractThreadPool.Worker w : this.workers.keySet()) {
                    w.t.interrupt();
                }
            }
            return drained;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.statelock;
        synchronized (object) {
            if (this.running) {
                this.running = false;
                this.poisonAll();
            }
        }
    }

    private void poisonAll() {
        int size = Math.max(this.maxPoolSize, this.aliveworkerCount.get()) * 4 / 3;
        while (size-- > 0) {
            this.workQueue.offer(poison);
        }
    }

    @Override
    public boolean isShutdown() {
        return !this.running;
    }

    @Override
    public boolean isTerminated() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getActiveCount() {
        return 0;
    }

    @Override
    public int getTaskCount() {
        return 0;
    }

    @Override
    public long getCompletedTaskCount() {
        return 0L;
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
    }

    @Override
    public int getLargestPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public int getPoolSize() {
        return this.maxPoolSize;
    }

    public BlockingQueue<Runnable> getQueue() {
        return this.workQueue;
    }

    @Override
    public int getQueueSize() {
        return this.workQueue.size();
    }

    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
    }

    @Override
    public int getMaxQueuedTasksCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setMaxQueuedTasksCount(int maxTasksCount) {
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.approximateRunningWorkerCount.incrementAndGet();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this.approximateRunningWorkerCount.decrementAndGet();
        super.afterExecute(r, t);
    }

    @Override
    protected void onWorkerExit(AbstractThreadPool.Worker worker) {
        this.aliveworkerCount.decrementAndGet();
        this.workers.remove(worker);
        super.onWorkerExit(worker);
    }

    @Override
    protected String nextThreadId() {
        throw new UnsupportedOperationException();
    }

    protected class BasicWorker
    extends AbstractThreadPool.Worker {
        protected BasicWorker() {
        }

        protected Runnable getTask() throws InterruptedException {
            return FixedThreadPool.this.workQueue.take();
        }
    }
}

