/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.transport.ListenerThreadImpl;
import com.sun.corba.ee.impl.transport.ReaderThreadImpl;
import com.sun.corba.ee.pept.transport.Acceptor;
import com.sun.corba.ee.pept.transport.Connection;
import com.sun.corba.ee.pept.transport.EventHandler;
import com.sun.corba.ee.pept.transport.ListenerThread;
import com.sun.corba.ee.pept.transport.ReaderThread;
import com.sun.corba.ee.pept.transport.Selector;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.threadpool.NoSuchThreadPoolException;
import com.sun.corba.ee.spi.orbutil.threadpool.NoSuchWorkQueueException;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class SelectorImpl
extends Thread
implements Selector {
    private ORB orb;
    private java.nio.channels.Selector selector;
    private long timeout;
    private List deferredRegistrations;
    private List interestOpsList;
    private HashMap listenerThreads;
    private HashMap readerThreads;
    private boolean selectorStarted;
    private boolean closed;
    private ORBUtilSystemException wrapper;

    public SelectorImpl(ORB orb) {
        this.orb = orb;
        this.selector = null;
        this.selectorStarted = false;
        this.timeout = 60000L;
        this.deferredRegistrations = new ArrayList();
        this.interestOpsList = new ArrayList();
        this.listenerThreads = new HashMap();
        this.readerThreads = new HashMap();
        this.closed = false;
        this.wrapper = ORBUtilSystemException.get(orb, "rpc.transport");
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInterestOps(EventHandler eventHandler) {
        SelectionKey selectionKey;
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerInterestOps:-> " + eventHandler);
        }
        if ((selectionKey = eventHandler.getSelectionKey()).isValid()) {
            int ehOps = eventHandler.getInterestOps();
            SelectionKeyAndOp keyAndOp = new SelectionKeyAndOp(selectionKey, ehOps);
            List list = this.interestOpsList;
            synchronized (list) {
                this.interestOpsList.add(keyAndOp);
            }
            this.selector.wakeup();
        } else {
            this.wrapper.selectionKeyInvalid(eventHandler.toString());
            if (this.orb.transportDebugFlag) {
                this.dprint(".registerInterestOps: EventHandler SelectionKey not valid " + eventHandler);
            }
        }
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerInterestOps:<- ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForEvent(EventHandler eventHandler) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerForEvent: " + eventHandler);
        }
        if (this.isClosed()) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".registerForEvent: closed: " + eventHandler);
            }
            return;
        }
        if (eventHandler.shouldUseSelectThreadToWait()) {
            List list = this.deferredRegistrations;
            synchronized (list) {
                this.deferredRegistrations.add(eventHandler);
            }
            if (!this.selectorStarted) {
                this.startSelector();
            }
            this.selector.wakeup();
            return;
        }
        switch (eventHandler.getInterestOps()) {
            case 16: {
                this.createListenerThread(eventHandler);
                break;
            }
            case 1: {
                this.createReaderThread(eventHandler);
                break;
            }
            default: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".registerForEvent: default: " + eventHandler);
                }
                throw new RuntimeException("SelectorImpl.registerForEvent: unknown interest ops");
            }
        }
    }

    public void unregisterForEvent(EventHandler eventHandler) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".unregisterForEvent: " + eventHandler);
        }
        if (this.isClosed()) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".unregisterForEvent: closed: " + eventHandler);
            }
            return;
        }
        if (eventHandler.shouldUseSelectThreadToWait()) {
            SelectionKey selectionKey = eventHandler.getSelectionKey();
            selectionKey.cancel();
            this.selector.wakeup();
            return;
        }
        switch (eventHandler.getInterestOps()) {
            case 16: {
                this.destroyListenerThread(eventHandler);
                break;
            }
            case 1: {
                this.destroyReaderThread(eventHandler);
                break;
            }
            default: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".unregisterForEvent: default: " + eventHandler);
                }
                throw new RuntimeException("SelectorImpl.uregisterForEvent: unknown interest ops");
            }
        }
    }

    public void close() {
        block8: {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close");
            }
            if (this.isClosed()) {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".close: already closed");
                }
                return;
            }
            this.setClosed(true);
            for (ListenerThread listenerThread : this.listenerThreads.values()) {
                listenerThread.close();
            }
            for (ReaderThread readerThread : this.readerThreads.values()) {
                readerThread.close();
            }
            try {
                if (this.selector != null) {
                    this.selector.wakeup();
                }
            }
            catch (Throwable t) {
                if (!this.orb.transportDebugFlag) break block8;
                this.dprint(".close: selector.close: " + t);
            }
        }
    }

    public void run() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SelectorImpl.this.setName("SelectorThread");
                return null;
            }
        });
        while (!this.closed) {
            try {
                int n;
                block12: {
                    n = 0;
                    if (this.timeout == 0L && this.orb.transportDebugFlag) {
                        this.dprint(".run: Beginning of selection cycle");
                    }
                    this.handleDeferredRegistrations();
                    this.enableInterestOps();
                    try {
                        n = this.selector.select(this.timeout);
                    }
                    catch (IOException e) {
                        if (!this.orb.transportDebugFlag) break block12;
                        this.dprint(".run: selector.select: " + e);
                    }
                }
                if (this.closed) {
                    this.selector.close();
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".run: closed - .run return");
                    }
                    return;
                }
                Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                if (this.orb.transportDebugFlag && iterator.hasNext()) {
                    this.dprint(".run: n = " + n);
                }
                while (iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    EventHandler eventHandler = (EventHandler)selectionKey.attachment();
                    try {
                        eventHandler.handleEvent();
                    }
                    catch (Throwable t) {
                        if (!this.orb.transportDebugFlag) continue;
                        this.dprint(".run: eventHandler.handleEvent", t);
                    }
                }
                if (this.timeout != 0L || !this.orb.transportDebugFlag) continue;
                this.dprint(".run: End of selection cycle");
            }
            catch (Throwable t) {
                if (!this.orb.transportDebugFlag) continue;
                this.dprint(".run: ignoring", t);
            }
        }
    }

    private synchronized boolean isClosed() {
        return this.closed;
    }

    private synchronized void setClosed(boolean closed) {
        this.closed = closed;
    }

    private void startSelector() {
        try {
            this.selector = java.nio.channels.Selector.open();
        }
        catch (IOException e) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".startSelector: Selector.open: IOException: " + e);
            }
            RuntimeException rte = new RuntimeException(".startSelector: Selector.open exception");
            rte.initCause(e);
            throw rte;
        }
        this.setDaemon(true);
        this.start();
        this.selectorStarted = true;
        if (this.orb.transportDebugFlag) {
            this.dprint(".startSelector: selector.start completed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeferredRegistrations() {
        List list = this.deferredRegistrations;
        synchronized (list) {
            int deferredListSize = this.deferredRegistrations.size();
            for (int i = 0; i < deferredListSize; ++i) {
                SelectionKey selectionKey;
                EventHandler eventHandler;
                block7: {
                    eventHandler = (EventHandler)this.deferredRegistrations.get(i);
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".handleDeferredRegistrations: " + eventHandler);
                    }
                    SelectableChannel channel = eventHandler.getChannel();
                    selectionKey = null;
                    try {
                        selectionKey = channel.register(this.selector, eventHandler.getInterestOps(), eventHandler);
                    }
                    catch (ClosedChannelException e) {
                        if (!this.orb.transportDebugFlag) break block7;
                        this.dprint(".handleDeferredRegistrations: " + e);
                    }
                }
                eventHandler.setSelectionKey(selectionKey);
            }
            this.deferredRegistrations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableInterestOps() {
        List list = this.interestOpsList;
        synchronized (list) {
            int listSize = this.interestOpsList.size();
            if (listSize > 0) {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".enableInterestOps:->");
                }
                SelectionKey selectionKey = null;
                SelectionKeyAndOp keyAndOp = null;
                int selectionKeyOps = 0;
                for (int i = 0; i < listSize; ++i) {
                    keyAndOp = (SelectionKeyAndOp)this.interestOpsList.get(i);
                    selectionKey = keyAndOp.selectionKey;
                    if (!selectionKey.isValid()) continue;
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".enableInterestOps: " + keyAndOp);
                    }
                    int keyOp = keyAndOp.keyOp;
                    selectionKeyOps = selectionKey.interestOps();
                    selectionKey.interestOps(selectionKeyOps | keyOp);
                }
                this.interestOpsList.clear();
                if (this.orb.transportDebugFlag) {
                    this.dprint(".enableInterestOps:<-");
                }
            }
        }
    }

    private void createListenerThread(EventHandler eventHandler) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".createListenerThread: " + eventHandler);
        }
        Acceptor acceptor = eventHandler.getAcceptor();
        ListenerThreadImpl listenerThread = new ListenerThreadImpl(this.orb, acceptor, this);
        this.listenerThreads.put(eventHandler, listenerThread);
        Exception throwable = null;
        try {
            this.orb.getThreadPoolManager().getThreadPool(0).getWorkQueue(0).addWork(listenerThread);
        }
        catch (NoSuchThreadPoolException e) {
            throwable = e;
        }
        catch (NoSuchWorkQueueException e) {
            throwable = e;
        }
        if (throwable != null) {
            RuntimeException rte = new RuntimeException(throwable.toString());
            rte.initCause(throwable);
            throw rte;
        }
    }

    private void destroyListenerThread(EventHandler eventHandler) {
        ListenerThread listenerThread;
        if (this.orb.transportDebugFlag) {
            this.dprint(".destroyListenerThread: " + eventHandler);
        }
        if ((listenerThread = (ListenerThread)this.listenerThreads.get(eventHandler)) == null) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".destroyListenerThread: cannot find ListenerThread - ignoring.");
            }
            return;
        }
        this.listenerThreads.remove(eventHandler);
        listenerThread.close();
    }

    private void createReaderThread(EventHandler eventHandler) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".createReaderThread: " + eventHandler);
        }
        Connection connection = eventHandler.getConnection();
        ReaderThreadImpl readerThread = new ReaderThreadImpl(this.orb, connection, this);
        this.readerThreads.put(eventHandler, readerThread);
        Exception throwable = null;
        try {
            this.orb.getThreadPoolManager().getThreadPool(0).getWorkQueue(0).addWork(readerThread);
        }
        catch (NoSuchThreadPoolException e) {
            throwable = e;
        }
        catch (NoSuchWorkQueueException e) {
            throwable = e;
        }
        if (throwable != null) {
            RuntimeException rte = new RuntimeException(throwable.toString());
            rte.initCause(throwable);
            throw rte;
        }
    }

    private void destroyReaderThread(EventHandler eventHandler) {
        ReaderThread readerThread;
        if (this.orb.transportDebugFlag) {
            this.dprint(".destroyReaderThread: " + eventHandler);
        }
        if ((readerThread = (ReaderThread)this.readerThreads.get(eventHandler)) == null) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".destroyReaderThread: cannot find ReaderThread - ignoring.");
            }
            return;
        }
        this.readerThreads.remove(eventHandler);
        readerThread.close();
    }

    private void dprint(String msg) {
        ORBUtility.dprint("SelectorImpl", msg);
    }

    protected void dprint(String msg, Throwable t) {
        this.dprint(msg);
        t.printStackTrace(System.out);
    }

    private class SelectionKeyAndOp {
        public int keyOp;
        public SelectionKey selectionKey;

        public SelectionKeyAndOp(SelectionKey selectionKey, int keyOp) {
            this.selectionKey = selectionKey;
            this.keyOp = keyOp;
        }
    }
}

