/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.presentation.rmi;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.graph.Graph;
import com.sun.corba.ee.impl.orbutil.graph.GraphImpl;
import com.sun.corba.ee.impl.orbutil.graph.Node;
import com.sun.corba.ee.impl.presentation.rmi.DynamicMethodMarshallerImpl;
import com.sun.corba.ee.impl.presentation.rmi.IDLNameTranslatorImpl;
import com.sun.corba.ee.impl.presentation.rmi.InvocationHandlerFactoryImpl;
import com.sun.corba.ee.spi.orbutil.proxy.InvocationHandlerFactory;
import com.sun.corba.ee.spi.presentation.rmi.DynamicMethodMarshaller;
import com.sun.corba.ee.spi.presentation.rmi.IDLNameTranslator;
import com.sun.corba.ee.spi.presentation.rmi.PresentationManager;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.rmi.CORBA.Tie;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public final class PresentationManagerImpl
implements PresentationManager {
    private Map classToClassData;
    private Map methodToDMM;
    private PresentationManager.StubFactoryFactory staticStubFactoryFactory;
    private PresentationManager.StubFactoryFactory dynamicStubFactoryFactory;
    private ORBUtilSystemException wrapper = null;
    private boolean useDynamicStubs;

    public PresentationManagerImpl(boolean useDynamicStubs) {
        this.useDynamicStubs = useDynamicStubs;
        this.wrapper = ORBUtilSystemException.get("rpc.presentation");
        this.classToClassData = new WeakHashMap();
        this.methodToDMM = new WeakHashMap();
    }

    public synchronized DynamicMethodMarshaller getDynamicMethodMarshaller(Method method) {
        if (method == null) {
            return null;
        }
        DynamicMethodMarshaller result = (DynamicMethodMarshaller)this.methodToDMM.get(method);
        if (result == null) {
            result = new DynamicMethodMarshallerImpl(method);
            this.methodToDMM.put(method, result);
        }
        return result;
    }

    public synchronized PresentationManager.ClassData getClassData(Class cls) {
        PresentationManager.ClassData result = (PresentationManager.ClassData)this.classToClassData.get(cls);
        if (result == null) {
            result = new ClassDataImpl(cls);
            this.classToClassData.put(cls, result);
        }
        return result;
    }

    public PresentationManager.StubFactoryFactory getStubFactoryFactory(boolean isDynamic) {
        if (isDynamic) {
            return this.dynamicStubFactoryFactory;
        }
        return this.staticStubFactoryFactory;
    }

    public void setStubFactoryFactory(boolean isDynamic, PresentationManager.StubFactoryFactory sff) {
        if (isDynamic) {
            this.dynamicStubFactoryFactory = sff;
        } else {
            this.staticStubFactoryFactory = sff;
        }
    }

    public Tie getTie() {
        return this.dynamicStubFactoryFactory.getTie(null);
    }

    public String getRepositoryId(Remote impl) {
        Tie tie = this.getTie();
        tie.setTarget(impl);
        return ((Servant)Servant.class.cast(tie))._all_interfaces((POA)null, (byte[])null)[0];
    }

    public boolean useDynamicStubs() {
        return this.useDynamicStubs;
    }

    public void flushClass(final Class cls) {
        this.classToClassData.remove(cls);
        Method[] methods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cls.getMethods();
            }
        });
        for (int ctr = 0; ctr < methods.length; ++ctr) {
            this.methodToDMM.remove(methods[ctr]);
        }
    }

    private Set getRootSet(Class target, NodeImpl root, Graph gr) {
        Set rootSet = null;
        if (target.isInterface()) {
            gr.add(root);
            rootSet = gr.getRoots();
        } else {
            HashSet<NodeImpl> initialRootSet = new HashSet<NodeImpl>();
            for (Class superclass = target; superclass != null && !superclass.equals(Object.class); superclass = superclass.getSuperclass()) {
                NodeImpl node = new NodeImpl(superclass);
                gr.add(node);
                initialRootSet.add(node);
            }
            gr.getRoots();
            gr.removeAll(initialRootSet);
            rootSet = gr.getRoots();
        }
        return rootSet;
    }

    private Class[] getInterfaces(Set roots) {
        Class[] classes = new Class[roots.size()];
        Iterator iter = roots.iterator();
        int ctr = 0;
        while (iter.hasNext()) {
            NodeImpl node = (NodeImpl)iter.next();
            classes[ctr++] = node.getInterface();
        }
        return classes;
    }

    private String[] makeTypeIds(NodeImpl root, Graph gr, Set rootSet) {
        HashSet nonRootSet = new HashSet(gr);
        nonRootSet.removeAll(rootSet);
        if (rootSet.size() == 0) {
            return new String[]{""};
        }
        ArrayList<String> result = new ArrayList<String>();
        if (rootSet.size() > 1) {
            result.add(root.getTypeId());
        }
        this.addNodes(result, rootSet);
        this.addNodes(result, nonRootSet);
        return result.toArray(new String[result.size()]);
    }

    private void addNodes(List resultList, Set nodeSet) {
        for (NodeImpl node : nodeSet) {
            String typeId = node.getTypeId();
            resultList.add(typeId);
        }
    }

    private static class NodeImpl
    implements Node {
        private Class interf;

        public Class getInterface() {
            return this.interf;
        }

        public NodeImpl(Class interf) {
            this.interf = interf;
        }

        public String getTypeId() {
            return "RMI:" + this.interf.getName() + ":0000000000000000";
        }

        public Set getChildren() {
            HashSet<NodeImpl> result = new HashSet<NodeImpl>();
            Class<?>[] interfaces = this.interf.getInterfaces();
            for (int ctr = 0; ctr < interfaces.length; ++ctr) {
                Class<?> cls = interfaces[ctr];
                if (!Remote.class.isAssignableFrom(cls) || Remote.class.equals(cls)) continue;
                result.add(new NodeImpl(cls));
            }
            return result;
        }

        public String toString() {
            return "NodeImpl[" + this.interf + "]";
        }

        public int hashCode() {
            return this.interf.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof NodeImpl)) {
                return false;
            }
            NodeImpl other = (NodeImpl)obj;
            return other.interf.equals(this.interf);
        }
    }

    private class ClassDataImpl
    implements PresentationManager.ClassData {
        private Class cls;
        private IDLNameTranslator nameTranslator;
        private String[] typeIds;
        private PresentationManager.StubFactory sfactory;
        private InvocationHandlerFactory ihfactory;
        private Map dictionary;

        public ClassDataImpl(Class cls) {
            this.cls = cls;
            GraphImpl gr = new GraphImpl();
            NodeImpl root = new NodeImpl(cls);
            Set rootSet = PresentationManagerImpl.this.getRootSet(cls, root, gr);
            Class[] interfaces = PresentationManagerImpl.this.getInterfaces(rootSet);
            this.nameTranslator = IDLNameTranslatorImpl.get(interfaces);
            this.typeIds = PresentationManagerImpl.this.makeTypeIds(root, gr, rootSet);
            this.ihfactory = new InvocationHandlerFactoryImpl(PresentationManagerImpl.this, this);
            this.dictionary = new HashMap();
        }

        public Class getMyClass() {
            return this.cls;
        }

        public IDLNameTranslator getIDLNameTranslator() {
            return this.nameTranslator;
        }

        public String[] getTypeIds() {
            return this.typeIds;
        }

        public InvocationHandlerFactory getInvocationHandlerFactory() {
            return this.ihfactory;
        }

        public Map getDictionary() {
            return this.dictionary;
        }
    }
}

