/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.threadpool;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.threadpool.WorkQueueImpl;
import com.sun.corba.ee.spi.monitoring.LongMonitoredAttributeBase;
import com.sun.corba.ee.spi.monitoring.MonitoredObject;
import com.sun.corba.ee.spi.monitoring.MonitoringFactories;
import com.sun.corba.ee.spi.orbutil.threadpool.NoSuchWorkQueueException;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import com.sun.corba.ee.spi.orbutil.threadpool.WorkQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadPoolImpl
implements ThreadPool {
    private static AtomicInteger threadCounter = new AtomicInteger(0);
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.get("rpc.transport");
    private WorkQueue workQueue;
    private AtomicInteger availableWorkerThreads = new AtomicInteger(0);
    private AtomicInteger currentThreadCount = new AtomicInteger(0);
    private final int minWorkerThreads;
    private final int maxWorkerThreads;
    private final long inactivityTimeout;
    private AtomicLong processedCount = new AtomicLong(1L);
    private AtomicLong totalTimeTaken = new AtomicLong(0L);
    private String name;
    private MonitoredObject threadpoolMonitoredObject;
    private final ThreadGroup threadGroup;

    public ThreadPoolImpl(ThreadGroup tg, String threadpoolName) {
        this.inactivityTimeout = 120000L;
        this.minWorkerThreads = 0;
        this.maxWorkerThreads = Integer.MAX_VALUE;
        this.workQueue = new WorkQueueImpl(this);
        this.threadGroup = tg;
        this.name = threadpoolName;
        this.initializeMonitoring();
    }

    public ThreadPoolImpl(String threadpoolName) {
        this(Thread.currentThread().getThreadGroup(), threadpoolName);
    }

    public ThreadPoolImpl(int minSize, int maxSize, long timeout, String threadpoolName) {
        this.inactivityTimeout = timeout;
        this.minWorkerThreads = minSize;
        this.maxWorkerThreads = maxSize;
        this.workQueue = new WorkQueueImpl(this);
        this.threadGroup = Thread.currentThread().getThreadGroup();
        this.name = threadpoolName;
        for (int i = 0; i < this.minWorkerThreads; ++i) {
            this.createWorkerThread();
        }
        this.initializeMonitoring();
    }

    private void initializeMonitoring() {
        MonitoredObject root = MonitoringFactories.getMonitoringManagerFactory().createMonitoringManager("orb", null).getRootMonitoredObject();
        MonitoredObject threadPoolMonitoringObjectRoot = root.getChild("threadpool");
        if (threadPoolMonitoringObjectRoot == null) {
            threadPoolMonitoringObjectRoot = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject("threadpool", "Monitoring for all ThreadPool instances");
            root.addChild(threadPoolMonitoringObjectRoot);
        }
        this.threadpoolMonitoredObject = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject(this.name, "Monitoring for a ThreadPool");
        threadPoolMonitoringObjectRoot.addChild(this.threadpoolMonitoredObject);
        LongMonitoredAttributeBase b1 = new LongMonitoredAttributeBase("currentNumberOfThreads", "Current number of total threads in the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.currentNumberOfThreads());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b1);
        LongMonitoredAttributeBase b2 = new LongMonitoredAttributeBase("numberOfAvailableThreads", "Current number of total threads in the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.numberOfAvailableThreads());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b2);
        LongMonitoredAttributeBase b3 = new LongMonitoredAttributeBase("numberOfBusyThreads", "Number of busy threads in the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.numberOfBusyThreads());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b3);
        LongMonitoredAttributeBase b4 = new LongMonitoredAttributeBase("averageWorkCompletionTime", "Average elapsed time taken to complete a work item by the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.averageWorkCompletionTime());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b4);
        LongMonitoredAttributeBase b5 = new LongMonitoredAttributeBase("currentProcessedCount", "Number of Work items processed by the ThreadPool"){

            public Object getValue() {
                return new Long(ThreadPoolImpl.this.currentProcessedCount());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b5);
        this.threadpoolMonitoredObject.addChild(((WorkQueueImpl)this.workQueue).getMonitoredObject());
    }

    MonitoredObject getMonitoredObject() {
        return this.threadpoolMonitoredObject;
    }

    public WorkQueue getAnyWorkQueue() {
        return this.workQueue;
    }

    public WorkQueue getWorkQueue(int queueId) throws NoSuchWorkQueueException {
        if (queueId != 0) {
            throw new NoSuchWorkQueueException();
        }
        return this.workQueue;
    }

    void notifyForAvailableWork(WorkQueue aWorkQueue) {
        if (this.availableWorkerThreads.get() == 0) {
            this.createWorkerThread();
        } else {
            aWorkQueue.notify();
        }
    }

    void createWorkerThread() {
        final String name = this.getName();
        if (this.currentThreadCount.incrementAndGet() > this.maxWorkerThreads) {
            this.currentThreadCount.decrementAndGet();
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    WorkerThread thread = new WorkerThread(ThreadPoolImpl.this.threadGroup, name);
                    thread.setDaemon(true);
                    wrapper.workerThreadCreated(thread, thread.getContextClassLoader());
                    thread.start();
                    return null;
                }
            });
        }
        catch (Throwable t) {
            wrapper.workerThreadCreationFailure(t);
        }
    }

    public int minimumNumberOfThreads() {
        return this.minWorkerThreads;
    }

    public int maximumNumberOfThreads() {
        return this.maxWorkerThreads;
    }

    public long idleTimeoutForThreads() {
        return this.inactivityTimeout;
    }

    public int currentNumberOfThreads() {
        return this.currentThreadCount.get();
    }

    public int numberOfAvailableThreads() {
        return this.availableWorkerThreads.get();
    }

    public int numberOfBusyThreads() {
        return this.currentNumberOfThreads() - this.numberOfAvailableThreads();
    }

    public long averageWorkCompletionTime() {
        return this.totalTimeTaken.get() / this.processedCount.get();
    }

    public long currentProcessedCount() {
        return this.processedCount.get();
    }

    public String getName() {
        return this.name;
    }

    public int numberOfWorkQueues() {
        return 1;
    }

    private static int getUniqueThreadId() {
        return threadCounter.incrementAndGet();
    }

    private class WorkerThread
    extends Thread {
        private static final String THREAD_POOLNAME_PREFIX_STR = "p: ";
        private static final String WORKER_THREAD_NAME_PREFIX_STR = "; w: ";
        private static final String IDLE_STR = "Idle";
        private ClassLoader workerThreadClassLoader;
        private Work currentWork;
        private int threadId;
        private String threadPoolName;
        private StringBuffer workerThreadName;

        private void setClassLoader() {
            ClassLoader oldClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    Thread thr = Thread.currentThread();
                    ClassLoader result = thr.getContextClassLoader();
                    thr.setContextClassLoader(WorkerThread.this.workerThreadClassLoader);
                    return result;
                }
            });
        }

        WorkerThread(ThreadGroup tg, String threadPoolName) {
            super(tg, THREAD_POOLNAME_PREFIX_STR + threadPoolName + WORKER_THREAD_NAME_PREFIX_STR + IDLE_STR);
            this.threadId = 0;
            this.workerThreadName = new StringBuffer();
            this.threadId = ThreadPoolImpl.getUniqueThreadId();
            this.threadPoolName = threadPoolName;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    WorkerThread.this.workerThreadClassLoader = Thread.currentThread().getContextClassLoader();
                    return null;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ThreadPoolImpl.this.availableWorkerThreads.incrementAndGet();
                        try {
                            this.currentWork = ((WorkQueueImpl)ThreadPoolImpl.this.workQueue).requestWork(ThreadPoolImpl.this.inactivityTimeout);
                        }
                        catch (Throwable t) {
                            wrapper.workerThreadThrowableFromRequestWork(this, t, ThreadPoolImpl.this.workQueue.getName());
                            int tmpThreadCount = ThreadPoolImpl.this.currentThreadCount.get();
                            if (tmpThreadCount <= ThreadPoolImpl.this.minWorkerThreads) continue;
                            wrapper.workerThreadNotNeeded(this, tmpThreadCount, ThreadPoolImpl.this.minWorkerThreads);
                            ThreadPoolImpl.this.currentThreadCount.decrementAndGet();
                            return;
                        }
                        finally {
                            ThreadPoolImpl.this.availableWorkerThreads.decrementAndGet();
                            continue;
                        }
                        this.setWorkerThreadName(this.threadPoolName, Integer.toString(this.threadId));
                        long start = System.currentTimeMillis();
                        try {
                            this.currentWork.doWork();
                        }
                        catch (Throwable t) {
                            wrapper.workerThreadDoWorkThrowable(this, t);
                        }
                        long elapsedTime = System.currentTimeMillis() - start;
                        ThreadPoolImpl.this.totalTimeTaken.addAndGet(elapsedTime);
                        ThreadPoolImpl.this.processedCount.incrementAndGet();
                        this.currentWork = null;
                        ClassLoader currentClassLoader = null;
                        try {
                            currentClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                                @Override
                                public ClassLoader run() {
                                    return WorkerThread.this.getContextClassLoader();
                                }
                            });
                        }
                        catch (SecurityException se) {
                            throw wrapper.workerThreadGetContextClassloaderFailed(this, se);
                        }
                        if (this.workerThreadClassLoader != currentClassLoader) {
                            wrapper.workerThreadForgotClassloaderReset(this, currentClassLoader, this.workerThreadClassLoader);
                            try {
                                this.setClassLoader();
                                wrapper.workerThreadClassloaderReset(this, currentClassLoader, this.workerThreadClassLoader);
                            }
                            catch (SecurityException se) {
                                wrapper.workerThreadResetContextClassloaderFailed(this, se);
                            }
                        }
                        this.setWorkerThreadName(this.threadPoolName, IDLE_STR);
                    }
                }
                catch (Throwable e) {
                    wrapper.workerThreadCaughtUnexpectedThrowable(this, e);
                    continue;
                }
                break;
            }
        }

        private String composeWorkerThreadName(String poolName, String workerName) {
            this.workerThreadName.setLength(0);
            this.workerThreadName.append(THREAD_POOLNAME_PREFIX_STR).append(poolName);
            this.workerThreadName.append(WORKER_THREAD_NAME_PREFIX_STR).append(workerName);
            return this.workerThreadName.toString();
        }

        private void setWorkerThreadName(final String poolName, final String workerName) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        WorkerThread.this.setName(WorkerThread.this.composeWorkerThreadName(poolName, workerName));
                        return null;
                    }
                });
            }
            catch (SecurityException se) {
                wrapper.workerThreadSetNameFailure(this, workerName, se);
            }
        }
    }
}

