/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.logging;

import com.sun.corba.ee.impl.logging.ActivationSystemException;
import com.sun.corba.ee.impl.logging.IORSystemException;
import com.sun.corba.ee.impl.logging.InterceptorsSystemException;
import com.sun.corba.ee.impl.logging.NamingSystemException;
import com.sun.corba.ee.impl.logging.OMGSystemException;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.logging.POASystemException;
import com.sun.corba.ee.impl.logging.UtilSystemException;
import com.sun.corba.ee.spi.logging.LogWrapperBase;
import com.sun.corba.ee.spi.logging.LogWrapperCache;
import com.sun.corba.ee.spi.logging.LogWrapperFactory;
import com.sun.corba.ee.spi.orbutil.generic.UnaryFunction;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogWrapperCacheImpl
implements LogWrapperCache {
    private static final Map<String, LogWrapperFactory> GROUP_TO_FACTORY = new HashMap<String, LogWrapperFactory>();
    private UnaryFunction<String, String> loggerNameMapper;
    private Map<String, Map<String, LogWrapperBase>> immutableLogDomainMap;
    private Map<String, Map<String, LogWrapperBase>> logDomainMap;

    public static void mapGroupToFactory(String str, LogWrapperFactory factory) {
        GROUP_TO_FACTORY.put(str, factory);
    }

    public LogWrapperCacheImpl(String[][] preinitData, UnaryFunction<String, String> loggerNameMapper) {
        this.loggerNameMapper = loggerNameMapper;
        this.logDomainMap = new HashMap<String, Map<String, LogWrapperBase>>();
        this.immutableLogDomainMap = new HashMap<String, Map<String, LogWrapperBase>>();
        for (int ctr = 0; ctr < preinitData.length; ++ctr) {
            String[] data = preinitData[ctr];
            String logDomain = data[0];
            String exceptionGroup = data[1];
            this.getLogWrapper(this.immutableLogDomainMap, logDomain, exceptionGroup, GROUP_TO_FACTORY.get(exceptionGroup));
        }
    }

    @Override
    public LogWrapperBase getLogWrapper(String logDomain, String exceptionGroup) {
        LogWrapperBase result = this.getLogWrapper(this.immutableLogDomainMap, logDomain, exceptionGroup);
        return result;
    }

    @Override
    public LogWrapperBase getLogWrapper(String logDomain, String exceptionGroup, LogWrapperFactory factory) {
        LogWrapperBase result = this.getLogWrapper(logDomain, exceptionGroup);
        if (result == null) {
            result = this.getLogWrapper(this.logDomainMap, logDomain, exceptionGroup, factory);
        }
        return result;
    }

    private LogWrapperBase getLogWrapper(Map<String, Map<String, LogWrapperBase>> ldmap, String logDomain, String exceptionGroup) {
        LogWrapperBase result = null;
        Map<String, LogWrapperBase> map = ldmap.get(logDomain);
        if (map != null) {
            result = map.get(exceptionGroup);
        }
        return result;
    }

    private synchronized LogWrapperBase getLogWrapper(Map<String, Map<String, LogWrapperBase>> ldmap, String logDomain, String exceptionGroup, LogWrapperFactory factory) {
        LogWrapperBase result = null;
        Map<String, LogWrapperBase> map = ldmap.get(logDomain);
        if (map == null) {
            map = new HashMap<String, LogWrapperBase>();
            ldmap.put(logDomain, map);
        } else {
            result = map.get(exceptionGroup);
        }
        if (result == null) {
            result = factory.create(this.loggerNameMapper.evaluate(logDomain));
            map.put(exceptionGroup, result);
        }
        return result;
    }

    static {
        new ActivationSystemException("");
        new IORSystemException("");
        new InterceptorsSystemException("");
        new NamingSystemException("");
        new OMGSystemException("");
        new ORBUtilSystemException("");
        new POASystemException("");
        new UtilSystemException("");
    }
}

