/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.CorbaInvocationInfo;
import com.sun.corba.ee.pept.transport.ContactInfo;
import com.sun.corba.ee.pept.transport.ContactInfoList;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.CorbaContactInfo;
import com.sun.corba.ee.spi.transport.CorbaContactInfoList;
import com.sun.corba.ee.spi.transport.CorbaContactInfoListIterator;
import com.sun.corba.ee.spi.transport.IIOPPrimaryToContactInfo;
import java.util.Iterator;
import java.util.List;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;

public class CorbaContactInfoListIteratorImpl
implements CorbaContactInfoListIterator {
    protected ORB orb;
    protected CorbaContactInfoList contactInfoList;
    protected CorbaContactInfo successContactInfo;
    protected CorbaContactInfo failureContactInfo;
    protected RuntimeException failureException;
    protected ORBUtilSystemException wrapper;
    protected boolean debug;
    protected Iterator effectiveTargetIORIterator;
    protected CorbaContactInfo previousContactInfo;
    protected boolean isAddrDispositionRetry;
    protected boolean retryWithPreviousContactInfo;
    protected IIOPPrimaryToContactInfo primaryToContactInfo;
    protected ContactInfo primaryContactInfo;
    protected List listOfContactInfos;
    protected long startTime;
    protected long backoff;
    private static final long INITIAL_BACKOFF = 250L;

    public CorbaContactInfoListIteratorImpl(ORB orb, CorbaContactInfoList corbaContactInfoList, ContactInfo primaryContactInfo, List listOfContactInfos) {
        this.orb = orb;
        this.wrapper = ORBUtilSystemException.get(orb, "rpc.transport");
        this.debug = orb.transportDebugFlag;
        this.contactInfoList = corbaContactInfoList;
        this.primaryContactInfo = primaryContactInfo;
        if (listOfContactInfos != null) {
            this.effectiveTargetIORIterator = listOfContactInfos.iterator();
        }
        this.listOfContactInfos = listOfContactInfos;
        this.previousContactInfo = null;
        this.isAddrDispositionRetry = false;
        this.retryWithPreviousContactInfo = false;
        this.successContactInfo = null;
        this.failureContactInfo = null;
        this.failureException = null;
        this.startTime = -1L;
        this.primaryToContactInfo = orb.getORBData().getIIOPPrimaryToContactInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        boolean result = false;
        try {
            if (this.debug) {
                this.dprint(".hasNext->:");
            }
            if (this.startTime == -1L) {
                this.startTime = System.currentTimeMillis();
                this.backoff = 250L;
            } else {
                this.backoff *= 2L;
            }
            if (this.retryWithPreviousContactInfo) {
                if (this.debug) {
                    this.dprint(".hasNext: backoff before retry previous");
                }
                if (this.thresholdExceeded()) {
                    if (this.debug) {
                        this.dprint(".hasNext: com.sun.corba.ee.transport.ORBCommunicationsRetryTimeout exceeded: " + this.orb.getORBData().getCommunicationsRetryTimeout());
                    }
                    this.failureException = this.wrapper.communicationsRetryTimeout(this.failureException, (Object)Long.toString(this.orb.getORBData().getCommunicationsRetryTimeout()));
                    boolean bl = result = false;
                    return bl;
                }
                try {
                    Thread.sleep(this.backoff);
                }
                catch (InterruptedException e) {
                    this.wrapper.ignoringExceptionWhileWaitingForRetry(e);
                }
                boolean bl = result = true;
                return bl;
            }
            if (this.isAddrDispositionRetry) {
                boolean bl = result = true;
                return bl;
            }
            result = this.primaryToContactInfo != null ? this.primaryToContactInfo.hasNext(this.primaryContactInfo, this.previousContactInfo, this.listOfContactInfos) : this.effectiveTargetIORIterator.hasNext();
            if (!result && !this.thresholdExceeded()) {
                if (this.debug) {
                    this.dprint("Reached end of ContactInfoList list. Starting at beginning");
                }
                this.previousContactInfo = null;
                if (this.primaryToContactInfo != null) {
                    this.primaryToContactInfo.reset(this.primaryContactInfo);
                } else {
                    this.effectiveTargetIORIterator = this.listOfContactInfos.iterator();
                }
                boolean bl = result = this.hasNext();
                return bl;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (this.debug) {
                this.dprint(".hasNext<-: " + result);
            }
        }
    }

    private boolean thresholdExceeded() {
        return System.currentTimeMillis() - this.startTime >= this.orb.getORBData().getCommunicationsRetryTimeout();
    }

    public Object next() {
        if (this.retryWithPreviousContactInfo) {
            this.retryWithPreviousContactInfo = false;
            return this.previousContactInfo;
        }
        if (this.isAddrDispositionRetry) {
            this.isAddrDispositionRetry = false;
            return this.previousContactInfo;
        }
        this.previousContactInfo = this.primaryToContactInfo != null ? (CorbaContactInfo)this.primaryToContactInfo.next(this.primaryContactInfo, this.previousContactInfo, this.listOfContactInfos) : (CorbaContactInfo)this.effectiveTargetIORIterator.next();
        return this.previousContactInfo;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public ContactInfoList getContactInfoList() {
        return this.contactInfoList;
    }

    public void reportSuccess(ContactInfo contactInfo) {
        if (this.debug) {
            this.dprint(".reportSuccess: " + contactInfo);
        }
        this.successContactInfo = (CorbaContactInfo)contactInfo;
        this.backoff = 250L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reportException(ContactInfo contactInfo, RuntimeException ex) {
        boolean result = false;
        try {
            if (this.debug) {
                this.dprint(".reportException->: " + contactInfo + " " + ex);
            }
            this.failureContactInfo = (CorbaContactInfo)contactInfo;
            this.failureException = ex;
            if (ex instanceof COMM_FAILURE) {
                SystemException se = (SystemException)((Object)ex);
                if (se.minor == 1398079697) {
                    if (this.debug) {
                        this.dprint(".reportException: " + contactInfo + " " + ex + ": COMM_FAILURE/CONNECTION_REBIND - retryWithPreviousContactInfo");
                    }
                    this.retryWithPreviousContactInfo = true;
                    boolean bl = result = true;
                    return bl;
                }
                if (se.completed == CompletionStatus.COMPLETED_NO) {
                    if (this.hasNext()) {
                        if (this.debug) {
                            this.dprint(".reportException: " + contactInfo + " " + ex + ": COMM_FAILURE/COMPLETED_NO and hasNext/true - try next ContactInfo");
                        }
                        boolean bl = result = true;
                        return bl;
                    }
                    if (this.contactInfoList.getEffectiveTargetIOR() != this.contactInfoList.getTargetIOR()) {
                        if (this.debug) {
                            this.dprint(".reportException: " + contactInfo + " " + ex + ": COMM_FAILURE/COMPLETED_NO and hasNext/false and effect != target - retry target");
                        }
                        this.updateEffectiveTargetIOR(this.contactInfoList.getTargetIOR());
                        boolean bl = result = true;
                        return bl;
                    }
                }
            } else if (ex instanceof TRANSIENT) {
                if (this.debug) {
                    this.dprint(".reportException: " + contactInfo + " " + ex + ": TRANSIENT - retryWithPreviousContactInfo");
                }
                this.retryWithPreviousContactInfo = true;
                boolean bl = result = true;
                return bl;
            }
            result = false;
            this.backoff = 250L;
            boolean bl = result;
            return bl;
        }
        finally {
            if (this.debug) {
                this.dprint(".reportException<-: " + contactInfo + " " + ex + ": " + result);
            }
        }
    }

    public RuntimeException getFailureException() {
        if (this.failureException == null) {
            return ORBUtilSystemException.get(this.orb, "rpc.transport").invalidContactInfoListIteratorFailureException();
        }
        return this.failureException;
    }

    public void reportAddrDispositionRetry(CorbaContactInfo contactInfo, short disposition) {
        if (this.debug) {
            this.dprint(".reportAddrDispositionRetry: " + contactInfo + " " + disposition);
        }
        this.previousContactInfo.setAddressingDisposition(disposition);
        this.isAddrDispositionRetry = true;
        this.backoff = 250L;
    }

    public void reportRedirect(CorbaContactInfo contactInfo, IOR forwardedIOR) {
        if (this.debug) {
            this.dprint(".reportRedirect: " + contactInfo + " " + forwardedIOR);
        }
        this.updateEffectiveTargetIOR(forwardedIOR);
        this.backoff = 250L;
    }

    public void updateEffectiveTargetIOR(IOR newIOR) {
        this.contactInfoList.setEffectiveTargetIOR(newIOR);
        ((CorbaInvocationInfo)this.orb.getInvocationInfo()).setContactInfoListIterator(this.contactInfoList.iterator());
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaContactInfoListIteratorImpl", msg);
    }
}

