/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.presentation.rmi.bcel;

import com.sun.corba.ee.impl.codegen.CodeGeneratorUtil;
import com.sun.corba.ee.org.apache.bcel.Constants;
import com.sun.corba.ee.org.apache.bcel.generic.ArrayType;
import com.sun.corba.ee.org.apache.bcel.generic.BasicType;
import com.sun.corba.ee.org.apache.bcel.generic.ClassGen;
import com.sun.corba.ee.org.apache.bcel.generic.ConstantPoolGen;
import com.sun.corba.ee.org.apache.bcel.generic.InstructionConstants;
import com.sun.corba.ee.org.apache.bcel.generic.InstructionFactory;
import com.sun.corba.ee.org.apache.bcel.generic.InstructionList;
import com.sun.corba.ee.org.apache.bcel.generic.MethodGen;
import com.sun.corba.ee.org.apache.bcel.generic.PUSH;
import com.sun.corba.ee.org.apache.bcel.generic.ReferenceType;
import com.sun.corba.ee.org.apache.bcel.generic.Type;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyCreator
implements Constants {
    private static final String INVOKE_METHOD_NAME = "invoke";
    private String className;
    private String superClassName;
    private Class[] interfaces;
    private Method[] methods;
    private InstructionFactory instructionFactory;
    private ConstantPoolGen constantPoolGen;
    private ClassGen classGen;
    private byte[] classData;

    protected byte[] getClassData() {
        return this.classData;
    }

    public ProxyCreator(String className, String superClassName, Class[] interfaces, Method[] methods) {
        int ctr;
        this.className = className;
        this.superClassName = superClassName;
        this.interfaces = interfaces;
        this.methods = methods;
        String fileName = this.getFileName(className);
        String[] interfaceNames = new String[interfaces.length];
        for (ctr = 0; ctr < interfaces.length; ++ctr) {
            interfaceNames[ctr] = interfaces[ctr].getName();
        }
        this.classGen = new ClassGen(className, superClassName, fileName, 33, interfaceNames);
        this.constantPoolGen = this.classGen.getConstantPool();
        this.instructionFactory = new InstructionFactory(this.classGen, this.constantPoolGen);
        this.createConstructor();
        this.createWriteReplace();
        for (ctr = 0; ctr < methods.length; ++ctr) {
            this.createMethod(ctr, methods[ctr]);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.classGen.getJavaClass().dump(out);
        }
        catch (IOException exc) {
            RuntimeException rexc = new RuntimeException("Error in dumping class");
            rexc.initCause(exc);
            throw rexc;
        }
        this.classData = out.toByteArray();
    }

    public Class<?> create(ProtectionDomain pd, ClassLoader cl, boolean debug) {
        return CodeGeneratorUtil.makeClass(this.className, this.classData, pd, cl);
    }

    private String getFileName(String className) {
        int last = className.lastIndexOf(46);
        return className.substring(last + 1) + ".java";
    }

    private void finalizeMethod(ClassGen classGen, InstructionList il, MethodGen method) {
        method.setMaxStack();
        method.setMaxLocals();
        classGen.addMethod(method.getMethod());
        il.dispose();
    }

    private void createConstructor() {
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(1, Type.VOID, Type.NO_ARGS, new String[0], "<init>", this.className, il, this.constantPoolGen);
        il.append(InstructionFactory.createLoad(Type.OBJECT, 0));
        il.append(this.instructionFactory.createInvoke(this.superClassName, "<init>", Type.VOID, Type.NO_ARGS, (short)183));
        il.append(InstructionFactory.createReturn(Type.VOID));
        this.finalizeMethod(this.classGen, il, method);
    }

    private void createWriteReplace() {
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(2, Type.OBJECT, Type.NO_ARGS, new String[0], "writeReplace", this.className, il, this.constantPoolGen);
        il.append(InstructionFactory.createLoad(Type.OBJECT, 0));
        il.append(this.instructionFactory.createInvoke(this.className, "selfAsBaseClass", Type.OBJECT, Type.NO_ARGS, (short)182));
        il.append(InstructionFactory.createReturn(Type.OBJECT));
        this.finalizeMethod(this.classGen, il, method);
    }

    private int typeLength(Type type) {
        if (type.equals(Type.LONG)) {
            return 2;
        }
        if (type.equals(Type.DOUBLE)) {
            return 2;
        }
        return 1;
    }

    private ReferenceType typeForWrapper(BasicType type) {
        String signature = "L" + this.wrapperName(type) + ";";
        return (ReferenceType)Type.getType(signature);
    }

    private String wrapperName(BasicType type) {
        if (type.equals(Type.BOOLEAN)) {
            return "java.lang.Boolean";
        }
        if (type.equals(Type.BYTE)) {
            return "java.lang.Byte";
        }
        if (type.equals(Type.CHAR)) {
            return "java.lang.Character";
        }
        if (type.equals(Type.SHORT)) {
            return "java.lang.Short";
        }
        if (type.equals(Type.INT)) {
            return "java.lang.Integer";
        }
        if (type.equals(Type.LONG)) {
            return "java.lang.Long";
        }
        if (type.equals(Type.FLOAT)) {
            return "java.lang.Float";
        }
        if (type.equals(Type.DOUBLE)) {
            return "java.lang.Double";
        }
        throw new IllegalStateException();
    }

    private String wrapperValueMethod(BasicType type) {
        if (type.equals(Type.BOOLEAN)) {
            return "booleanValue";
        }
        if (type.equals(Type.BYTE)) {
            return "byteValue";
        }
        if (type.equals(Type.CHAR)) {
            return "charValue";
        }
        if (type.equals(Type.SHORT)) {
            return "shortValue";
        }
        if (type.equals(Type.INT)) {
            return "intValue";
        }
        if (type.equals(Type.LONG)) {
            return "longValue";
        }
        if (type.equals(Type.FLOAT)) {
            return "floatValue";
        }
        if (type.equals(Type.DOUBLE)) {
            return "doubleValue";
        }
        throw new IllegalStateException();
    }

    String[] makeArgNames(int num) {
        String[] result = new String[num];
        for (int ctr = 0; ctr < num; ++ctr) {
            result[ctr] = "arg" + ctr;
        }
        return result;
    }

    private void createMethod(int index, Method method) {
        String methodName = method.getName();
        String signature = Type.getSignature(method);
        Type[] argTypes = Type.getArgumentTypes(signature);
        int arglen = argTypes.length;
        Type resultType = Type.getReturnType(signature);
        InstructionList il = new InstructionList();
        MethodGen mgen = new MethodGen(1, resultType, argTypes, this.makeArgNames(arglen), methodName, this.className, il, this.constantPoolGen);
        if (arglen > 0) {
            il.append(new PUSH(this.constantPoolGen, arglen));
            il.append(this.instructionFactory.createNewArray(Type.OBJECT, (short)1));
            int argOffset = 1;
            for (int ctr = 0; ctr < arglen; ++ctr) {
                Type argType = argTypes[ctr];
                il.append(InstructionConstants.DUP);
                il.append(new PUSH(this.constantPoolGen, ctr));
                if (argType instanceof BasicType) {
                    il.append(this.instructionFactory.createNew(this.wrapperName((BasicType)argType)));
                    il.append(InstructionConstants.DUP);
                    il.append(InstructionFactory.createLoad(argType, argOffset));
                    il.append(this.instructionFactory.createInvoke(this.wrapperName((BasicType)argType), "<init>", Type.VOID, new Type[]{argType}, (short)183));
                } else {
                    il.append(InstructionFactory.createLoad(argType, argOffset));
                }
                il.append(InstructionConstants.AASTORE);
                argOffset += this.typeLength(argType);
            }
            il.append(InstructionFactory.createStore(Type.OBJECT, argOffset));
            il.append(InstructionFactory.createLoad(Type.OBJECT, 0));
            il.append(new PUSH(this.constantPoolGen, index));
            il.append(InstructionFactory.createLoad(Type.OBJECT, argOffset));
        } else {
            il.append(InstructionFactory.createLoad(Type.OBJECT, 0));
            il.append(new PUSH(this.constantPoolGen, index));
            il.append(InstructionConstants.ACONST_NULL);
        }
        il.append(this.instructionFactory.createInvoke(this.className, INVOKE_METHOD_NAME, Type.OBJECT, new Type[]{Type.INT, new ArrayType(Type.OBJECT, 1)}, (short)182));
        if (!resultType.equals(Type.VOID)) {
            if (resultType instanceof ReferenceType) {
                il.append(this.instructionFactory.createCheckCast((ReferenceType)resultType));
            } else if (resultType instanceof BasicType) {
                BasicType basicResultType = (BasicType)resultType;
                ReferenceType refType = this.typeForWrapper(basicResultType);
                il.append(this.instructionFactory.createCheckCast(refType));
                il.append(this.instructionFactory.createInvoke(this.wrapperName(basicResultType), this.wrapperValueMethod(basicResultType), resultType, Type.NO_ARGS, (short)182));
            } else {
                throw new IllegalStateException();
            }
        }
        il.append(InstructionFactory.createReturn(resultType));
        this.finalizeMethod(this.classGen, il, mgen);
    }
}

