/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.ior.iiop;

import com.sun.corba.ee.impl.encoding.EncapsInputStream;
import com.sun.corba.ee.impl.encoding.EncapsOutputStream;
import com.sun.corba.ee.impl.ior.EncapsulationUtility;
import com.sun.corba.ee.impl.ior.iiop.IIOPAddressImpl;
import com.sun.corba.ee.impl.logging.IORSystemException;
import com.sun.corba.ee.impl.util.JDKBridge;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.IdentifiableBase;
import com.sun.corba.ee.spi.ior.ObjectAdapterId;
import com.sun.corba.ee.spi.ior.ObjectId;
import com.sun.corba.ee.spi.ior.ObjectKey;
import com.sun.corba.ee.spi.ior.ObjectKeyTemplate;
import com.sun.corba.ee.spi.ior.TaggedComponent;
import com.sun.corba.ee.spi.ior.TaggedProfile;
import com.sun.corba.ee.spi.ior.TaggedProfileTemplate;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.ior.iiop.IIOPFactories;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfile;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.ior.iiop.JavaCodebaseComponent;
import com.sun.corba.ee.spi.oa.ObjectAdapter;
import com.sun.corba.ee.spi.oa.ObjectAdapterFactory;
import com.sun.corba.ee.spi.orb.ORBVersion;
import com.sun.corba.ee.spi.protocol.RequestDispatcherRegistry;
import java.util.Iterator;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.IOP.TaggedProfileHelper;

public class IIOPProfileImpl
extends IdentifiableBase
implements IIOPProfile {
    private com.sun.corba.ee.spi.orb.ORB orb;
    private IORSystemException wrapper;
    private ObjectId oid;
    private IIOPProfileTemplate proftemp;
    private ObjectKeyTemplate oktemp;
    protected String codebase = null;
    protected boolean cachedCodebase = false;
    private boolean checkedIsLocal = false;
    private boolean cachedIsLocal = false;
    private GIOPVersion giopVersion = null;

    public boolean equals(java.lang.Object obj) {
        if (!(obj instanceof IIOPProfileImpl)) {
            return false;
        }
        IIOPProfileImpl other = (IIOPProfileImpl)obj;
        return this.oid.equals(other.oid) && this.proftemp.equals(other.proftemp) && this.oktemp.equals(other.oktemp);
    }

    public int hashCode() {
        return this.oid.hashCode() ^ this.proftemp.hashCode() ^ this.oktemp.hashCode();
    }

    public ObjectId getObjectId() {
        return this.oid;
    }

    public TaggedProfileTemplate getTaggedProfileTemplate() {
        return this.proftemp;
    }

    public ObjectKeyTemplate getObjectKeyTemplate() {
        return this.oktemp;
    }

    private IIOPProfileImpl(com.sun.corba.ee.spi.orb.ORB orb) {
        this.orb = orb;
        this.wrapper = IORSystemException.get(orb, "oa.ior");
    }

    public IIOPProfileImpl(com.sun.corba.ee.spi.orb.ORB orb, ObjectKeyTemplate oktemp, ObjectId oid, IIOPProfileTemplate proftemp) {
        this(orb);
        this.oktemp = oktemp;
        this.oid = oid;
        this.proftemp = proftemp;
    }

    public IIOPProfileImpl(InputStream is) {
        this((com.sun.corba.ee.spi.orb.ORB)is.orb());
        this.init(is);
    }

    public IIOPProfileImpl(com.sun.corba.ee.spi.orb.ORB orb, org.omg.IOP.TaggedProfile profile) {
        this(orb);
        if (profile == null || profile.tag != 0 || profile.profile_data == null) {
            throw this.wrapper.invalidTaggedProfile();
        }
        EncapsInputStream istr = new EncapsInputStream((ORB)orb, profile.profile_data, profile.profile_data.length);
        istr.consumeEndian();
        this.init(istr);
    }

    private void init(InputStream istr) {
        GIOPVersion version = new GIOPVersion();
        version.read((org.omg.CORBA.portable.InputStream)istr);
        IIOPAddressImpl primary = new IIOPAddressImpl(istr);
        byte[] key = EncapsulationUtility.readOctets(istr);
        ObjectKey okey = this.orb.getObjectKeyFactory().create(key);
        this.oktemp = okey.getTemplate();
        this.oid = okey.getId();
        this.proftemp = IIOPFactories.makeIIOPProfileTemplate(this.orb, version, primary);
        if (version.getMinor() > 0) {
            EncapsulationUtility.readIdentifiableSequence(this.proftemp, this.orb.getTaggedComponentFactoryFinder(), istr);
        }
        if (this.uncachedGetCodeBase() == null) {
            JavaCodebaseComponent jcc = LocalCodeBaseSingletonHolder.comp;
            if (jcc != null) {
                if (version.getMinor() > 0) {
                    this.proftemp.add(jcc);
                }
                this.codebase = jcc.getURLs();
            }
            this.cachedCodebase = true;
        }
    }

    public void writeContents(OutputStream os) {
        this.proftemp.write(this.oktemp, this.oid, os);
    }

    public int getId() {
        return this.proftemp.getId();
    }

    public boolean isEquivalent(TaggedProfile prof) {
        if (!(prof instanceof IIOPProfile)) {
            return false;
        }
        IIOPProfile other = (IIOPProfile)prof;
        return this.oid.equals(other.getObjectId()) && this.proftemp.isEquivalent(other.getTaggedProfileTemplate()) && this.oktemp.equals(other.getObjectKeyTemplate());
    }

    public ObjectKey getObjectKey() {
        ObjectKey result = IORFactories.makeObjectKey(this.oktemp, this.oid);
        return result;
    }

    public org.omg.IOP.TaggedProfile getIOPProfile() {
        EncapsOutputStream os = new EncapsOutputStream(this.orb);
        os.write_long(this.getId());
        this.write(os);
        InputStream is = (InputStream)os.create_input_stream();
        return TaggedProfileHelper.read((org.omg.CORBA.portable.InputStream)is);
    }

    private String uncachedGetCodeBase() {
        Iterator<TaggedComponent> iter = this.proftemp.iteratorById(25);
        if (iter.hasNext()) {
            JavaCodebaseComponent jcbc = (JavaCodebaseComponent)JavaCodebaseComponent.class.cast(iter.next());
            return jcbc.getURLs();
        }
        return null;
    }

    public synchronized String getCodebase() {
        if (!this.cachedCodebase) {
            this.cachedCodebase = true;
            this.codebase = this.uncachedGetCodeBase();
        }
        return this.codebase;
    }

    public ORBVersion getORBVersion() {
        return this.oktemp.getORBVersion();
    }

    public synchronized boolean isLocal() {
        if (!this.checkedIsLocal) {
            this.checkedIsLocal = true;
            String host = this.proftemp.getPrimaryAddress().getHost();
            this.cachedIsLocal = this.orb.isLocalHost(host) && this.orb.isLocalServerId(this.oktemp.getSubcontractId(), this.oktemp.getServerId()) && this.orb.getLegacyServerSocketManager().legacyIsLocalServerPort(this.proftemp.getPrimaryAddress().getPort());
        }
        return this.cachedIsLocal;
    }

    public java.lang.Object getServant() {
        if (!this.isLocal()) {
            return null;
        }
        RequestDispatcherRegistry scr = this.orb.getRequestDispatcherRegistry();
        ObjectAdapterFactory oaf = scr.getObjectAdapterFactory(this.oktemp.getSubcontractId());
        ObjectAdapterId oaid = this.oktemp.getObjectAdapterId();
        ObjectAdapter oa = null;
        try {
            oa = oaf.find(oaid);
        }
        catch (SystemException exc) {
            this.wrapper.getLocalServantFailure(exc, (java.lang.Object)oaid.toString());
            return null;
        }
        byte[] boid = this.oid.getId();
        Object servant = oa.getLocalServant(boid);
        return servant;
    }

    public synchronized GIOPVersion getGIOPVersion() {
        return this.proftemp.getGIOPVersion();
    }

    public void makeImmutable() {
        this.proftemp.makeImmutable();
    }

    private static class LocalCodeBaseSingletonHolder {
        public static JavaCodebaseComponent comp;

        private LocalCodeBaseSingletonHolder() {
        }

        static {
            String localCodebase = JDKBridge.getLocalCodebase();
            comp = localCodebase == null ? null : IIOPFactories.makeJavaCodebaseComponent(localCodebase);
        }
    }
}

