/*
 * Decompiled with CFR 0.152.
 */
package com.stc.jmsjca.wmq;

import com.stc.jmsjca.core.RAJMSActivationSpec;
import com.stc.jmsjca.core.RAJMSObjectFactory;
import com.stc.jmsjca.core.RAJMSResourceAdapter;
import com.stc.jmsjca.core.XManagedConnectionFactory;
import com.stc.jmsjca.localization.LocalizedString;
import com.stc.jmsjca.util.ConnectionUrl;
import com.stc.jmsjca.util.Exc;
import com.stc.jmsjca.util.Logger;
import com.stc.jmsjca.util.Str;
import com.stc.jmsjca.util.UrlParser;
import com.stc.jmsjca.wmq.Localizer;
import com.stc.jmsjca.wmq.WMQConnectionUrl;
import com.stc.jmsjca.wmq.WMQXAResource;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;

public class RAWMQObjectFactory
extends RAJMSObjectFactory
implements Serializable {
    private static Logger sLog = Logger.getLogger((Class)RAWMQObjectFactory.class);
    private static final String PROTOCOL = "wmq";
    private static final String SPROTOCOL = "wmqs";
    private static final String PORT = "Port";
    private static final String HOSTNAME = "HostName";
    private static final String QUEUEMANAGER = "QueueManager";
    private static final String TRANSPORTTYPE = "TransportType";
    private static final String CHANNEL = "Channel";
    private static final String CLIENTID = "ClientId";
    private static final String DEFAULT_CLIENTID = "SeeBeyond RAWMQ";
    private static final String DEFAULT_TRANSPORTTYPE = "JMSC_MQJMS_TP_CLIENT_MQ_TCPIP";
    private static final String PORTPROPERTY = "WMQ.Server.Port";
    private static final String HOSTPROPERTY = "WMQ.Server.Host";
    private static final String[] URL_PREFIXES = new String[]{"wmq://", "wmqs://"};
    private static final String[] TRANSPORT_TYPES = new String[]{"JMSC.MQJMS_TP_BINDINGS_MQ", "JMSC_MQJMS_TP_CLIENT_MQ_TCPIP"};
    private static Localizer LOCALE = Localizer.get();

    public boolean validateAndAdjustURL(ConnectionUrl connectionUrl) throws JMSException {
        String host;
        boolean hasChanged = false;
        UrlParser url = (UrlParser)connectionUrl;
        if (!PROTOCOL.equals(url.getProtocol())) {
            if (PROTOCOL.equals(url.getProtocol())) {
                throw new JMSException("protocol [" + url.getProtocol() + "] not supported");
            }
            throw new JMSException("Invalid protocol [" + url.getProtocol() + "]: should be " + PROTOCOL);
        }
        int port = url.getPort();
        if (port <= 0) {
            String s = System.getProperty(PORTPROPERTY);
            if (s != null) {
                port = Integer.parseInt(s);
                url.setPort(port);
                hasChanged = true;
            } else {
                throw new JMSException("No port specified in URL [" + url + "], and also not available in System property [" + PORTPROPERTY + "]");
            }
        }
        if ("".equals(host = url.getHost())) {
            String s = System.getProperty(HOSTPROPERTY);
            if (s != null) {
                url.setHost(s);
            } else {
                url.setHost("localhost");
            }
            hasChanged = true;
        }
        return hasChanged;
    }

    public int adjustDeliveryMode(int mode, boolean xa) {
        int newMode = mode;
        if (xa && mode != 3) {
            newMode = 3;
            sLog.warn(LOCALE.x("E820: Current delivery mode {0} not supported;  not supported; switching to {1}", RAJMSActivationSpec.DELIVERYCONCURRENCY_STRS[mode], RAJMSActivationSpec.DELIVERYCONCURRENCY_STRS[newMode]));
        }
        return newMode;
    }

    public String getQueueManager(String hostStr) {
        if (!Character.isLetter(hostStr.charAt(0))) {
            try {
                InetAddress inetAdd = InetAddress.getByName(hostStr);
                hostStr = inetAdd.getHostName();
            }
            catch (UnknownHostException uhe) {
                hostStr = "localhost";
            }
        }
        String uHostStr = hostStr.split("\\.") == null ? hostStr : hostStr.split("\\.")[0];
        return "QM_" + uHostStr.replace('-', '_').toLowerCase();
    }

    public ConnectionUrl getProperties(Properties p, RAJMSResourceAdapter ra, RAJMSActivationSpec spec, XManagedConnectionFactory fact, String overrideUrl) throws JMSException {
        UrlParser url = (UrlParser)super.getProperties(p, ra, spec, fact, overrideUrl);
        this.validateAndAdjustURL((ConnectionUrl)url);
        p.setProperty(HOSTNAME, url.getHost());
        p.setProperty(PORT, Integer.toString(url.getPort()));
        String clientId = DEFAULT_CLIENTID;
        if (spec != null && !Str.empty((String)spec.getClientId())) {
            clientId = spec.getClientId();
        }
        p.setProperty(CLIENTID, clientId);
        return url;
    }

    public ConnectionFactory createConnectionFactory(int domain, RAJMSResourceAdapter resourceAdapter, RAJMSActivationSpec activationSpec, XManagedConnectionFactory fact, String overrideUrl) throws JMSException {
        ConnectionFactory cf = null;
        String urlStr = resourceAdapter.getConnectionURL();
        if (activationSpec != null && !Str.empty((String)activationSpec.getConnectionURL())) {
            urlStr = activationSpec.getConnectionURL();
        }
        if (fact != null && !Str.empty((String)fact.getConnectionURL())) {
            urlStr = fact.getConnectionURL();
        }
        String realUrl = resourceAdapter.lookUpLDAP(urlStr);
        String clientId = DEFAULT_CLIENTID;
        if (activationSpec != null && !Str.empty((String)activationSpec.getClientId())) {
            clientId = activationSpec.getClientId();
        }
        Properties cfp = new Properties();
        try {
            WMQConnectionUrl url = new WMQConnectionUrl(realUrl);
            this.validateAndAdjustURL((ConnectionUrl)url.getUrlParser());
            Properties p = new Properties();
            url.getQueryProperties(p);
            String qMgr = p.getProperty(QUEUEMANAGER, this.getQueueManager(url.getUrlParser().getHost()));
            String transType = p.getProperty(TRANSPORTTYPE, DEFAULT_TRANSPORTTYPE);
            if (TRANSPORT_TYPES[0].equals(transType)) {
                cfp.setProperty(TRANSPORTTYPE, "0");
            } else if (TRANSPORT_TYPES[1].equals(transType)) {
                cfp.setProperty(TRANSPORTTYPE, "1");
            } else {
                cfp.setProperty(TRANSPORTTYPE, "1");
            }
            cfp.setProperty(QUEUEMANAGER, qMgr);
            cfp.setProperty(HOSTNAME, url.getUrlParser().getHost());
            cfp.setProperty(PORT, Integer.toString(url.getUrlParser().getPort()));
            cfp.setProperty(CLIENTID, clientId);
            String channelName = p.getProperty(CHANNEL);
            if (channelName != null) {
                cfp.setProperty(CHANNEL, channelName);
            }
        }
        catch (Exception ex) {
            JMSException e = new JMSException("Invalid url " + realUrl);
            e.initCause((Throwable)ex);
            throw e;
        }
        try {
            switch (domain) {
                case 1: {
                    cf = (ConnectionFactory)Class.forName("com.ibm.mq.jms.MQQueueConnectionFactory").newInstance();
                    break;
                }
                case 3: {
                    cf = (ConnectionFactory)Class.forName("com.ibm.mq.jms.MQXAQueueConnectionFactory").newInstance();
                    break;
                }
                case 2: {
                    cf = (ConnectionFactory)Class.forName("com.ibm.mq.jms.MQXATopicConnectionFactory").newInstance();
                    break;
                }
                case 4: {
                    cf = (ConnectionFactory)Class.forName("com.ibm.mq.jms.MQXATopicConnectionFactory").newInstance();
                    break;
                }
                case 6: {
                    cf = (ConnectionFactory)Class.forName("com.ibm.mq.jms.MQConnectionFactory").newInstance();
                    break;
                }
                case 5: {
                    cf = (ConnectionFactory)Class.forName("com.ibm.mq.jms.MQXAConnectionFactory").newInstance();
                    break;
                }
                default: {
                    throw new JMSException("Logic fault: invalid domain " + domain);
                }
            }
        }
        catch (Exception ex) {
            throw Exc.jmsExc((LocalizedString)LOCALE.x("E840: MQ connection factory instantiation failure: {0}", ex), (Exception)ex);
        }
        Class<?> clazz = cf.getClass();
        try {
            clazz.getMethod("setHostName", String.class).invoke((Object)cf, cfp.getProperty(HOSTNAME));
            clazz.getMethod("setPort", Integer.TYPE).invoke((Object)cf, Integer.valueOf(cfp.getProperty(PORT)));
            clazz.getMethod("setQueueManager", String.class).invoke((Object)cf, cfp.getProperty(QUEUEMANAGER));
            clazz.getMethod("setTransportType", Integer.TYPE).invoke((Object)cf, Integer.valueOf(cfp.getProperty(TRANSPORTTYPE)));
            clazz.getMethod("setClientID", String.class).invoke((Object)cf, cfp.getProperty(CLIENTID));
            String channelName = cfp.getProperty(CHANNEL);
            if (channelName != null) {
                clazz.getMethod("setChannel", String.class).invoke((Object)cf, channelName);
            }
        }
        catch (Exception e) {
            throw Exc.jmsExc((LocalizedString)LOCALE.x("E841: Failure to set connection factory properties: {0}", e), (Exception)e);
        }
        return cf;
    }

    public boolean isUrl(String url) {
        if (url != null && url.length() > 0) {
            for (int i = 0; i < URL_PREFIXES.length; ++i) {
                if (!url.startsWith(URL_PREFIXES[i])) continue;
                return true;
            }
        }
        return false;
    }

    public XAResource getXAResource(boolean isXA, Session s) {
        return !isXA ? null : new WMQXAResource(((XASession)s).getXAResource());
    }

    public String getJMSServerType() {
        return "WMQ";
    }
}

