/*
 * Decompiled with CFR 0.152.
 */
package com.stc.jmsjca.wl;

import com.stc.jmsjca.core.AdminDestination;
import com.stc.jmsjca.core.PseudoXASession;
import com.stc.jmsjca.core.RAJMSActivationSpec;
import com.stc.jmsjca.core.RAJMSObjectFactory;
import com.stc.jmsjca.core.RAJMSResourceAdapter;
import com.stc.jmsjca.core.SessionConnection;
import com.stc.jmsjca.core.XConnectionRequestInfo;
import com.stc.jmsjca.core.XManagedConnection;
import com.stc.jmsjca.core.XManagedConnectionFactory;
import com.stc.jmsjca.localization.LocalizedString;
import com.stc.jmsjca.util.Exc;
import com.stc.jmsjca.util.Logger;
import com.stc.jmsjca.util.UrlParser;
import com.stc.jmsjca.wl.Localizer;
import com.stc.jmsjca.wl.WLSessionConnection;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XATopicConnection;
import javax.naming.InitialContext;

public class RAWLObjectFactory
extends RAJMSObjectFactory
implements Serializable {
    private static Logger sLog = Logger.getLogger((Class)RAWLObjectFactory.class);
    public static final String PROT_T3 = "t3";
    public static final String JNDI_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    public static final String DEFAULT_XACF = "weblogic.jms.XAConnectionFactory";
    public static final String IS_ORBCLASS = "com.sun.enterprise.util.ORBManager";
    public static final String IS_ORBCLASS2 = "com.stc.corba.any.UtilDelegate";
    public static final String IS_ORBMETHOD = "getSeOrbInitProperties";
    public static final String IS_ORBMETHOD_ISON = "supportsSE";
    private static final String JNDI_WEBLOGIC_PROTOCOL_PACKAGES = "weblogic.corba.j2ee.naming.url:com.sun.jndi.url";
    private static final String DEFAULT_FACTORY_NAME = "weblogic.jms.XAConnectionFactory";
    private static final String FACTORY_PROPERTYNAME = "JMSJCA.WLFACTORY";
    private static final String[] URL_PREFIXES = new String[]{"t3://"};
    private static Localizer LOCALE = Localizer.get();
    private transient Method mSpecialISORBMethod;
    private transient Method mSpecialISORBMethodIsOn;

    public RAWLObjectFactory() {
        try {
            Class<?> c = Class.forName(IS_ORBCLASS);
            this.mSpecialISORBMethod = c.getMethod(IS_ORBMETHOD, new Class[0]);
            c = Class.forName(IS_ORBCLASS2);
            this.mSpecialISORBMethodIsOn = c.getMethod(IS_ORBMETHOD_ISON, new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int adjustDeliveryMode(int mode, boolean xa) {
        int newMode = mode;
        if (mode != 3) {
            newMode = 3;
            sLog.warn(LOCALE.x("E820: Current delivery mode {0} not supported;  not supported; switching to {1}", RAJMSActivationSpec.DELIVERYCONCURRENCY_STRS[mode], RAJMSActivationSpec.DELIVERYCONCURRENCY_STRS[newMode]));
        }
        return newMode;
    }

    public SessionConnection createSessionConnection(Object connectionFactory, RAJMSObjectFactory objfact, RAJMSResourceAdapter ra, XManagedConnection mc, XConnectionRequestInfo descr, boolean isXa, boolean isTransacted, int acknowledgmentMode, Class sessionClass) throws JMSException {
        return new WLSessionConnection(connectionFactory, objfact, ra, mc, descr, isXa, isTransacted, acknowledgmentMode, sessionClass);
    }

    public Session createSession(Connection conn, boolean isXA, Class sessionClass, RAJMSResourceAdapter ra, RAJMSActivationSpec activationSpec, boolean transacted, int ackmode) throws JMSException {
        if (isXA) {
            if (sessionClass == TopicSession.class) {
                return new PseudoXASession((Session)((XATopicConnection)conn).createTopicSession(true, 0));
            }
            if (sessionClass == QueueSession.class) {
                return new PseudoXASession((Session)((XAQueueConnection)conn).createQueueSession(true, 0));
            }
            if (sessionClass == Session.class) {
                return new PseudoXASession(((XAConnection)conn).createSession(true, 0));
            }
        } else {
            if (sessionClass == TopicSession.class) {
                return ((TopicConnection)conn).createTopicSession(transacted, ackmode);
            }
            if (sessionClass == QueueSession.class) {
                return ((QueueConnection)conn).createQueueSession(transacted, ackmode);
            }
            if (sessionClass == Session.class) {
                return conn.createSession(transacted, ackmode);
            }
        }
        throw new RuntimeException("Unknown class " + sessionClass);
    }

    public static void safeClose(InitialContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Object getJndiObject(UrlParser url, String name) throws JMSException {
        Object object;
        InitialContext ctx;
        block8: {
            Boolean isEnabled;
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("Looking up JNDI object " + name));
            }
            if (name == null || name.length() == 0) {
                throw new JMSException("The JNDI name is null");
            }
            ctx = null;
            if (this.mSpecialISORBMethod == null) break block8;
            if (this.mSpecialISORBMethodIsOn != null && !(isEnabled = (Boolean)this.mSpecialISORBMethodIsOn.invoke(null, new Object[0])).booleanValue()) {
                throw Exc.rsrcExc((LocalizedString)LOCALE.x("E823: CORBA-SE needs to be enabled on this server. Please change the value of the <se-orb enabled=\"false\"/> to <se-orb enabled=\"true\"/> in the configuration file of  the Integration Server (logicalhost/is/domains/<domain-name>/config/domain.xml) and restart the server."));
            }
            Properties prop = (Properties)this.mSpecialISORBMethod.invoke(null, new Object[0]);
            prop.put("java.naming.factory.url.pkgs", JNDI_WEBLOGIC_PROTOCOL_PACKAGES);
            ctx = new InitialContext(prop);
            Object object2 = ctx.lookup("corbaname:iiop:1.2@" + url.getHost() + ":" + url.getPort() + '#' + name);
            RAWLObjectFactory.safeClose(ctx);
            return object2;
        }
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", JNDI_FACTORY);
            env.put("java.naming.provider.url", "t3://" + url.getHost() + ":" + url.getPort());
            ctx = new InitialContext(env);
            object = ctx.lookup(name);
        }
        catch (Exception e) {
            try {
                throw Exc.jmsExc((LocalizedString)LOCALE.x("E821: Could not find JNDI object by name [{0}]: {1}", name, e), (Exception)e);
            }
            catch (Throwable throwable) {
                RAWLObjectFactory.safeClose(ctx);
                throw throwable;
            }
        }
        RAWLObjectFactory.safeClose(ctx);
        return object;
    }

    public ConnectionFactory createConnectionFactory(int domain, RAJMSResourceAdapter resourceAdapter, RAJMSActivationSpec activationSpec, XManagedConnectionFactory fact, String overrideUrl) throws JMSException {
        Properties p = new Properties();
        UrlParser url = (UrlParser)this.getProperties(p, resourceAdapter, activationSpec, fact, overrideUrl);
        String factoryname = p.getProperty(FACTORY_PROPERTYNAME, "weblogic.jms.XAConnectionFactory");
        switch (domain) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                Object o = this.getJndiObject(url, factoryname);
                return (ConnectionFactory)o;
            }
        }
        throw new JMSException("Logic fault: invalid domain " + domain);
    }

    public Destination createDestination(Session sess, boolean isXA, boolean isTopic, RAJMSActivationSpec activationSpec, XManagedConnectionFactory fact, RAJMSResourceAdapter ra, String destName) throws JMSException {
        Destination ret = this.adminDestinationLookup(destName);
        if (ret != null && ret instanceof AdminDestination) {
            destName = ((AdminDestination)ret).getName();
            ret = null;
        }
        if (ret == null) {
            Properties p = new Properties();
            UrlParser url = (UrlParser)this.getProperties(p, ra, activationSpec, fact, null);
            String prefix = p.getProperty("prefix", "");
            if (prefix.length() > 0 && !prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            String name = prefix + destName;
            ret = (Destination)this.getJndiObject(url, name);
        }
        return ret;
    }

    public boolean isUrl(String url) {
        if (url != null && url.length() > 0) {
            for (int i = 0; i < URL_PREFIXES.length; ++i) {
                if (!url.startsWith(URL_PREFIXES[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void setClientID(Connection connection, boolean isTopic, RAJMSActivationSpec spec, RAJMSResourceAdapter ra) throws JMSException {
        if (isTopic && "Durable".equals(spec.getSubscriptionDurability())) {
            String currentClientId;
            String newClientId = spec.getClientId();
            boolean auto = false;
            if (newClientId == null || newClientId.length() == 0) {
                newClientId = "CLIENTID-" + spec.getSubscriptionName();
                auto = false;
            }
            if ((currentClientId = connection.getClientID()) == null || currentClientId.length() == 0) {
                this.setClientID(connection, newClientId);
            } else if (!newClientId.equals(currentClientId) && !auto) {
                sLog.warn(LOCALE.x("E822: ClientID is already set to [{0}]; cannot set to [{1}] as required in activationspec [{2}]", currentClientId, newClientId, spec));
            }
        }
    }

    public String getJMSServerType() {
        return "WL";
    }
}

