/*
 * Decompiled with CFR 0.152.
 */
package com.stc.jmsjca.wave;

import com.stc.jmsjca.core.RAJMSActivationSpec;
import com.stc.jmsjca.core.RAJMSObjectFactory;
import com.stc.jmsjca.core.RAJMSResourceAdapter;
import com.stc.jmsjca.core.SessionConnection;
import com.stc.jmsjca.core.XConnectionRequestInfo;
import com.stc.jmsjca.core.XManagedConnection;
import com.stc.jmsjca.core.XManagedConnectionFactory;
import com.stc.jmsjca.core.XXid;
import com.stc.jmsjca.localization.LocalizedString;
import com.stc.jmsjca.util.ConnectionUrl;
import com.stc.jmsjca.util.Exc;
import com.stc.jmsjca.util.Logger;
import com.stc.jmsjca.util.Str;
import com.stc.jmsjca.util.UrlParser;
import com.stc.jmsjca.wave.Localizer;
import com.stc.jmsjca.wave.RAWaveResourceAdapter;
import com.stc.jmsjca.wave.WaveUrlParser;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;

public class RAWaveObjectFactory
extends RAJMSObjectFactory
implements Serializable {
    private static Logger sLog = Logger.getLogger((Class)RAWaveObjectFactory.class);
    public static final String PROT_STREAM = "stream";
    public static final String PROT_TCP = "tcp";
    public static final String PROT_SSL = "ssl";
    public static final String PROT_HTTP = "http";
    private static final String[] URL_PREFIXES = new String[]{"stream://", "tcp://", "ssl://", "http://"};
    private static final String[] PROTOCOLS = new String[]{"stream", "tcp", "ssl", "http"};
    public static final String WAVECONTAINERMBEAN = "com.sun.appserv:type=messaging-server-admin-mbean,jmsservertype=wave,name=JMS_Grid_IQ_Manager";
    private static Localizer LOCALE = Localizer.get();

    public ConnectionUrl createConnectionUrl(String s) {
        return new WaveUrlParser(s);
    }

    public void cleanup(XManagedConnection con) {
        try {
            Object defaultSession;
            Object defaultConnection;
            Boolean isClosed;
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)"cleanup");
            }
            if ((isClosed = (Boolean)(defaultConnection = (defaultSession = con.getJSession().getDelegate()).getClass().getMethod("getConnection", new Class[0]).invoke(defaultSession, new Object[0])).getClass().getMethod("isClosed", new Class[0]).invoke(defaultConnection, new Object[0])).booleanValue()) {
                if (sLog.isDebugEnabled()) {
                    sLog.debug((Object)"connection already closed");
                }
                return;
            }
            String clientID = (String)defaultConnection.getClass().getMethod("getClientID", new Class[0]).invoke(defaultConnection, new Object[0]);
            if (clientID != null && clientID.trim().length() > 0) {
                if (clientID.startsWith("ID:")) {
                    sLog.debug((Object)(" not closing cleaned up connection with clientID set to " + clientID));
                } else {
                    sLog.debug((Object)("closing cleaned up connection with clientID set to " + clientID));
                    if (sLog.isDebugEnabled()) {
                        sLog.debug((Object)("closing cleaned up connection with clientID set to " + clientID));
                    }
                    defaultConnection.getClass().getMethod("close", new Class[0]).invoke(defaultConnection, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            sLog.error(LOCALE.x("E901: Error in clean up: {0}", e), (Throwable)e);
        }
    }

    public boolean isInvalid(XManagedConnection con) {
        boolean isInvalid = false;
        try {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)"isInvalid");
            }
            Object defaultSession = con.getJSession().getDelegate();
            Object defaultConnection = defaultSession.getClass().getMethod("getConnection", new Class[0]).invoke(defaultSession, new Object[0]);
            Boolean isClosed = (Boolean)defaultConnection.getClass().getMethod("isClosed", new Class[0]).invoke(defaultConnection, new Object[0]);
            isInvalid = isClosed;
        }
        catch (Exception e) {
            sLog.warn(LOCALE.x("E900: Error in isInvalid: {0}", e), (Throwable)e);
        }
        return isInvalid;
    }

    public boolean validateAndAdjustURL(ConnectionUrl aurl) throws JMSException {
        boolean hasChanged = false;
        WaveUrlParser waveParser = (WaveUrlParser)aurl;
        UrlParser[] parsers = waveParser.getUrlParsers();
        if (parsers.length == 0) {
            throw new JMSException("URL should be a comma delimited set of URLs");
        }
        for (int j = 0; j < parsers.length; ++j) {
            UrlParser url = parsers[j];
            boolean protOk = false;
            for (int i = 0; i < PROTOCOLS.length; ++i) {
                if (!PROTOCOLS[i].equals(url.getProtocol())) continue;
                protOk = true;
                break;
            }
            if (protOk) continue;
            throw new JMSException("Invalid protocol [" + url.getProtocol() + "]: should be one of [" + Str.concat((Object[])PROTOCOLS, (String)", ") + "].");
        }
        return hasChanged;
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionFactory createConnectionFactory(int domain, RAJMSResourceAdapter resourceAdapter, RAJMSActivationSpec activationSpec, XManagedConnectionFactory fact, String overrideUrl) throws JMSException {
        String urlstr = resourceAdapter.getConnectionURL();
        if (activationSpec != null && !Str.empty((String)activationSpec.getConnectionURL())) {
            urlstr = activationSpec.getConnectionURL();
        }
        if (fact != null && !Str.empty((String)fact.getConnectionURL())) {
            urlstr = fact.getConnectionURL();
        }
        String clientID = null;
        if (fact != null && !Str.empty((String)fact.getClientId())) {
            clientID = fact.getClientId();
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("createConnectionFactory: setting clientID to " + clientID));
            }
        }
        String realUrl = resourceAdapter.lookUpLDAP(urlstr);
        Properties profileprops = new Properties();
        try {
            WaveUrlParser url = new WaveUrlParser(realUrl);
            this.validateAndAdjustURL(url);
            profileprops.setProperty("defaultConnectionRetries", "1");
            profileprops.setProperty("defaultConnectionRetriesTimeout", "1");
            url.getQueryProperties(profileprops);
            profileprops.setProperty("driverNames", "SpiritWave");
            profileprops.setProperty("SpiritWave.messageChannels", url.getWaveUrlSet());
            if (clientID != null) {
                profileprops.setProperty("clientID", clientID);
            }
        }
        catch (Exception ex) {
            JMSException tothrow = new JMSException("Invalid url " + realUrl + ": " + ex);
            tothrow.initCause((Throwable)ex);
            throw tothrow;
        }
        switch (domain) {
            case 1: {
                String classname = "com.spirit.wave.jms.WaveQueueConnectionFactory";
                break;
            }
            case 3: {
                String classname = "com.spirit.wave.jms.WaveXAQueueConnectionFactory";
                break;
            }
            case 2: {
                String classname = "com.spirit.wave.jms.WaveTopicConnectionFactory";
                break;
            }
            case 4: {
                String classname = "com.spirit.wave.jms.WaveXATopicConnectionFactory";
                break;
            }
            case 6: {
                String classname = "com.spirit.wave.jms.WaveConnectionFactory";
                break;
            }
            case 5: {
                String classname = "com.spirit.wave.jms.WaveXAConnectionFactory";
                break;
            }
            default: {
                throw new JMSException("Logic fault: invalid domain " + domain);
            }
        }
        try {
            void var10_10;
            Class<?> clazz = Class.forName((String)var10_10);
            return (ConnectionFactory)clazz.getConstructor(Properties.class).newInstance(profileprops);
        }
        catch (Exception e) {
            throw Exc.jmsExc((LocalizedString)LOCALE.x("E902: Failed to instantiate connection factory: {0}", e), (Exception)e);
        }
    }

    public SessionConnection createSessionConnection(Object connectionFactory, RAJMSObjectFactory objfact, RAJMSResourceAdapter ra, XManagedConnection mc, XConnectionRequestInfo descr, boolean isXa, boolean isTransacted, int acknowledgmentMode, Class sessionClass) throws JMSException {
        SessionConnection result = super.createSessionConnection(connectionFactory, objfact, ra, mc, descr, isXa, isTransacted, acknowledgmentMode, sessionClass);
        if (descr.getClientID() == null) {
            this.setClientID(ra, result);
        }
        return result;
    }

    public boolean isUrl(String url) {
        if (url != null && url.length() > 0) {
            for (int i = 0; i < URL_PREFIXES.length; ++i) {
                if (!url.startsWith(URL_PREFIXES[i])) continue;
                return true;
            }
        }
        return false;
    }

    public String getClientIDPrefix(RAJMSResourceAdapter ra) {
        if (ra instanceof RAWaveResourceAdapter) {
            return ((RAWaveResourceAdapter)ra).getClientIDPrefix();
        }
        return null;
    }

    public void setClientID(Connection connection, boolean isTopic, RAJMSActivationSpec spec, RAJMSResourceAdapter ra) throws JMSException {
        String suffix = null;
        suffix = isTopic && "Durable".equals(spec.getSubscriptionDurability()) ? "" : "_" + XXid.toHex((byte[])new XXid().getGlobalTransactionId());
        String currentClientId = connection.getClientID();
        String resourceAdaptorClientID = this.getClientIDPrefix(ra);
        if (currentClientId == null || currentClientId.length() == 0) {
            if (resourceAdaptorClientID == null || resourceAdaptorClientID.length() == 0) {
                if (spec.getSubscriptionDurability().equals("Durable")) {
                    this.setClientID(connection, "CLIENTID-" + spec.getSubscriptionName());
                }
            } else {
                this.setClientID(connection, resourceAdaptorClientID + suffix);
            }
        } else if (resourceAdaptorClientID != null && resourceAdaptorClientID.length() != 0 && !currentClientId.equals(resourceAdaptorClientID + suffix)) {
            sLog.warn(LOCALE.x("E903: ClientID is already set to [{0}]; cannot set to [{1}] as required in resource adaptor", currentClientId, resourceAdaptorClientID + suffix));
        }
    }

    public void setClientID(RAJMSResourceAdapter ra, SessionConnection sc) throws JMSException {
    }

    public String getJMSServerType() {
        return "WAVE";
    }

    public Object getServerMgtMBean(RAJMSResourceAdapter ra, RAJMSActivationSpec spec) throws JMSException {
        Object ret = null;
        sLog.debug((Object)"At start of getServerMgtMBean");
        if (ret == null) {
            String password;
            String username;
            sLog.debug((Object)"getServerMgtMBean - using option 3");
            Properties p = new Properties();
            ConnectionUrl url = this.getProperties(p, ra, spec, null, null);
            this.validateAndAdjustURL(url);
            Properties connectionProperties = new Properties();
            UrlParser tcpUrl = this.getTcpConnection(url);
            if (tcpUrl != null) {
                connectionProperties.setProperty("hostname", tcpUrl.getHost());
                connectionProperties.setProperty("port", Integer.toString(tcpUrl.getPort()));
                connectionProperties.setProperty("protocol", PROT_TCP);
            } else {
                UrlParser sslUrl = this.getSslConnection(url);
                if (sslUrl != null) {
                    connectionProperties.setProperty("hostname", sslUrl.getHost());
                    connectionProperties.setProperty("port", Integer.toString(sslUrl.getPort()));
                    connectionProperties.setProperty("protocol", PROT_SSL);
                } else {
                    UrlParser httpUrl = this.getHttpConnection(url);
                    connectionProperties.setProperty("hostname", httpUrl.getHost());
                    connectionProperties.setProperty("port", Integer.toString(httpUrl.getPort()));
                    connectionProperties.setProperty("protocol", PROT_HTTP);
                }
            }
            String string = username = spec == null ? null : spec.getUserName();
            if (username == null) {
                username = ra.getUserName();
            }
            String string2 = password = spec == null ? null : spec.getPassword();
            if (password == null) {
                password = ra.getPassword();
            }
            try {
                Class<?> c = Class.forName("com.stc.jmsmx.wave.ExternalWaveMBean");
                Object waveMBean = c.newInstance();
                Class[] signatures = new Class[]{Properties.class, String.class, String.class};
                Object[] args = new Object[]{connectionProperties, username, password};
                Method method = c.getMethod("setConnectInfo", signatures);
                method.invoke(waveMBean, args);
                ret = waveMBean;
            }
            catch (Exception e) {
                throw Exc.jmsExc((LocalizedString)LOCALE.x("E904: Error instantiating or configuring MBean for external JMS Grid daemon management: {0}", e), (Exception)e);
            }
        }
        return ret;
    }

    private UrlParser getTcpConnection(ConnectionUrl url) {
        WaveUrlParser waveParser = (WaveUrlParser)url;
        UrlParser[] parsers = waveParser.getUrlParsers();
        UrlParser result = null;
        for (int i = 0; i < parsers.length; ++i) {
            UrlParser candidate = parsers[i];
            if (!candidate.getProtocol().equals(PROT_TCP)) continue;
            result = candidate;
            break;
        }
        return result;
    }

    private UrlParser getSslConnection(ConnectionUrl url) {
        WaveUrlParser waveParser = (WaveUrlParser)url;
        UrlParser[] parsers = waveParser.getUrlParsers();
        UrlParser result = null;
        for (int i = 0; i < parsers.length; ++i) {
            UrlParser candidate = parsers[i];
            if (!candidate.getProtocol().equals(PROT_SSL)) continue;
            result = candidate;
            break;
        }
        return result;
    }

    private UrlParser getHttpConnection(ConnectionUrl url) {
        WaveUrlParser waveParser = (WaveUrlParser)url;
        UrlParser[] parsers = waveParser.getUrlParsers();
        UrlParser result = null;
        for (int i = 0; i < parsers.length; ++i) {
            UrlParser candidate = parsers[i];
            if (!candidate.getProtocol().equals(PROT_HTTP)) continue;
            result = candidate;
            break;
        }
        return result;
    }
}

