/*
 * Decompiled with CFR 0.152.
 */
package com.stc.jmsjca.unifiedjms;

import com.stc.jmsjca.core.RAJMSObjectFactory;
import com.stc.jmsjca.core.RAJMSResourceAdapter;
import com.stc.jmsjca.unifiedjms.Localizer;
import com.stc.jmsjca.util.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RAUnifiedResourceAdapter
extends RAJMSResourceAdapter {
    private static Logger sLog = Logger.getLogger((Class)RAUnifiedResourceAdapter.class);
    private Map mObjFactories = Collections.synchronizedMap(new HashMap());
    private static Localizer LOCALE = Localizer.get();

    public RAJMSObjectFactory createObjectFactory(String url) {
        RAJMSObjectFactory alreadyset = (RAJMSObjectFactory)this.mObjFactories.get(url);
        if (alreadyset != null) {
            return alreadyset;
        }
        if (url == null || url.length() == 0) {
            throw new RuntimeException("URL is not set");
        }
        String[] classnames = new String[]{"com.stc.jmsjca.stcms.RASTCMSObjectFactory", "com.stc.jmsjca.jndi.RAJNDIObjectFactory", "com.stc.jmsjca.sunone.RASunOneObjectFactory", "com.stc.jmsjca.jboss.RAJBossObjectFactory", "com.stc.jmsjca.stcms453.RASTCMS453ObjectFactory", "com.stc.jmsjca.wl.RAWLObjectFactory", "com.stc.jmsjca.wmq.RAWMQObjectFactory"};
        for (int i = 0; i < classnames.length; ++i) {
            try {
                Class<?> c = Class.forName(classnames[i], true, ((Object)((Object)this)).getClass().getClassLoader());
                RAJMSObjectFactory o = (RAJMSObjectFactory)c.newInstance();
                if (!o.isUrl(url)) continue;
                this.mObjFactories.put(url, o);
                return o;
            }
            catch (Exception e) {
                sLog.warn(LOCALE.x("E700: Error while matching URL [{0}] with classname [{1}]: {2}", url, classnames[i], e), (Throwable)e);
            }
        }
        throw new RuntimeException("The url [" + url + "] cannot be matched with a JMS provider");
    }
}

