/*
 * Decompiled with CFR 0.152.
 */
package com.stc.jmsjca.sunone;

import com.stc.jmsjca.sunone.SunOneConnectionUrl;
import com.stc.jmsjca.util.ConnectionUrl;
import com.stc.jmsjca.util.Str;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jms.JMSException;

public class SunOneUrlParser
extends ConnectionUrl {
    private SunOneConnectionUrl[] mConnectionUrls;
    public static final String PROT_MQ = "mq";
    public static final String PROT_MQTCP = "mqtcp";
    public static final String PROT_MQSSL = "mqssl";
    public static final String PROT_HTTP = "httpjms";
    public static final String PROT_HTTPS = "httpsjms";
    public static final String[] URL_PREFIXES = new String[]{"mq://", "mqtcp://", "mqssl://", "httpjms://", "httpsjms://"};
    public static final String[] PROTOCOLS = new String[]{"mq", "mqtcp", "mqssl", "httpjms", "httpsjms"};

    public SunOneUrlParser(String s) {
        ArrayList<SunOneConnectionUrl> urls = new ArrayList<SunOneConnectionUrl>();
        StringTokenizer it = new StringTokenizer(s, ",");
        while (it.hasMoreTokens()) {
            String url = it.nextToken();
            urls.add(new SunOneConnectionUrl(url));
        }
        this.mConnectionUrls = urls.toArray(new SunOneConnectionUrl[urls.size()]);
    }

    public void getQueryProperties(Properties toAddTo) {
        SunOneConnectionUrl[] urls = this.getConnectionUrls();
        for (int i = 0; i < urls.length; ++i) {
            urls[i].getQueryProperties(toAddTo);
        }
    }

    public boolean validate() throws JMSException {
        if (this.mConnectionUrls.length == 0) {
            throw new JMSException("URL should be a comma delimited set of URLs");
        }
        boolean protOk = true;
        for (int j = 0; j < this.mConnectionUrls.length; ++j) {
            SunOneConnectionUrl url = this.mConnectionUrls[j];
            protOk = false;
            for (int i = 0; i < PROTOCOLS.length; ++i) {
                if (!PROTOCOLS[i].equals(url.getProtocol())) continue;
                protOk = true;
                break;
            }
            if (protOk) continue;
            throw new JMSException("Invalid protocol [" + url.getProtocol() + "]: should be one of [" + Str.concat((Object[])PROTOCOLS, (String)", ") + "].");
        }
        return protOk;
    }

    public SunOneConnectionUrl[] getConnectionUrls() {
        return this.mConnectionUrls;
    }

    public String getSunOneUrlSet() {
        SunOneConnectionUrl[] urls = this.getConnectionUrls();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < urls.length; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(urls[i].getProtocol() + "://" + urls[i].getHost() + ":" + urls[i].getPort() + "/" + urls[i].getService());
        }
        return buf.toString();
    }

    public String getSunOneUrlAdminSet() {
        SunOneConnectionUrl[] urls = this.getConnectionUrls();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < urls.length; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            if ("jms".equals(urls[i].getService())) {
                buf.append(urls[i].getProtocol() + "://" + urls[i].getHost() + ":" + urls[i].getPort() + "/admin");
                continue;
            }
            if ("jssljms".equals(urls[i].getService())) {
                buf.append(urls[i].getProtocol() + "://" + urls[i].getHost() + ":" + urls[i].getPort() + "/ssladmin");
                continue;
            }
            buf.append(urls[i].getProtocol() + "://" + urls[i].getHost() + ":" + urls[i].getPort() + "/admin");
        }
        return buf.toString();
    }
}

