/*
 * Decompiled with CFR 0.152.
 */
package com.stc.jmsjca.sunone;

import com.stc.jmsjca.util.ConnectionUrl;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.StringTokenizer;

public class SunOneConnectionUrl
extends ConnectionUrl {
    private String mUrl;
    private boolean mParsed;
    private String mProtocol;
    private int mPort;
    private String mHost;
    private String mService;
    private String mPath;
    private String mFile;
    private String mQuery;

    public SunOneConnectionUrl(String url) {
        this.mUrl = url;
    }

    private void parse() {
        if (this.mParsed) {
            return;
        }
        String r = this.mUrl;
        this.mParsed = true;
        int i = r.indexOf("://");
        if (i < 0) {
            throw new RuntimeException("Invalid URL [" + this.mUrl + "]: no protocol specified");
        }
        this.mProtocol = r.substring(0, i);
        if ((i = (r = r.substring(i + "://".length())).indexOf(47)) < 0) {
            i = r.indexOf(63);
        }
        String server = i >= 0 ? r.substring(0, i) : r;
        r = i >= 0 ? r.substring(i) : "";
        i = server.indexOf(58);
        if (i >= 0) {
            this.mHost = server.substring(0, i);
            String port = server.substring(i + 1);
            this.mPort = port.length() > 0 ? Integer.parseInt(port) : -1;
        } else {
            this.mHost = server;
            this.mPort = -1;
        }
        int tunnel = r.indexOf("/tunnel");
        if (r.length() > 0 && tunnel != -1) {
            this.mService = r.substring(0, tunnel + "/tunnel".length());
            r = r.substring(tunnel + "/tunnel".length());
        } else if (r.length() > 0 && r.startsWith("/ssljms")) {
            this.mService = "ssljms";
            r = r.substring("/ssljms".length());
        } else if (r.length() > 0 && r.startsWith("/jms")) {
            this.mService = "jms";
            r = r.substring("jms".length());
        } else {
            this.mService = "";
        }
        this.mFile = r.length() > 0 ? r.substring(0) : "";
        if (!r.startsWith("/")) {
            this.mPath = "";
        } else {
            i = r.indexOf(63);
            if (i >= 0) {
                this.mPath = r.substring(0, i);
                r = r.substring(i);
            } else {
                this.mPath = r;
                r = "";
            }
        }
        if (r.startsWith("?")) {
            this.mQuery = r.substring(1);
        }
    }

    public void setPort(int port) {
        this.parse();
        this.mPort = port;
        this.mUrl = null;
    }

    public void setHost(String host) {
        this.parse();
        this.mHost = host;
        this.mUrl = null;
    }

    public void setService(String service) {
        this.parse();
        this.mService = service;
        this.mUrl = null;
    }

    public String toString() {
        if (this.mUrl == null) {
            StringBuffer url = new StringBuffer();
            url.append(this.mProtocol).append("://").append(this.mHost);
            if (this.mPort != -1) {
                url.append(":").append(this.mPort);
            }
            if (!"".equals(this.mService)) {
                url.append("/").append(this.mService);
            }
            url.append(this.mFile);
            this.mUrl = url.toString();
        }
        return this.mUrl;
    }

    public String getProtocol() {
        this.parse();
        return this.mProtocol;
    }

    public String getHost() {
        this.parse();
        return this.mHost;
    }

    public int getPort() {
        this.parse();
        return this.mPort;
    }

    public String getService() {
        this.parse();
        return this.mService;
    }

    public String getFile() {
        this.parse();
        return this.mFile;
    }

    public String getPath() {
        this.parse();
        return this.mPath;
    }

    public String getQuery() {
        this.parse();
        return this.mQuery;
    }

    public void getQueryProperties(Properties toAddTo) {
        if (this.mUrl == null) {
            return;
        }
        String q = this.getQuery();
        SunOneConnectionUrl.getQueryProperties(q, toAddTo);
    }

    public static void getQueryProperties(String q, Properties toAddTo) {
        if (q == null || q.length() == 0) {
            return;
        }
        StringTokenizer iter = new StringTokenizer(q, "&");
        while (iter.hasMoreElements()) {
            String pair = iter.nextToken();
            int split = pair.indexOf(61);
            if (split <= 0) {
                throw new RuntimeException("Invalid pair [" + pair + "] in query string [" + q + "]");
            }
            String key = pair.substring(0, split);
            String value = pair.substring(split + 1);
            try {
                key = URLDecoder.decode(key, "UTF-8");
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Invalid encoding in [" + pair + "] in query string [" + q + "]", e);
            }
            toAddTo.setProperty(key, value);
        }
    }
}

