/*
 * Decompiled with CFR 0.152.
 */
package com.stc.jmsjca.sunone;

import com.stc.jmsjca.core.RAJMSActivationSpec;
import com.stc.jmsjca.core.RAJMSObjectFactory;
import com.stc.jmsjca.core.RAJMSResourceAdapter;
import com.stc.jmsjca.core.XManagedConnectionFactory;
import com.stc.jmsjca.localization.LocalizedString;
import com.stc.jmsjca.sunone.Localizer;
import com.stc.jmsjca.sunone.SunOneUrlParser;
import com.stc.jmsjca.util.ConnectionUrl;
import com.stc.jmsjca.util.Exc;
import com.stc.jmsjca.util.Logger;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;

public class RASunOneObjectFactory
extends RAJMSObjectFactory
implements Serializable {
    private static Logger sLog = Logger.getLogger((Class)RASunOneObjectFactory.class);
    private static Localizer LOCALE = Localizer.get();

    public int adjustDeliveryMode(int mode, boolean xa) {
        int newMode = mode;
        if (mode == 0) {
            newMode = 3;
        }
        return newMode;
    }

    public boolean canCCEnlistInOnMessage() {
        return false;
    }

    public ConnectionUrl createConnectionUrl(String s) {
        return new SunOneUrlParser(s);
    }

    public boolean validateAndAdjustURL(ConnectionUrl aurl) throws JMSException {
        SunOneUrlParser urlParser = (SunOneUrlParser)aurl;
        return urlParser.validate();
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionFactory createConnectionFactory(int domain, RAJMSResourceAdapter resourceAdapter, RAJMSActivationSpec activationSpec, XManagedConnectionFactory fact, String overrideUrl) throws JMSException {
        Method setProperty;
        void var6_8;
        Properties p = new Properties();
        SunOneUrlParser urlParser = (SunOneUrlParser)this.getProperties(p, resourceAdapter, activationSpec, fact, overrideUrl);
        try {
            switch (domain) {
                case 1: {
                    Object basicConnectionFactory = Class.forName("com.sun.messaging.QueueConnectionFactory").newInstance();
                    break;
                }
                case 3: {
                    Object basicConnectionFactory = Class.forName("com.sun.messaging.XAQueueConnectionFactory").newInstance();
                    break;
                }
                case 2: {
                    Object basicConnectionFactory = Class.forName("com.sun.messaging.TopicConnectionFactory").newInstance();
                    break;
                }
                case 4: {
                    Object basicConnectionFactory = Class.forName("com.sun.messaging.XATopicConnectionFactory").newInstance();
                    break;
                }
                case 6: {
                    Object basicConnectionFactory = Class.forName("com.sun.messaging.ConnectionFactory").newInstance();
                    break;
                }
                case 5: {
                    Object basicConnectionFactory = Class.forName("com.sun.messaging.XAConnectionFactory").newInstance();
                    break;
                }
                default: {
                    throw new JMSException("Logic fault: invalid domain " + domain);
                }
            }
        }
        catch (Exception e) {
            throw Exc.jmsExc((LocalizedString)LOCALE.x("E600: Could not load or instantiate connection factory class: {0}", e), (Exception)e);
        }
        urlParser.getQueryProperties(p);
        try {
            setProperty = var6_8.getClass().getMethod("setProperty", String.class, String.class);
            setProperty.invoke((Object)var6_8, "imqAddressList", urlParser.getSunOneUrlSet());
            setProperty.invoke((Object)var6_8, "imqConnectionFlowLimitEnabled", "true");
        }
        catch (Exception e) {
            throw Exc.jmsExc((LocalizedString)LOCALE.x("E601: Failed to configure connection factory: {0}", e), (Exception)e);
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("sjsmq Normal AddressList: " + urlParser.getSunOneUrlSet()));
        }
        Enumeration<?> names = p.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("imq")) continue;
            String value = p.getProperty(name);
            try {
                setProperty.invoke((Object)var6_8, name, value);
            }
            catch (Exception e) {
                throw Exc.jmsExc((LocalizedString)LOCALE.x("Failed to configure connection factory: {0}", e), (Exception)e);
            }
        }
        return (ConnectionFactory)var6_8;
    }

    public boolean isUrl(String url) {
        if (url != null && url.length() > 0) {
            for (int i = 0; i < SunOneUrlParser.URL_PREFIXES.length; ++i) {
                if (!url.startsWith(SunOneUrlParser.URL_PREFIXES[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void setClientID(Connection connection, boolean isTopic, RAJMSActivationSpec spec, RAJMSResourceAdapter ra) throws JMSException {
        if (isTopic && "Durable".equals(spec.getSubscriptionDurability())) {
            String currentClientId;
            String newClientId = spec.getClientId();
            if (newClientId == null || newClientId.length() == 0) {
                newClientId = "CLIENTID-" + spec.getSubscriptionName();
            }
            if ((currentClientId = connection.getClientID()) == null || currentClientId.length() == 0) {
                this.setClientID(connection, newClientId);
            } else if (!newClientId.equals(currentClientId)) {
                sLog.warn(LOCALE.x("E603: ClientID is already set to [{0}]; cannot set to [{1}] as required in activationspec [{3}]", currentClientId, newClientId, spec));
            }
        }
    }

    public Object getServerMgtMBean(RAJMSResourceAdapter ra, RAJMSActivationSpec spec) throws JMSException {
        String password;
        String username;
        Object ret = null;
        Properties p = new Properties();
        SunOneUrlParser urlParser = (SunOneUrlParser)this.getProperties(p, ra, spec, null, null);
        this.validateAndAdjustURL(urlParser);
        String string = username = spec == null ? null : spec.getUserName();
        if (username == null) {
            username = ra.getUserName();
        }
        String string2 = password = spec == null ? null : spec.getPassword();
        if (password == null) {
            password = ra.getPassword();
        }
        Properties connectionprops = new Properties();
        connectionprops.setProperty("imqAddressList", urlParser.getSunOneUrlAdminSet());
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("sjsmq administration AddressList: " + urlParser.getSunOneUrlAdminSet()));
        }
        try {
            Class<?> c = Class.forName("com.stc.jmsmx.sjsmq.ExternalSJSMQMBean");
            Object mbean = c.newInstance();
            Class[] signatures = new Class[]{Properties.class, String.class, String.class};
            Object[] args = new Object[]{connectionprops, username, password};
            Method method = c.getMethod("setConnectInfo", signatures);
            method.invoke(mbean, args);
            ret = mbean;
        }
        catch (Exception e) {
            throw Exc.jmsExc((LocalizedString)LOCALE.x("E602: Error instantiating or configuring MBean for external SJS MQ server management: {0}", e), (Exception)e);
        }
        return ret;
    }

    public String getJMSServerType() {
        return "SUNONE";
    }

    public static interface BasicConnectionFactory {
        public void setProperty(String var1, String var2);
    }
}

