/*
 * Decompiled with CFR 0.152.
 */
package com.stc.jmsjca.stcms453;

import com.stc.jmsjca.core.RAJMSActivationSpec;
import com.stc.jmsjca.core.RAJMSObjectFactory;
import com.stc.jmsjca.core.RAJMSResourceAdapter;
import com.stc.jmsjca.core.XManagedConnectionFactory;
import com.stc.jmsjca.localization.LocalizedString;
import com.stc.jmsjca.stcms453.Localizer;
import com.stc.jmsjca.util.ConnectionUrl;
import com.stc.jmsjca.util.Exc;
import com.stc.jmsjca.util.UrlParser;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;

public class RASTCMS453ObjectFactory
extends RAJMSObjectFactory
implements Serializable {
    private static final Localizer LOCALE = Localizer.get();
    public static final String PROT = "stcms453";

    public int adjustDeliveryMode(int mode, boolean xa) {
        int newMode = mode;
        if (mode != 3) {
            newMode = 3;
        }
        return newMode;
    }

    public boolean validateAndAdjustURL(ConnectionUrl aurl) throws JMSException {
        boolean hasChanged = false;
        UrlParser url = (UrlParser)aurl;
        if (!PROT.equals(url.getProtocol())) {
            throw new JMSException("Invalid protocol [" + url.getProtocol() + "]: should be " + PROT);
        }
        int port = url.getPort();
        if (port <= 0) {
            throw new JMSException("No port specified in URL [" + url + "]");
        }
        return hasChanged;
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionFactory createConnectionFactory(int domain, RAJMSResourceAdapter resourceAdapter, RAJMSActivationSpec activationSpec, XManagedConnectionFactory fact, String overrideUrl) throws JMSException {
        Properties p = new Properties();
        try {
            UrlParser url = (UrlParser)this.getProperties(p, resourceAdapter, activationSpec, fact, overrideUrl);
            int port = url.getPort();
            p.setProperty("com.seebeyond.jms.sockets.ServerHost", url.getHost());
            p.setProperty("com.seebeyond.jms.sockets.ServerPort", Integer.toString(port));
        }
        catch (Exception ex) {
            JMSException tothrow = new JMSException("Invalid url: " + ex);
            tothrow.initCause((Throwable)ex);
            throw tothrow;
        }
        switch (domain) {
            case 1: {
                String classname = "com.seebeyond.jms.client.STCQueueConnectionFactory";
                break;
            }
            case 3: {
                String classname = "com.seebeyond.jms.client.STCXAQueueConnectionFactory";
                break;
            }
            case 2: {
                String classname = "com.seebeyond.jms.client.STCTopicConnectionFactory";
                break;
            }
            case 4: {
                String classname = "com.seebeyond.jms.client.STCXATopicConnectionFactory";
                break;
            }
            case 5: 
            case 6: {
                throw new JMSException("Unified domain not supported in 4.5.3");
            }
            default: {
                throw new JMSException("Logic fault: invalid domain " + domain);
            }
        }
        try {
            void var7_7;
            Class<?> clazz = Class.forName((String)var7_7);
            return (ConnectionFactory)clazz.getConstructor(Properties.class).newInstance(p);
        }
        catch (Exception e) {
            throw Exc.jmsExc((LocalizedString)LOCALE.x("E500: Failed to instantiate connection factory: {0}", e), (Exception)e);
        }
    }

    public boolean isUrl(String url) {
        return url != null && url.length() > 0 && url.startsWith(PROT);
    }

    public String getJMSServerType() {
        return "STCMS453";
    }
}

