/*
 * Decompiled with CFR 0.152.
 */
package com.stc.jmsjca.stcms;

import com.stc.jmsjca.core.RAJMSActivationSpec;
import com.stc.jmsjca.core.RAJMSObjectFactory;
import com.stc.jmsjca.core.RAJMSResourceAdapter;
import com.stc.jmsjca.core.SessionConnection;
import com.stc.jmsjca.core.XConnectionRequestInfo;
import com.stc.jmsjca.core.XManagedConnection;
import com.stc.jmsjca.core.XManagedConnectionFactory;
import com.stc.jmsjca.localization.LocalizedString;
import com.stc.jmsjca.stcms.Localizer;
import com.stc.jmsjca.stcms.RASTCMSSessionConnection;
import com.stc.jmsjca.util.ConnectionUrl;
import com.stc.jmsjca.util.Exc;
import com.stc.jmsjca.util.Logger;
import com.stc.jmsjca.util.UrlParser;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;

public class RASTCMSObjectFactory
extends RAJMSObjectFactory
implements Serializable {
    private static Logger sLog = Logger.getLogger((Class)RASTCMSObjectFactory.class);
    public static final String PORTPROP = "STCMS.Server.Port";
    public static final String PORTSSLPROP = "STCMS.Server.sPort";
    public static final String PROT_NON_SSL = "stcms";
    public static final String PROT_SSL = "stcmss";
    public static final String PROT_LDAP = "ldap";
    private static final String[] URL_PREFIXES = new String[]{"stcms://", "stcmss://", "ldap://"};
    private static final String SSL_AUTHENTICATION_MODE = "com.stc.jms.ssl.authenticationmode";
    private static final String SSL_AUTHENTICATION_MODE_TRUSTALL = "TrustAll";
    private static final String HOST = "com.stc.jms.sockets.ServerHost";
    private static final String PORT = "com.stc.jms.sockets.ServerPort";
    private static final String AUTOCOMMITXA = "com.stc.jms.autocommitxa";
    private static final String STRICTPERSISTENCE = "com.stc.jms.strictPersistence";
    private static final Localizer LOCALIZER = Localizer.get();
    public static final String STCMSCONTAINERMBEAN = "com.sun.appserv:type=messaging-server-admin-mbean,jmsservertype=stcms,name=Sun_SeeBeyond_JMS_IQ_Manager";

    public boolean validateAndAdjustURL(ConnectionUrl aurl) throws JMSException {
        String host;
        int port;
        UrlParser url = (UrlParser)aurl;
        boolean hasChanged = false;
        boolean isSSL = false;
        if (!PROT_NON_SSL.equals(url.getProtocol())) {
            if (PROT_SSL.equals(url.getProtocol())) {
                isSSL = true;
            } else {
                if (PROT_LDAP.equals(url.getProtocol())) {
                    return false;
                }
                throw new JMSException("Invalid protocol [" + url.getProtocol() + "]: should be stcms or stcmss");
            }
        }
        if ((port = url.getPort()) <= 0) {
            String propname = isSSL ? PORTSSLPROP : PORTPROP;
            String s = System.getProperty(propname);
            if (s != null) {
                port = Integer.parseInt(s);
                url.setPort(port);
                hasChanged = true;
            } else {
                throw new JMSException("No port specified in URL [" + url + "], and also not available in System property [" + propname + "]");
            }
        }
        if ("".equals(host = url.getHost())) {
            url.setHost("localhost");
            hasChanged = true;
        }
        return hasChanged;
    }

    public ConnectionUrl getProperties(Properties p, RAJMSResourceAdapter ra, RAJMSActivationSpec spec, XManagedConnectionFactory fact, String overrideUrl) throws JMSException {
        UrlParser url = (UrlParser)super.getProperties(p, ra, spec, fact, overrideUrl);
        if (PROT_SSL.equals(url.getProtocol()) && p.get(SSL_AUTHENTICATION_MODE) == null) {
            p.setProperty(SSL_AUTHENTICATION_MODE, SSL_AUTHENTICATION_MODE_TRUSTALL);
        }
        int port = url.getPort();
        p.setProperty(HOST, url.getHost());
        p.setProperty(PORT, Integer.toString(port));
        p.setProperty(AUTOCOMMITXA, "true");
        if (fact != null && fact.getOptionStrict()) {
            p.setProperty(STRICTPERSISTENCE, "true");
        }
        return url;
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionFactory createConnectionFactory(int domain, RAJMSResourceAdapter resourceAdapter, RAJMSActivationSpec activationSpec, XManagedConnectionFactory fact, String overrideUrl) throws JMSException {
        Properties p = new Properties();
        this.getProperties(p, resourceAdapter, activationSpec, fact, overrideUrl);
        switch (domain) {
            case 1: {
                String classname = "com.stc.jms.client.STCQueueConnectionFactory";
                break;
            }
            case 3: {
                String classname = "com.stc.jms.client.STCXAQueueConnectionFactory";
                break;
            }
            case 2: {
                String classname = "com.stc.jms.client.STCTopicConnectionFactory";
                break;
            }
            case 4: {
                String classname = "com.stc.jms.client.STCXATopicConnectionFactory";
                break;
            }
            case 6: {
                String classname = "com.stc.jms.client.STCConnectionFactory";
                break;
            }
            case 5: {
                String classname = "com.stc.jms.client.STCXAConnectionFactory";
                break;
            }
            default: {
                throw new JMSException("Logic fault: invalid domain " + domain);
            }
        }
        try {
            void var7_7;
            Class<?> clazz = Class.forName((String)var7_7);
            Constructor<?> constructor = clazz.getConstructor(Properties.class);
            return (ConnectionFactory)constructor.newInstance(p);
        }
        catch (Exception e) {
            throw Exc.jmsExc((LocalizedString)LOCALIZER.x("E301: Could not instantiate STCMS connection factory: {0}", e), (Exception)e);
        }
    }

    public SessionConnection createSessionConnection(Object connectionFactory, RAJMSObjectFactory objfact, RAJMSResourceAdapter ra, XManagedConnection mc, XConnectionRequestInfo descr, boolean isXa, boolean isTransacted, int acknowledgmentMode, Class sessionClass) throws JMSException {
        return new RASTCMSSessionConnection(connectionFactory, objfact, ra, mc, descr, isXa, isTransacted, acknowledgmentMode, sessionClass);
    }

    public boolean isUrl(String url) {
        if (url != null && url.length() > 0) {
            for (int i = 0; i < URL_PREFIXES.length; ++i) {
                if (!url.startsWith(URL_PREFIXES[i])) continue;
                return true;
            }
        }
        return false;
    }

    public Object getServerMgtMBean(RAJMSResourceAdapter ra, RAJMSActivationSpec spec) throws JMSException {
        UrlParser url;
        Properties p;
        String ret = null;
        try {
            p = new Properties();
            url = (UrlParser)this.getProperties(p, ra, spec, null, null);
            this.validateAndAdjustURL((ConnectionUrl)url);
            if (System.getProperty(PORTPROP, null) != null && (url.getHost().equals("localhost") || url.getHost().equals("127.0.0.1"))) {
                int port;
                boolean isSSL = PROT_SSL.equals(url.getProtocol());
                String propname = isSSL ? PORTSSLPROP : PORTPROP;
                String s = System.getProperty(propname);
                int n = port = s != null ? Integer.parseInt(s) : url.getPort() + 1;
                if (url.getPort() == port) {
                    ret = STCMSCONTAINERMBEAN;
                }
            }
        }
        catch (Exception e) {
            sLog.warn(LOCALIZER.x("E300: Non-critical error: could not determine URL for ServerMBean: {0}", e), (Throwable)e);
        }
        if (ret == null) {
            String password;
            String username;
            p = new Properties();
            url = (UrlParser)this.getProperties(p, ra, spec, null, null);
            this.validateAndAdjustURL((ConnectionUrl)url);
            Properties connectionProperties = new Properties();
            connectionProperties.setProperty(HOST, url.getHost());
            connectionProperties.setProperty(PORT, Integer.toString(url.getPort()));
            if (PROT_SSL.equals(url.getProtocol())) {
                if (p.get(SSL_AUTHENTICATION_MODE) == null) {
                    connectionProperties.setProperty(SSL_AUTHENTICATION_MODE, SSL_AUTHENTICATION_MODE_TRUSTALL);
                } else {
                    connectionProperties.setProperty(SSL_AUTHENTICATION_MODE, p.getProperty(SSL_AUTHENTICATION_MODE));
                }
            }
            String string = username = spec == null ? null : spec.getUserName();
            if (username == null) {
                username = ra.getUserName();
            }
            String string2 = password = spec == null ? null : spec.getPassword();
            if (password == null) {
                password = ra.getPassword();
            }
            try {
                Class<?> c = Class.forName("com.stc.jmsmx.stcms.ExternalStcmsMBean");
                Object stcmsMBean = c.newInstance();
                Class[] signatures = new Class[]{Properties.class, String.class, String.class};
                Object[] args = new Object[]{connectionProperties, username, password};
                Method method = c.getMethod("setConnectInfo", signatures);
                method.invoke(stcmsMBean, args);
                ret = stcmsMBean;
            }
            catch (Exception e) {
                throw Exc.jmsExc((LocalizedString)LOCALIZER.x("E302: Error instantiating or configuring MBean for external JMS server management: {0}", e), (Exception)e);
            }
        }
        return ret;
    }

    public String getJMSServerType() {
        return "STCMS";
    }
}

