/*
 * Decompiled with CFR 0.152.
 */
package com.stc.jmsjca.jndi;

import com.stc.jmsjca.core.AdminDestination;
import com.stc.jmsjca.core.RAJMSActivationSpec;
import com.stc.jmsjca.core.RAJMSObjectFactory;
import com.stc.jmsjca.core.RAJMSResourceAdapter;
import com.stc.jmsjca.core.SessionConnection;
import com.stc.jmsjca.core.XConnectionRequestInfo;
import com.stc.jmsjca.core.XManagedConnection;
import com.stc.jmsjca.core.XManagedConnectionFactory;
import com.stc.jmsjca.jndi.JNDISessionConnection;
import com.stc.jmsjca.jndi.Localizer;
import com.stc.jmsjca.jndi.RAJNDIResourceAdapter;
import com.stc.jmsjca.localization.LocalizedString;
import com.stc.jmsjca.util.ConnectionUrl;
import com.stc.jmsjca.util.Exc;
import com.stc.jmsjca.util.Logger;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XAQueueSession;
import javax.jms.XATopicConnectionFactory;
import javax.jms.XATopicSession;
import javax.naming.InitialContext;

public class RAJNDIObjectFactory
extends RAJMSObjectFactory
implements Serializable {
    private static Logger sLog = Logger.getLogger((Class)RAJNDIObjectFactory.class);
    public static final String JNDI_PREFIX = "jndi://";
    private static final String[] URL_PREFIXES = new String[]{"jndi://"};
    private static final Localizer LOCALE = Localizer.get();

    private void safeClose(InitialContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    Object getJndiObject(Properties p, String name) throws JMSException {
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("Looking up JNDI object " + name));
        }
        if (name == null || name.length() == 0) {
            throw new JMSException("The JNDI name is null");
        }
        InitialContext ctx = null;
        try {
            ctx = p.get("java.naming.factory.initial") == null ? new InitialContext() : new InitialContext(p);
            Object object = ctx.lookup(name);
            this.safeClose(ctx);
            return object;
        }
        catch (Exception e) {
            try {
                throw Exc.jmsExc((LocalizedString)LOCALE.x("E400: Could not find JNDI object by name [{0}]: {1}", name, e), (Exception)e);
            }
            catch (Throwable throwable) {
                this.safeClose(ctx);
                throw throwable;
            }
        }
    }

    public Object getJndiObject(RAJMSResourceAdapter resourceAdapter, RAJMSActivationSpec activationSpec, XManagedConnectionFactory fact, String overrideUrl, String name) throws JMSException {
        Properties p = new Properties();
        this.getProperties(p, resourceAdapter, activationSpec, fact, overrideUrl);
        return this.getJndiObject(p, name);
    }

    public ConnectionFactory createConnectionFactory(int domain, RAJMSResourceAdapter resourceAdapter, RAJMSActivationSpec activationSpec, XManagedConnectionFactory fact, String overrideUrl) throws JMSException {
        Properties p = new Properties();
        this.getProperties(p, resourceAdapter, activationSpec, fact, overrideUrl);
        switch (domain) {
            case 1: {
                return (QueueConnectionFactory)this.getJndiObject(p, p.getProperty("JMSJCA.QueueCF"));
            }
            case 3: {
                return (XAQueueConnectionFactory)this.getJndiObject(p, p.getProperty("JMSJCA.QueueCF"));
            }
            case 2: {
                return (TopicConnectionFactory)this.getJndiObject(p, p.getProperty("JMSJCA.TopicCF"));
            }
            case 4: {
                return (XATopicConnectionFactory)this.getJndiObject(p, p.getProperty("JMSJCA.TopicCF"));
            }
            case 5: 
            case 6: {
                return (ConnectionFactory)this.getJndiObject(p, p.getProperty("JMSJCA.UnifiedCF"));
            }
        }
        throw new JMSException("Logic fault: invalid domain " + domain);
    }

    public ConnectionUrl getProperties(Properties p, RAJMSResourceAdapter resourceAdapter, RAJMSActivationSpec spec, XManagedConnectionFactory fact, String overrideUrl) throws JMSException {
        ConnectionUrl url = super.getProperties(p, resourceAdapter, spec, fact, overrideUrl);
        if (resourceAdapter instanceof RAJNDIResourceAdapter) {
            RAJNDIResourceAdapter ra = (RAJNDIResourceAdapter)resourceAdapter;
            if (ra.getQueueConnectionFactoryJndiName() != null) {
                p.setProperty("JMSJCA.QueueCF", ra.getQueueConnectionFactoryJndiName());
            }
            if (ra.getTopicConnectionFactoryJndiName() != null) {
                p.setProperty("JMSJCA.TopicCF", ra.getTopicConnectionFactoryJndiName());
            }
            if (ra.getUnifiedConnectionFactoryJndiName() != null) {
                p.setProperty("JMSJCA.UnifiedCF", ra.getUnifiedConnectionFactoryJndiName());
            }
            if (ra.getInitialContextFactory() != null) {
                p.setProperty("java.naming.factory.initial", ra.getInitialContextFactory());
            }
            if (ra.getProviderUrl() != null) {
                p.setProperty("java.naming.provider.url", ra.getProviderUrl());
            }
        }
        return url;
    }

    public SessionConnection createSessionConnection(Object connectionFactory, RAJMSObjectFactory objfact, RAJMSResourceAdapter ra, XManagedConnection mc, XConnectionRequestInfo descr, boolean isXa, boolean isTransacted, int acknowledgmentMode, Class sessionClass) throws JMSException {
        return new JNDISessionConnection(connectionFactory, objfact, ra, mc, descr, isXa, isTransacted, acknowledgmentMode, sessionClass);
    }

    public Destination createDestination(Session sess, boolean isXA, boolean isTopic, RAJMSActivationSpec activationSpec, XManagedConnectionFactory fact, RAJMSResourceAdapter ra, String destName) throws JMSException {
        Object ret;
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("createDestination(" + destName + ")"));
        }
        if ((ret = this.adminDestinationLookup(destName)) != null && ret instanceof AdminDestination) {
            destName = ((AdminDestination)ret).getName();
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)(ret + " is an admin object: embedded name: " + destName));
            }
            ret = null;
        }
        if (ret == null && destName.startsWith(JNDI_PREFIX)) {
            String name = destName.substring(JNDI_PREFIX.length());
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)(destName + " is a jndi object: looking up [" + name + "]"));
            }
            ret = (Destination)this.getJndiObject(ra, activationSpec, fact, null, name);
        }
        if (ret == null) {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("Creating " + destName + " using createQueue()/createTopic()"));
            }
            ret = isXA ? (isTopic ? ((XATopicSession)sess).getTopicSession().createTopic(destName) : ((XAQueueSession)sess).getQueueSession().createQueue(destName)) : (isTopic ? ((TopicSession)sess).createTopic(destName) : ((QueueSession)sess).createQueue(destName));
        }
        return ret;
    }

    public boolean isUrl(String url) {
        if (url != null && url.length() > 0) {
            for (int i = 0; i < URL_PREFIXES.length; ++i) {
                if (!url.startsWith(URL_PREFIXES[i])) continue;
                return true;
            }
        }
        return false;
    }

    public String getJMSServerType() {
        return "GENERIC";
    }
}

