/*
 * Decompiled with CFR 0.152.
 */
package com.stc.jmsjca.jboss;

import com.stc.jmsjca.core.RAJMSActivationSpec;
import com.stc.jmsjca.core.RAJMSObjectFactory;
import com.stc.jmsjca.core.RAJMSResourceAdapter;
import com.stc.jmsjca.core.XManagedConnectionFactory;
import com.stc.jmsjca.jboss.Localizer;
import com.stc.jmsjca.localization.LocalizedString;
import com.stc.jmsjca.util.Exc;
import com.stc.jmsjca.util.Logger;
import com.stc.jmsjca.util.Str;
import com.stc.jmsjca.util.UrlParser;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.InitialContext;

public class RAJBossObjectFactory
extends RAJMSObjectFactory
implements Serializable {
    private static Logger sLog = Logger.getLogger((Class)RAJBossObjectFactory.class);
    public static final String PROT_JBOSS = "jboss";
    public static final String JNDI_FACTORY = "org.jnp.interfaces.NamingContextFactory";
    public static final String PKGS = "org.jboss.naming:org.jnp.interfaces";
    public static final String DEFAULT_XACF = "UIL2XAConnectionFactory";
    private static final String[] URL_PREFIXES = new String[]{"jboss://"};
    private static final Localizer LOCALE = Localizer.get();

    public int adjustDeliveryMode(int mode, boolean xa) {
        int newMode = mode;
        if (mode == 0) {
            newMode = 3;
        }
        return newMode;
    }

    public static void safeClose(InitialContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Object getJndiObject(Properties p, String name) throws JMSException {
        Object object;
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("Looking up JNDI object " + name));
        }
        if (name == null || name.length() == 0) {
            throw new JMSException("The JNDI name is null");
        }
        InitialContext ctx = null;
        try {
            ctx = p.get("java.naming.factory.initial") == null ? new InitialContext() : new InitialContext(p);
            object = ctx.lookup(name);
        }
        catch (Exception e) {
            try {
                throw Exc.jmsExc((LocalizedString)LOCALE.x("E201: Could not find JNDI object by name [{0}]; properties={2}: {1}", name, e, Str.serializeProperties((Properties)p)), (Exception)e);
            }
            catch (Throwable throwable) {
                RAJBossObjectFactory.safeClose(ctx);
                throw throwable;
            }
        }
        RAJBossObjectFactory.safeClose(ctx);
        return object;
    }

    public ConnectionFactory createConnectionFactory(int domain, RAJMSResourceAdapter resourceAdapter, RAJMSActivationSpec activationSpec, XManagedConnectionFactory fact, String overrideUrl) throws JMSException {
        Properties p = new Properties();
        UrlParser url = (UrlParser)this.getProperties(p, resourceAdapter, activationSpec, fact, overrideUrl);
        String urlstr = "jnp://" + url.getHost() + ":" + url.getPort();
        Properties q = new Properties();
        q.setProperty("java.naming.factory.initial", JNDI_FACTORY);
        q.setProperty("java.naming.provider.url", urlstr);
        q.setProperty("java.naming.factory.url.pkgs", PKGS);
        String name = p.getProperty("xacf", DEFAULT_XACF);
        switch (domain) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                Object o = this.getJndiObject(q, name);
                return (ConnectionFactory)o;
            }
        }
        throw new JMSException("Logic fault: invalid domain " + domain);
    }

    public boolean isUrl(String url) {
        if (url != null && url.length() > 0) {
            for (int i = 0; i < URL_PREFIXES.length; ++i) {
                if (!url.startsWith(URL_PREFIXES[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void setClientID(Connection connection, boolean isTopic, RAJMSActivationSpec spec, RAJMSResourceAdapter ra) throws JMSException {
        if (isTopic && "Durable".equals(spec.getSubscriptionDurability())) {
            String currentClientId;
            String newClientId = spec.getClientId();
            if (newClientId == null || newClientId.length() == 0) {
                newClientId = "CLIENTID-" + spec.getSubscriptionName();
            }
            if ((currentClientId = connection.getClientID()) == null || currentClientId.length() == 0) {
                this.setClientID(connection, newClientId);
            } else if (!spec.getClientId().equals(currentClientId)) {
                sLog.warn(LOCALE.x("E200: ClientID is already set to [{0}]; cannot set to [{1}] as required in activationspec [{2}]", currentClientId, spec.getClientId(), spec));
            }
        }
    }

    public String getJMSServerType() {
        return "JBOSS";
    }
}

