/*
 * Decompiled with CFR 0.152.
 */
package com.stc.jmsjca.sunone;

import com.stc.jmsjca.core.RAJMSActivationSpec;
import com.stc.jmsjca.core.RAJMSObjectFactory;
import com.stc.jmsjca.core.RAJMSResourceAdapter;
import com.stc.jmsjca.core.XManagedConnectionFactory;
import com.stc.jmsjca.localization.LocalizedString;
import com.stc.jmsjca.sunone.Localizer;
import com.stc.jmsjca.sunone.SunOneConnectionUrl;
import com.stc.jmsjca.sunone.SunOneUrlParser;
import com.stc.jmsjca.util.ConnectionUrl;
import com.stc.jmsjca.util.Exc;
import com.stc.jmsjca.util.Logger;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class RASunOneObjectFactory
extends RAJMSObjectFactory
implements Serializable {
    private static Logger sLog = Logger.getLogger((Class)RASunOneObjectFactory.class);
    private static Localizer LOCALE = Localizer.get();

    public int adjustDeliveryMode(int mode, boolean xa) {
        int newMode = mode;
        if (mode == 0) {
            newMode = 3;
        }
        return newMode;
    }

    public ConnectionUrl createConnectionUrl(String s) {
        return new SunOneUrlParser(s);
    }

    private String getInternalKey(String hostOrUsername) {
        if (hostOrUsername != null && hostOrUsername.startsWith("(") && hostOrUsername.endsWith(")") && hostOrUsername.length() > 2) {
            String key = hostOrUsername.substring(1, hostOrUsername.length() - 1);
            return key;
        }
        return null;
    }

    private ConnectionValues getConnectionValues(String key) throws Exception {
        Class<?> c = Class.forName("com.sun.enterprise.admin.common.MBeanServerFactory");
        Method m = c.getMethod("getMBeanServer", new Class[0]);
        MBeanServer mBeanServer = (MBeanServer)m.invoke(null, new Object[0]);
        ObjectName objName = new ObjectName("com.sun.appserv:type=jms-host,name=" + key + ",config=server-config,category=config");
        ConnectionValues ret = new ConnectionValues();
        ret.host = (String)mBeanServer.getAttribute(objName, "host");
        ret.port = (String)mBeanServer.getAttribute(objName, "port");
        ret.password = (String)mBeanServer.getAttribute(objName, "admin-user-name");
        ret.username = (String)mBeanServer.getAttribute(objName, "admin-password");
        return ret;
    }

    public boolean validateAndAdjustURL(ConnectionUrl aurl) throws JMSException {
        SunOneUrlParser urlParser = (SunOneUrlParser)aurl;
        urlParser.validate();
        boolean hasChanged = false;
        SunOneConnectionUrl[] urls = urlParser.getConnectionUrls();
        for (int i = 0; i < urls.length; ++i) {
            ConnectionValues v;
            String host;
            String key;
            SunOneConnectionUrl url = urls[i];
            if (!url.getProtocol().equals("mq") || (key = this.getInternalKey(host = url.getHost())) == null) continue;
            try {
                v = this.getConnectionValues(key);
            }
            catch (Exception e) {
                throw Exc.jmsExc((LocalizedString)LOCALE.x("E307: Could not obtain connection info for {0} (from [{1}]): {2}", key, (Object)url, e));
            }
            url.setHost(v.host);
            url.setPort(Integer.parseInt(v.port));
            hasChanged = true;
        }
        return hasChanged;
    }

    public Connection createConnection(Object fact, int domain, RAJMSActivationSpec activationSpec, RAJMSResourceAdapter ra, String username, String password) throws JMSException {
        String key = this.getInternalKey(username);
        if (key != null) {
            ConnectionValues v;
            try {
                v = this.getConnectionValues(key);
            }
            catch (Exception e) {
                throw Exc.jmsExc((LocalizedString)LOCALE.x("E307: Could not obtain connection info for {0} (from [{1}]): {2}", key, username, e));
            }
            username = v.username;
            password = v.password;
        }
        return super.createConnection(fact, domain, activationSpec, ra, username, password);
    }

    public ConnectionFactory createConnectionFactory(int domain, RAJMSResourceAdapter resourceAdapter, RAJMSActivationSpec activationSpec, XManagedConnectionFactory fact, String overrideUrl) throws JMSException {
        Method setProperty;
        Object basicConnectionFactory;
        Properties p = new Properties();
        SunOneUrlParser urlParser = (SunOneUrlParser)this.getProperties(p, resourceAdapter, activationSpec, fact, overrideUrl);
        try {
            switch (domain) {
                case 1: {
                    basicConnectionFactory = Class.forName("com.sun.messaging.QueueConnectionFactory").newInstance();
                    break;
                }
                case 3: {
                    basicConnectionFactory = Class.forName("com.sun.messaging.XAQueueConnectionFactory").newInstance();
                    break;
                }
                case 2: {
                    basicConnectionFactory = Class.forName("com.sun.messaging.TopicConnectionFactory").newInstance();
                    break;
                }
                case 4: {
                    basicConnectionFactory = Class.forName("com.sun.messaging.XATopicConnectionFactory").newInstance();
                    break;
                }
                case 6: {
                    basicConnectionFactory = Class.forName("com.sun.messaging.ConnectionFactory").newInstance();
                    break;
                }
                case 5: {
                    basicConnectionFactory = Class.forName("com.sun.messaging.XAConnectionFactory").newInstance();
                    break;
                }
                default: {
                    throw Exc.jmsExc((LocalizedString)LOCALE.x("E304: Logic fault: invalid domain {0}", Integer.toString(domain)));
                }
            }
        }
        catch (Exception e) {
            throw Exc.jmsExc((LocalizedString)LOCALE.x("E300: Could not load or instantiate connection factory class: {0}", e), (Exception)e);
        }
        urlParser.getQueryProperties(p);
        try {
            setProperty = basicConnectionFactory.getClass().getMethod("setProperty", String.class, String.class);
            setProperty.invoke(basicConnectionFactory, "imqAddressList", urlParser.getSunOneUrlSet());
            setProperty.invoke(basicConnectionFactory, "imqConnectionFlowLimitEnabled", "true");
        }
        catch (Exception e) {
            throw Exc.jmsExc((LocalizedString)LOCALE.x("E301: Failed to configure connection factory: {0}", e), (Exception)e);
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("sjsmq Normal AddressList: " + urlParser.getSunOneUrlSet()));
        }
        Enumeration<?> names = p.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("imq")) continue;
            String value = p.getProperty(name);
            try {
                setProperty.invoke(basicConnectionFactory, name, value);
            }
            catch (Exception e) {
                throw Exc.jmsExc((LocalizedString)LOCALE.x("Failed to configure connection factory: {0}", e), (Exception)e);
            }
        }
        return (ConnectionFactory)basicConnectionFactory;
    }

    public boolean isUrl(String url) {
        if (url != null && url.length() > 0) {
            for (int i = 0; i < SunOneUrlParser.URL_PREFIXES.length; ++i) {
                if (!url.startsWith(SunOneUrlParser.URL_PREFIXES[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void setClientID(Connection connection, boolean isTopic, RAJMSActivationSpec spec, RAJMSResourceAdapter ra) throws JMSException {
        if (isTopic && "Durable".equals(spec.getSubscriptionDurability())) {
            String currentClientId;
            String newClientId = spec.getClientId();
            if (newClientId == null || newClientId.length() == 0) {
                newClientId = "CLIENTID-" + spec.getSubscriptionName();
            }
            if ((currentClientId = connection.getClientID()) == null || currentClientId.length() == 0) {
                this.setClientID(connection, newClientId);
            } else if (!newClientId.equals(currentClientId)) {
                sLog.warn(LOCALE.x("E303: ClientID is already set to [{0}]; cannot set to [{1}] as required in activationspec [{3}]", currentClientId, newClientId, spec));
            }
        }
    }

    public Object getServerMgtMBean(RAJMSResourceAdapter ra, RAJMSActivationSpec spec) throws JMSException {
        String password;
        String username;
        Object ret = null;
        Properties p = new Properties();
        SunOneUrlParser urlParser = (SunOneUrlParser)this.getProperties(p, ra, spec, null, null);
        this.validateAndAdjustURL(urlParser);
        String string = username = spec == null ? null : spec.getUserName();
        if (username == null) {
            username = ra.getUserName();
        }
        String string2 = password = spec == null ? null : spec.getClearTextPassword();
        if (password == null) {
            password = ra.getClearTextPassword();
        }
        Properties connectionprops = new Properties();
        connectionprops.setProperty("imqAddressList", urlParser.getSunOneUrlAdminSet());
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("sjsmq administration AddressList: " + urlParser.getSunOneUrlAdminSet()));
        }
        try {
            Class<?> c = Class.forName("com.stc.jmsmx.sjsmq.ExternalSJSMQMBean");
            Object mbean = c.newInstance();
            Class[] signatures = new Class[]{Properties.class, String.class, String.class};
            Object[] args = new Object[]{connectionprops, username, password};
            Method method = c.getMethod("setConnectInfo", signatures);
            method.invoke(mbean, args);
            ret = mbean;
        }
        catch (Exception e) {
            throw Exc.jmsExc((LocalizedString)LOCALE.x("E302: Error instantiating or configuring MBean for external SJS MQ server management: {0}", e), (Exception)e);
        }
        return ret;
    }

    public String getJMSServerType() {
        return "SUNONE";
    }

    private static class ConnectionValues {
        String host;
        String port;
        String username;
        String password;

        private ConnectionValues() {
        }
    }
}

