package com.sencha.gxt.explorer.rebind.model;

import com.google.gwt.core.ext.typeinfo.JClassType;

public class SourceModel {
  public static enum FileType {
    JAVA, CSS, XML, JSON, HTML, FOLDER;
  }

  private final String name;
  private final FileType type;
  private final String url;

  private String path;
  private JClassType jclassType;

  public SourceModel(JClassType type) {
    this.name = type.getSimpleSourceName() + ".java";
    this.type = FileType.JAVA;
    this.url = "code/" + type.getParameterizedQualifiedSourceName() + ".html";

    this.jclassType = type;
  }

  public SourceModel(String path) {
    this.name = path.substring(path.lastIndexOf('/') + 1);
    this.type = path.endsWith("css") ? FileType.CSS : (path.endsWith("xml") ? FileType.XML : (path.endsWith("html") ? FileType.HTML: FileType.JSON));
    this.url = "code/" + path.replace('/', '.') + ".html";

    this.path = path;
  }

  public SourceModel(String name, FileType type) {
    this.name = name;
    this.type = type;
    this.url = null;
  }

  public String getName() {
    return name;
  }

  public String getUrl() {
    return url;
  }

  public FileType getType() {
    return type;
  }

  public String getPath() {
    assert type != FileType.JAVA;
    return path;
  }

  public JClassType getJClassType() {
    assert type == FileType.JAVA;
    return jclassType;
  }
}
