package com.sencha.gxt.explorer.client.misc;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.explorer.client.model.Example.Detail;
import com.sencha.gxt.widget.core.client.Slider;
import com.sencha.gxt.widget.core.client.event.SelectEvent;

@Detail(name = "Slider (UiBinder)", icon = "slider", category = "Misc", files = "SliderUiBinderExample.ui.xml")
public class SliderUiBinderExample implements IsWidget, EntryPoint {

  interface MyUiBinder extends UiBinder<Widget, SliderUiBinderExample> {
  }

  private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);

  @UiField
  Slider slider1;

  @UiField(provided = true)
  Slider slider2 = new Slider(true);

  public Widget asWidget() {
    return uiBinder.createAndBindUi(this);
  }

  public void onModuleLoad() {
    RootPanel.get().add(asWidget());
  }

  @UiHandler("slider1Button")
  public void slider1ButtonClicked(SelectEvent event) {
    slider1.setValue(40);
  }

  @UiHandler("slider2Button")
  public void slider2ButtonClicked(SelectEvent event) {
    slider2.setValue(40);
  }
}
