package com.sencha.gxt.explorer.client.layout.border;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.explorer.client.model.Example.Detail;
import com.sencha.gxt.widget.core.client.Component;
import com.sencha.gxt.widget.core.client.container.BorderLayoutContainer.BorderLayoutData;
import com.sencha.gxt.widget.core.client.container.MarginData;

@Detail(name = "BorderLayout (UiBinder)", icon = "borderlayout", category = "Layouts", fit = true, files = {"BorderLayoutUiBinderExample.ui.xml"})
public class BorderLayoutUiBinderExample implements IsWidget, EntryPoint {

  interface MyUiBinder extends UiBinder<Component, BorderLayoutUiBinderExample> {
  }

  private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);
  
  @UiField(provided=true) MarginData outerData = new MarginData(20);
  @UiField(provided=true) BorderLayoutData northData  = new BorderLayoutData(100);
  @UiField(provided=true) BorderLayoutData westData   = new BorderLayoutData(150);
  @UiField(provided=true) MarginData centerData = new MarginData();
  @UiField(provided=true) BorderLayoutData eastData   = new BorderLayoutData(150);  
  @UiField(provided=true) BorderLayoutData southData  = new BorderLayoutData(100);
  

  public Widget asWidget() {
    
    northData.setMargins(new Margins(5));
    westData.setMargins(new Margins(0, 5, 0, 5));
    westData.setCollapsible(true);
    westData.setSplit(true);
    eastData.setMargins(new Margins(0, 5, 0, 5));
    southData.setMargins(new Margins(5));
    
    return uiBinder.createAndBindUi(this);
  }

  public void onModuleLoad() {
    RootPanel.get().add(asWidget());
  }

}
